/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLMemento
implements IMemento {
    private Document factory;
    private Element element;

    public static XMLMemento createReadRoot(Reader reader) throws WorkbenchException {
        return XMLMemento.createReadRoot(reader, null);
    }

    public static XMLMemento createReadRoot(Reader reader, String string) throws WorkbenchException {
        Object object;
        String string2 = null;
        Exception exception = null;
        try {
            object = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            InputSource inputSource = new InputSource(reader);
            if (string != null) {
                inputSource.setSystemId(string);
            }
            Document document = documentBuilder.parse(inputSource);
            NodeList nodeList = document.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node instanceof Element) {
                    return new XMLMemento(document, (Element)node);
                }
                ++n;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            exception = parserConfigurationException;
            string2 = WorkbenchMessages.XMLMemento_parserConfigError;
        }
        catch (IOException iOException) {
            exception = iOException;
            string2 = WorkbenchMessages.XMLMemento_ioError;
        }
        catch (SAXException sAXException) {
            exception = sAXException;
            string2 = WorkbenchMessages.XMLMemento_formatError;
        }
        object = null;
        if (exception != null) {
            object = exception.getMessage();
        }
        if (object == null || ((String)object).length() == 0) {
            object = string2 != null ? string2 : WorkbenchMessages.XMLMemento_noElement;
        }
        throw new WorkbenchException((String)object, exception);
    }

    public static XMLMemento createWriteRoot(String string) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement(string);
            document.appendChild(element);
            return new XMLMemento(document, element);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new Error(parserConfigurationException.getMessage());
        }
    }

    public XMLMemento(Document document, Element element) {
        this.factory = document;
        this.element = element;
    }

    public IMemento createChild(String string) {
        Element element = this.factory.createElement(string);
        this.element.appendChild(element);
        return new XMLMemento(this.factory, element);
    }

    public IMemento createChild(String string, String string2) {
        Element element = this.factory.createElement(string);
        element.setAttribute("IMemento.internal.id", string2 == null ? "" : string2);
        this.element.appendChild(element);
        return new XMLMemento(this.factory, element);
    }

    public IMemento copyChild(IMemento iMemento) {
        Element element = ((XMLMemento)iMemento).element;
        Element element2 = (Element)this.factory.importNode(element, true);
        this.element.appendChild(element2);
        return new XMLMemento(this.factory, element2);
    }

    public IMemento getChild(String string) {
        NodeList nodeList = this.element.getChildNodes();
        int n = nodeList.getLength();
        if (n == 0) {
            return null;
        }
        int n2 = 0;
        while (n2 < n) {
            Element element;
            Node node = nodeList.item(n2);
            if (node instanceof Element && (element = (Element)node).getNodeName().equals(string)) {
                return new XMLMemento(this.factory, element);
            }
            ++n2;
        }
        return null;
    }

    public IMemento[] getChildren(String string) {
        NodeList nodeList = this.element.getChildNodes();
        int n = nodeList.getLength();
        if (n == 0) {
            return new IMemento[0];
        }
        ArrayList<Element> arrayList = new ArrayList<Element>(n);
        int n2 = 0;
        while (n2 < n) {
            Element element;
            Node node = nodeList.item(n2);
            if (node instanceof Element && (element = (Element)node).getNodeName().equals(string)) {
                arrayList.add(element);
            }
            ++n2;
        }
        n = arrayList.size();
        IMemento[] iMementoArray = new IMemento[n];
        int n3 = 0;
        while (n3 < n) {
            iMementoArray[n3] = new XMLMemento(this.factory, (Element)arrayList.get(n3));
            ++n3;
        }
        return iMementoArray;
    }

    public Float getFloat(String string) {
        Attr attr = this.element.getAttributeNode(string);
        if (attr == null) {
            return null;
        }
        String string2 = attr.getValue();
        try {
            return new Float(string2);
        }
        catch (NumberFormatException numberFormatException) {
            WorkbenchPlugin.log("Memento problem - Invalid float for key: " + string + " value: " + string2, numberFormatException);
            return null;
        }
    }

    public String getID() {
        return this.element.getAttribute("IMemento.internal.id");
    }

    public Integer getInteger(String string) {
        Attr attr = this.element.getAttributeNode(string);
        if (attr == null) {
            return null;
        }
        String string2 = attr.getValue();
        try {
            return new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {
            WorkbenchPlugin.log("Memento problem - invalid integer for key: " + string + " value: " + string2, numberFormatException);
            return null;
        }
    }

    public String getString(String string) {
        Attr attr = this.element.getAttributeNode(string);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public String getTextData() {
        Text text = this.getTextNode();
        if (text != null) {
            return text.getData();
        }
        return null;
    }

    private Text getTextNode() {
        NodeList nodeList = this.element.getChildNodes();
        int n = nodeList.getLength();
        if (n == 0) {
            return null;
        }
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node instanceof Text) {
                return (Text)node;
            }
            ++n2;
        }
        return null;
    }

    private void putElement(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = (Attr)namedNodeMap.item(n2);
            this.putString(attr.getName(), attr.getValue());
            ++n2;
        }
        NodeList nodeList = element.getChildNodes();
        n = nodeList.getLength();
        int n3 = 0;
        while (n3 < n) {
            Node node = nodeList.item(n3);
            if (node instanceof Element) {
                XMLMemento xMLMemento = (XMLMemento)this.createChild(node.getNodeName());
                xMLMemento.putElement((Element)node);
            }
            ++n3;
        }
    }

    public void putFloat(String string, float f) {
        this.element.setAttribute(string, String.valueOf(f));
    }

    public void putInteger(String string, int n) {
        this.element.setAttribute(string, String.valueOf(n));
    }

    public void putMemento(IMemento iMemento) {
        this.putElement(((XMLMemento)iMemento).element);
    }

    public void putString(String string, String string2) {
        if (string2 == null) {
            return;
        }
        this.element.setAttribute(string, string2);
    }

    public void putTextData(String string) {
        Text text = this.getTextNode();
        if (text == null) {
            text = this.factory.createTextNode(string);
            this.element.insertBefore(text, this.element.getFirstChild());
        } else {
            text.setData(string);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(Writer writer) throws IOException {
        DOMWriter dOMWriter = new DOMWriter(writer);
        try {
            dOMWriter.print(this.element);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            dOMWriter.close();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        dOMWriter.close();
    }

    private static final class DOMWriter
    extends PrintWriter {
        private int tab = 0;
        private static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

        public DOMWriter(Writer writer) {
            super(writer);
            this.println(XML_VERSION);
        }

        public void print(Element element) {
            boolean bl = element.hasChildNodes();
            this.startTag(element, bl);
            if (bl) {
                ++this.tab;
                boolean bl2 = false;
                NodeList nodeList = element.getChildNodes();
                int n = 0;
                while (n < nodeList.getLength()) {
                    Node node = nodeList.item(n);
                    if (node instanceof Element) {
                        if (!bl2) {
                            this.println();
                            this.printTabulation();
                        }
                        this.print((Element)nodeList.item(n));
                        bl2 = false;
                    } else if (node instanceof Text) {
                        this.print(DOMWriter.getEscaped(node.getNodeValue()));
                        bl2 = true;
                    }
                    ++n;
                }
                --this.tab;
                if (!bl2) {
                    this.println();
                    this.printTabulation();
                }
                this.endTag(element);
            }
        }

        private void printTabulation() {
        }

        private void startTag(Element element, boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<");
            stringBuffer.append(element.getTagName());
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Attr attr = (Attr)namedNodeMap.item(n);
                stringBuffer.append(" ");
                stringBuffer.append(attr.getName());
                stringBuffer.append("=\"");
                stringBuffer.append(DOMWriter.getEscaped(String.valueOf(attr.getValue())));
                stringBuffer.append("\"");
                ++n;
            }
            stringBuffer.append(bl ? ">" : "/>");
            this.print(stringBuffer.toString());
        }

        private void endTag(Element element) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("</");
            stringBuffer.append(element.getNodeName());
            stringBuffer.append(">");
            this.print(stringBuffer.toString());
        }

        private static void appendEscapedChar(StringBuffer stringBuffer, char c) {
            String string = DOMWriter.getReplacement(c);
            if (string != null) {
                stringBuffer.append('&');
                stringBuffer.append(string);
                stringBuffer.append(';');
            } else {
                stringBuffer.append(c);
            }
        }

        private static String getEscaped(String string) {
            StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
            int n = 0;
            while (n < string.length()) {
                DOMWriter.appendEscapedChar(stringBuffer, string.charAt(n));
                ++n;
            }
            return stringBuffer.toString();
        }

        private static String getReplacement(char c) {
            switch (c) {
                case '<': {
                    return "lt";
                }
                case '>': {
                    return "gt";
                }
                case '\"': {
                    return "quot";
                }
                case '\'': {
                    return "apos";
                }
                case '&': {
                    return "amp";
                }
                case '\r': {
                    return "#x0D";
                }
                case '\n': {
                    return "#x0A";
                }
                case '\t': {
                    return "#x09";
                }
            }
            return null;
        }
    }
}

