/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.expressions.DefinitionRegistry;
import org.eclipse.core.internal.expressions.Expressions;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Element;

public class ReferenceExpression
extends Expression {
    private static DefinitionRegistry fgDefinitionRegistry = null;
    private static final String ATT_DEFINITION_ID = "definitionId";
    private static final int HASH_INITIAL;
    private String fDefinitionId;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.internal.expressions.ReferenceExpression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HASH_INITIAL = clazz.getName().hashCode();
    }

    private static DefinitionRegistry getDefinitionRegistry() {
        if (fgDefinitionRegistry == null) {
            fgDefinitionRegistry = new DefinitionRegistry();
        }
        return fgDefinitionRegistry;
    }

    public ReferenceExpression(String string) {
        Assert.isNotNull((Object)string);
        this.fDefinitionId = string;
    }

    public ReferenceExpression(IConfigurationElement iConfigurationElement) throws CoreException {
        this.fDefinitionId = iConfigurationElement.getAttribute(ATT_DEFINITION_ID);
        Expressions.checkAttribute(ATT_DEFINITION_ID, this.fDefinitionId);
    }

    public ReferenceExpression(Element element) throws CoreException {
        this.fDefinitionId = element.getAttribute(ATT_DEFINITION_ID);
        Expressions.checkAttribute(ATT_DEFINITION_ID, this.fDefinitionId.length() > 0 ? this.fDefinitionId : null);
    }

    public EvaluationResult evaluate(IEvaluationContext iEvaluationContext) throws CoreException {
        Expression expression = ReferenceExpression.getDefinitionRegistry().getExpression(this.fDefinitionId);
        return expression.evaluate(iEvaluationContext);
    }

    public void collectExpressionInfo(ExpressionInfo expressionInfo) {
        Expression expression;
        try {
            expression = ReferenceExpression.getDefinitionRegistry().getExpression(this.fDefinitionId);
        }
        catch (CoreException coreException) {
            return;
        }
        expression.collectExpressionInfo(expressionInfo);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ReferenceExpression)) {
            return false;
        }
        ReferenceExpression referenceExpression = (ReferenceExpression)object;
        return this.fDefinitionId.equals(referenceExpression.fDefinitionId);
    }

    protected int computeHashCode() {
        return HASH_INITIAL * 89 + this.fDefinitionId.hashCode();
    }
}

