/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.application;

import java.security.Permission;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.application.ApplicationDescriptor;

public class ApplicationAdminPermission
extends Permission {
    private static final long serialVersionUID = 1L;
    public static final String LIFECYCLE_ACTION = "lifecycle";
    public static final String SCHEDULE_ACTION = "schedule";
    public static final String LOCK_ACTION = "lock";
    private ApplicationDescriptor applicationDescriptor;
    private String applicationID;
    private static final Vector ACTIONS = new Vector();
    private Vector actionsVector;
    private final String filter;
    private final String actions;
    private Filter appliedFilter = null;

    static {
        ACTIONS.add(LIFECYCLE_ACTION);
        ACTIONS.add(SCHEDULE_ACTION);
        ACTIONS.add(LOCK_ACTION);
    }

    public ApplicationAdminPermission(String string, String string2) throws InvalidSyntaxException {
        super(string == null ? "*" : string);
        if (string == null) {
            string = "*";
        }
        if (string2 == null) {
            throw new NullPointerException("Action string cannot be null!");
        }
        this.applicationDescriptor = null;
        this.filter = string == null ? "*" : string;
        this.actions = string2;
        if (!string.equals("*") && !string.equals("<<SELF>>")) {
            FrameworkUtil.createFilter((String)this.filter);
        }
        this.init();
    }

    public ApplicationAdminPermission(ApplicationDescriptor applicationDescriptor, String string) {
        super(applicationDescriptor.getApplicationId());
        if (applicationDescriptor == null || string == null) {
            throw new NullPointerException("ApplicationDescriptor and action string cannot be null!");
        }
        this.filter = applicationDescriptor.getApplicationId();
        this.applicationDescriptor = applicationDescriptor;
        this.actions = string;
        this.init();
    }

    public ApplicationAdminPermission setCurrentApplicationId(String string) {
        ApplicationAdminPermission applicationAdminPermission = null;
        if (this.applicationDescriptor == null) {
            try {
                applicationAdminPermission = new ApplicationAdminPermission(this.filter, this.actions);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                throw new RuntimeException("Internal error");
            }
        } else {
            applicationAdminPermission = new ApplicationAdminPermission(this.applicationDescriptor, this.actions);
        }
        applicationAdminPermission.applicationID = string;
        return applicationAdminPermission;
    }

    public boolean implies(Permission permission) {
        if (permission == null) {
            return false;
        }
        if (!(permission instanceof ApplicationAdminPermission)) {
            return false;
        }
        ApplicationAdminPermission applicationAdminPermission = (ApplicationAdminPermission)permission;
        if (!this.filter.equals("*")) {
            if (applicationAdminPermission.applicationDescriptor == null) {
                return false;
            }
            if (this.filter.equals("<<SELF>>")) {
                if (applicationAdminPermission.applicationID == null) {
                    return false;
                }
                if (!applicationAdminPermission.applicationID.equals(applicationAdminPermission.applicationDescriptor.getApplicationId())) {
                    return false;
                }
            } else {
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put("pid", applicationAdminPermission.applicationDescriptor.getApplicationId());
                hashtable.put("signer", new SignerWrapper(applicationAdminPermission.applicationDescriptor));
                Filter filter = this.getFilter();
                if (filter == null) {
                    return false;
                }
                if (!filter.match(hashtable)) {
                    return false;
                }
            }
        }
        return this.actionsVector.containsAll(applicationAdminPermission.actionsVector);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ApplicationAdminPermission)) {
            return false;
        }
        ApplicationAdminPermission applicationAdminPermission = (ApplicationAdminPermission)object;
        if (applicationAdminPermission.actionsVector.size() != this.actionsVector.size()) {
            return false;
        }
        int n = 0;
        while (n != this.actionsVector.size()) {
            if (!applicationAdminPermission.actionsVector.contains(this.actionsVector.get(n))) {
                return false;
            }
            ++n;
        }
        return ApplicationAdminPermission.equal(this.filter, applicationAdminPermission.filter) && ApplicationAdminPermission.equal(this.applicationDescriptor, applicationAdminPermission.applicationDescriptor) && ApplicationAdminPermission.equal(this.applicationID, applicationAdminPermission.applicationID);
    }

    private static boolean equal(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        return object.equals(object2);
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 != this.actionsVector.size()) {
            n ^= ((String)this.actionsVector.get(n2)).hashCode();
            ++n2;
        }
        n ^= this.filter == null ? 0 : this.filter.hashCode();
        n ^= this.applicationDescriptor == null ? 0 : this.applicationDescriptor.hashCode();
        return n ^= this.applicationID == null ? 0 : this.applicationID.hashCode();
    }

    public String getActions() {
        return this.actions;
    }

    private static Vector actionsVector(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string.toUpperCase(), ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            vector.add(string2.toLowerCase());
        }
        if (vector.contains(SCHEDULE_ACTION) && !vector.contains(LIFECYCLE_ACTION)) {
            vector.add(LIFECYCLE_ACTION);
        }
        return vector;
    }

    private void init() {
        this.actionsVector = ApplicationAdminPermission.actionsVector(this.actions);
        if (this.actions.equals("*")) {
            this.actionsVector = ApplicationAdminPermission.actionsVector("lifecycle,schedule,lock");
        } else if (!ACTIONS.containsAll(this.actionsVector)) {
            throw new IllegalArgumentException("Illegal action!");
        }
        this.applicationID = null;
    }

    private Filter getFilter() {
        String string = this.filter;
        if (this.appliedFilter == null) {
            try {
                int n = this.filter.indexOf("signer");
                if (n != -1) {
                    StringBuffer stringBuffer = new StringBuffer(this.filter);
                    int n2 = 0;
                    while (n != -1) {
                        int n3 = n - 1;
                        while (n3 >= 0 && Character.isWhitespace(this.filter.charAt(n3))) {
                            --n3;
                        }
                        if (n3 < 0) break;
                        if (this.filter.charAt(n3) != '(' || n3 > 0 && this.filter.charAt(n3 - 1) == '\\') {
                            n = this.filter.indexOf("signer", n + 6);
                            continue;
                        }
                        n += 6;
                        while (Character.isWhitespace(this.filter.charAt(n))) {
                            ++n;
                        }
                        if (this.filter.charAt(n) != '=') {
                            n = this.filter.indexOf("signer", n);
                            continue;
                        }
                        ++n;
                        while (this.filter.charAt(n) != ')' || this.filter.charAt(n - 1) == '\\') {
                            if (this.filter.charAt(n) == '*') {
                                stringBuffer.insert(n + n2, '\\');
                                ++n2;
                            }
                            ++n;
                        }
                        n = this.filter.indexOf("signer", n);
                    }
                    string = stringBuffer.toString();
                }
                this.appliedFilter = FrameworkUtil.createFilter((String)string);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
        }
        return this.appliedFilter;
    }

    private static class SignerWrapper {
        private String pattern;
        private ApplicationDescriptor appDesc;

        public SignerWrapper(String string) {
            this.pattern = string;
        }

        SignerWrapper(ApplicationDescriptor applicationDescriptor) {
            this.appDesc = applicationDescriptor;
        }

        public boolean equals(Object object) {
            if (!(object instanceof SignerWrapper)) {
                return false;
            }
            SignerWrapper signerWrapper = (SignerWrapper)object;
            ApplicationDescriptor applicationDescriptor = this.appDesc != null ? this.appDesc : signerWrapper.appDesc;
            String string = this.appDesc != null ? signerWrapper.pattern : this.pattern;
            return applicationDescriptor.matchDNChain(string);
        }
    }
}

