/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.eclipse.ercp.xml.io.SimpleBufferedInputStream;

public class PropertyFileReader {
    private static final int INIT_STATE = 0;
    private static final int SLASH_MET_STATE = 1;
    private static final int UNICODE_STATE = 2;
    private static final int RC_STATE = 3;
    private static final int END_OF_PROP_STATE = 4;
    private static final int SKIP_NEXT_CHAR_STATE = 4;

    public Hashtable read(InputStream in, Hashtable table) throws IOException {
        return this.readBIS(new SimpleBufferedInputStream(in), table);
    }

    /*
     * Enabled aggressive block sorting
     */
    Hashtable readBIS(SimpleBufferedInputStream in, Hashtable table) throws IOException {
        int c;
        int currentState = 0;
        int unicodeValue = 0;
        int unicodeLength = 0;
        char[] buf = new char[40];
        int offset = 0;
        int keyLength = -1;
        boolean firstChar = true;
        block17: while ((c = in.read()) != -1) {
            if (offset == buf.length) {
                char[] newBuf = new char[buf.length * 2];
                System.arraycopy(buf, 0, newBuf, 0, offset);
                buf = newBuf;
            }
            if (currentState == 2) {
                int digit = Character.digit((char)c, 16);
                if (digit >= 0) {
                    unicodeValue = (unicodeValue << 4) + digit;
                    if (++unicodeLength < 4) continue;
                }
                currentState = 0;
                buf[offset++] = (char)unicodeValue;
                if (c != 10) continue;
            }
            if (currentState == 1) {
                currentState = 0;
                switch (c) {
                    case 13: {
                        currentState = 3;
                        continue block17;
                    }
                    case 10: {
                        currentState = 4;
                        continue block17;
                    }
                    case 98: {
                        c = 8;
                        break;
                    }
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 117: {
                        currentState = 2;
                        unicodeLength = 0;
                        unicodeValue = 0;
                        continue block17;
                    }
                }
            } else {
                switch (c) {
                    case 33: 
                    case 35: {
                        if (!firstChar) break;
                        while ((c = in.read()) != -1 && c != 13 && c != 10) {
                        }
                        continue block17;
                    }
                    case 10: {
                        if (currentState == 3) {
                            currentState = 4;
                            continue block17;
                        }
                    }
                    case 13: {
                        currentState = 0;
                        firstChar = true;
                        if (keyLength >= 0) {
                            String temp = new String(buf, 0, offset);
                            table.put(temp.substring(0, keyLength), temp.substring(keyLength));
                        }
                        keyLength = -1;
                        offset = 0;
                        continue block17;
                    }
                    case 92: {
                        currentState = 1;
                        continue block17;
                    }
                    case 58: 
                    case 61: {
                        if (keyLength != -1) break;
                        keyLength = offset;
                        continue block17;
                    }
                }
                if (PropertyFileReader.isWhitespace((char)c)) {
                    if (currentState == 3) {
                        currentState = 4;
                    }
                    if (offset == 0 || offset == keyLength || currentState == 4) continue;
                    if (keyLength == -1) {
                        currentState = 4;
                        continue;
                    }
                }
                if (currentState == 4 || currentState == 3) {
                    currentState = 0;
                }
            }
            firstChar = false;
            if (currentState == 4) {
                keyLength = offset;
                currentState = 0;
            }
            buf[offset++] = (char)c;
        }
        if (keyLength >= 0) {
            String temp = new String(buf, 0, offset);
            table.put(temp.substring(0, keyLength), temp.substring(keyLength));
        }
        return table;
    }

    static boolean isWhitespace(char c) {
        return c >= '\u001c' && c <= ' ' || c >= '\t' && c <= '\r';
    }
}

