/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.jobs.LockListener;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.internal.EarlyStartupRunnable;
import org.eclipse.ui.internal.ExceptionHandler;
import org.eclipse.ui.internal.ExtensionEventHandler;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.UILockListener;
import org.eclipse.ui.internal.UISynchronizer;
import org.eclipse.ui.internal.WorkbenchColors;
import org.eclipse.ui.internal.WorkbenchConfigurer;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.commands.CommandService;
import org.eclipse.ui.internal.commands.WorkbenchCommandSupport;
import org.eclipse.ui.internal.handlers.HandlerService;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.misc.ShowMessage;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.registry.UIExtensionTracker;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.views.IViewRegistry;

public final class Workbench
implements IWorkbench {
    private static final String[] VERSION_STRING = new String[]{"0.046", "2.0"};
    private static final String DEFAULT_WORKBENCH_STATE_FILENAME = "workbench.xml";
    private static Workbench instance;
    private Display display;
    private WorkbenchWindow activatedWindow;
    private boolean runEventLoop = true;
    private boolean isStarting = true;
    private boolean isClosing = false;
    private int returnCode = 2;
    private ListenerList windowListeners = new ListenerList();
    private WorkbenchAdvisor advisor;
    private WorkbenchConfigurer workbenchConfigurer;
    private ExtensionEventHandler extensionEventHandler;
    private int largeUpdates = 0;
    final Map services = new HashMap();
    private boolean openShellEnabled = !Boolean.getBoolean("container.ercp.hidefirstapp");
    private WorkbenchCommandSupport workbenchCommandSupport;
    private CommandManager commandManager;
    private ContextManager contextManager;
    private final IWindowListener windowListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
            Workbench.this.updateActiveWorkbenchWindowMenuManager(true);
        }

        public void windowClosed(IWorkbenchWindow window) {
            Workbench.this.updateActiveWorkbenchWindowMenuManager(true);
        }

        public void windowDeactivated(IWorkbenchWindow window) {
            Workbench.this.updateActiveWorkbenchWindowMenuManager(true);
        }

        public void windowOpened(IWorkbenchWindow window) {
            Workbench.this.updateActiveWorkbenchWindowMenuManager(true);
        }
    };
    private IExtensionTracker tracker;
    private IRegistryChangeListener startupRegistryListener = new IRegistryChangeListener(){

        public void registryChanged(IRegistryChangeEvent event) {
            IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.ui", "startup");
            if (deltas.length == 0) {
                return;
            }
            String disabledPlugins = Workbench.this.getPreferenceStore().getString("PLUGINS_NOT_ACTIVATED_ON_STARTUP");
            Runnable runnable = new Runnable(this, deltas, disabledPlugins){
                final /* synthetic */ 2 this$1;
                private final /* synthetic */ IExtensionDelta[] val$deltas;
                private final /* synthetic */ String val$disabledPlugins;
                {
                    this.this$1 = var1_1;
                    this.val$deltas = iExtensionDeltaArray;
                    this.val$disabledPlugins = string;
                }

                public void run() {
                    int i = 0;
                    while (i < this.val$deltas.length) {
                        IExtension extension = this.val$deltas[i].getExtension();
                        if (this.val$deltas[i].getKind() != 2 && this.val$disabledPlugins.indexOf(extension.getNamespace()) == -1) {
                            Platform.run((ISafeRunnable)new EarlyStartupRunnable(extension));
                        }
                        ++i;
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        }
    };
    private static IExceptionHandler exceptionHandler;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        exceptionHandler = new DefaultExceptionHandler();
    }

    private Workbench(Display display, WorkbenchAdvisor advisor) {
        if (instance != null && instance.isRunning()) {
            throw new IllegalStateException(WorkbenchMessages.Workbench_CreatingWorkbenchTwice);
        }
        Assert.isNotNull(display);
        Assert.isNotNull(advisor);
        this.advisor = advisor;
        this.display = display;
        instance = this;
        this.extensionEventHandler = new ExtensionEventHandler(this);
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this.extensionEventHandler);
    }

    public static final Workbench getInstance() {
        return instance;
    }

    public static final int createAndRunWorkbench(Display display, WorkbenchAdvisor advisor) {
        Workbench workbench = new Workbench(display, advisor);
        int returnCode = workbench.runUI();
        return returnCode;
    }

    public static Display createDisplay() {
        String applicationName = "eWorkbench";
        if (applicationName != null) {
            Display.setAppName((String)applicationName);
        }
        Display newDisplay = new Display();
        newDisplay.setWarnings(false);
        return newDisplay;
    }

    public void addWindowListener(IWindowListener l) {
        this.windowListeners.add((Object)l);
    }

    public void removeWindowListener(IWindowListener l) {
        this.windowListeners.remove((Object)l);
    }

    protected void fireWindowOpened(final IWorkbenchWindow window) {
        Object[] list = this.windowListeners.getListeners();
        int i = 0;
        while (i < list.length) {
            final IWindowListener l = (IWindowListener)list[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.windowOpened(window);
                }
            });
            ++i;
        }
    }

    protected void fireWindowClosed(final IWorkbenchWindow window) {
        if (this.activatedWindow == window) {
            this.activatedWindow = null;
        }
        Object[] list = this.windowListeners.getListeners();
        int i = 0;
        while (i < list.length) {
            final IWindowListener l = (IWindowListener)list[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.windowClosed(window);
                }
            });
            ++i;
        }
    }

    protected void fireWindowActivated(final IWorkbenchWindow window) {
        Object[] list = this.windowListeners.getListeners();
        int i = 0;
        while (i < list.length) {
            final IWindowListener l = (IWindowListener)list[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.windowActivated(window);
                }
            });
            ++i;
        }
    }

    protected void fireWindowDeactivated(final IWorkbenchWindow window) {
        Object[] list = this.windowListeners.getListeners();
        int i = 0;
        while (i < list.length) {
            final IWindowListener l = (IWindowListener)list[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.windowDeactivated(window);
                }
            });
            ++i;
        }
    }

    private boolean busyClose(final boolean force) {
        this.isClosing = this.advisor.preShutdown();
        if (!force && !this.isClosing) {
            return false;
        }
        if (this.getWorkbenchConfigurer().getSaveAndRestore()) {
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    XMLMemento mem = Workbench.this.recordWorkbenchState();
                    Workbench.this.saveMementoToFile(mem);
                }

                public void handleException(Throwable e) {
                    String message = e.getMessage() == null ? WorkbenchMessages.ErrorClosingNoArg : NLS.bind((String)WorkbenchMessages.ErrorClosingOneArg, (Object)e.getMessage());
                    if (!ShowMessage.openQuestion(null, WorkbenchMessages.Error, message)) {
                        Workbench.this.isClosing = false;
                    }
                }
            });
        }
        if (!force && !this.isClosing) {
            return false;
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(WorkbenchMessages.ErrorClosing){

            public void run() {
                if (Workbench.this.isClosing || force) {
                    IWorkbenchWindow[] windows = Workbench.this.getWorkbenchWindows();
                    int i = 0;
                    while (i < windows.length) {
                        IWorkbenchWindow window = windows[i];
                        Workbench.this.isClosing = window.close();
                        if (!Workbench.this.isClosing) break;
                        ++i;
                    }
                }
            }
        });
        if (!force && !this.isClosing) {
            return false;
        }
        this.shutdown();
        this.runEventLoop = false;
        return true;
    }

    public boolean saveAllEditors(boolean confirm) {
        return true;
    }

    private IWorkbenchWindow busyOpenWorkbenchWindow(String perspID, IAdaptable input) throws WorkbenchException {
        WorkbenchWindow newWindow = this.newWorkbenchWindow();
        newWindow.create();
        if (perspID != null) {
            newWindow.busyOpenPage(perspID, input);
        }
        newWindow.open();
        return newWindow;
    }

    public boolean close() {
        Integer assignedReturnCode = (Integer)System.getProperties().get("eworkbench.returnCode");
        if (assignedReturnCode != null) {
            return this.close(assignedReturnCode, true);
        }
        return this.close(0, false);
    }

    boolean close(int returnCode, boolean force) {
        this.returnCode = returnCode;
        boolean[] ret = new boolean[]{this.busyClose(force)};
        return ret[0];
    }

    public IWorkbenchWindow getActiveWorkbenchWindow() {
        if (Display.getCurrent() == null) {
            return null;
        }
        Shell shell = this.display.getActiveShell();
        while (shell != null && !shell.isDisposed()) {
            Object data = shell.getData();
            if (data instanceof IWorkbenchWindow) {
                return (IWorkbenchWindow)data;
            }
            shell = shell.getParent();
        }
        WorkbenchWindow win = this.getActivatedWindow();
        if (win != null) {
            return win;
        }
        Shell[] shells = this.display.getShells();
        int i = 0;
        while (i < shells.length) {
            Object data = shells[i].getData();
            if (data instanceof IWorkbenchWindow) {
                return (IWorkbenchWindow)data;
            }
            ++i;
        }
        return null;
    }

    public IPerspectiveRegistry getPerspectiveRegistry() {
        return WorkbenchPlugin.getDefault().getPerspectiveRegistry();
    }

    public PreferenceManager getPreferenceManager() {
        return WorkbenchPlugin.getDefault().getPreferenceManager();
    }

    public IPreferenceStore getPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    public ISharedImages getSharedImages() {
        return WorkbenchPlugin.getDefault().getSharedImages();
    }

    private File getWorkbenchStateFile() {
        IPath path = WorkbenchPlugin.getDefault().getDataLocation();
        if (path == null) {
            return null;
        }
        path = path.append(DEFAULT_WORKBENCH_STATE_FILENAME);
        return path.toFile();
    }

    public int getWorkbenchWindowCount() {
        IWorkbenchWindow[] windows = this.getWorkbenchWindows();
        return windows != null ? windows.length : 0;
    }

    public IWorkbenchWindow[] getWorkbenchWindows() {
        if (Display.getCurrent() == null) {
            return null;
        }
        Shell[] shells = Display.getCurrent().getShells();
        ArrayList<Object> windows = new ArrayList<Object>(shells.length);
        int i = 0;
        while (i < shells.length) {
            if (shells[i].getData() instanceof WorkbenchWindow) {
                windows.add(shells[i].getData());
            }
            ++i;
        }
        return windows.toArray(new IWorkbenchWindow[windows.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean init(Display display) {
        if (WorkbenchPlugin.getDefault().isDebugging()) {
            WorkbenchPlugin.DEBUG = true;
            ModalContext.setDebugMode((boolean)true);
        }
        this.commandManager = new CommandManager();
        CommandService commandService = new CommandService(this.commandManager);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.commands.ICommandService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.services.put(clazz, commandService);
        HandlerService handlerService = new HandlerService(this.commandManager);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.services.put(clazz2, handlerService);
        commandService.readRegistry();
        this.addWindowListener(this.windowListener);
        this.initializeImages();
        this.initializeFonts();
        this.initializeColors();
        this.initializeApplicationColors();
        this.advisor.internalBasicInitialize(this.getWorkbenchConfigurer());
        this.getPreferenceStore().getBoolean("COLOR_ICONS");
        this.initializeSingleClickOption();
        boolean avoidDeadlock = true;
        String[] commandLineArgs = Platform.getCommandLineArgs();
        int i = 0;
        while (i < commandLineArgs.length) {
            if (commandLineArgs[i].equalsIgnoreCase("-allowDeadlock")) {
                avoidDeadlock = false;
            }
            ++i;
        }
        if (avoidDeadlock) {
            UILockListener uiLockListener = new UILockListener(display);
            Platform.getJobManager().setLockListener((LockListener)uiLockListener);
            display.setSynchronizer((Synchronizer)new UISynchronizer(display, uiLockListener));
        }
        try {
            UIStats.start(4, "Workbench");
            this.advisor.preStartup();
            if (!this.advisor.openWindows()) {
                Object var6_8 = null;
                UIStats.end(4, this, "Workbench");
                return false;
            }
            Object var6_10 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            UIStats.end(4, this, "Workbench");
            throw throwable;
        }
        UIStats.end(4, this, "Workbench");
        this.forceOpenPerspective();
        this.isStarting = false;
        return true;
    }

    private void initializeApplicationColors() {
    }

    private void initializeSingleClickOption() {
        int singleClickMethod;
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        boolean openOnSingleClick = store.getBoolean("OPEN_ON_SINGLE_CLICK");
        boolean selectOnHover = store.getBoolean("SELECT_ON_HOVER");
        boolean openAfterDelay = store.getBoolean("OPEN_AFTER_DELAY");
        int n = singleClickMethod = openOnSingleClick ? 1 : 0;
        if (openOnSingleClick) {
            if (selectOnHover) {
                singleClickMethod |= 2;
            }
            if (openAfterDelay) {
                singleClickMethod |= 4;
            }
        }
        OpenStrategy.setOpenMethod((int)singleClickMethod);
    }

    private void initializeFonts() {
    }

    private void initializeImages() {
    }

    private void uninitializeImages() {
        WorkbenchImages.dispose();
    }

    private void initializeColors() {
        WorkbenchColors.startup();
    }

    public boolean isClosing() {
        return this.isClosing;
    }

    boolean isStarting() {
        return this.isStarting;
    }

    private WorkbenchWindow newWorkbenchWindow() {
        return new WorkbenchWindow();
    }

    private void forceOpenPerspective() {
        String perspId = null;
        String[] commandLineArgs = Platform.getCommandLineArgs();
        int i = 0;
        while (i < commandLineArgs.length - 1) {
            if (commandLineArgs[i].equalsIgnoreCase("-perspective")) {
                perspId = commandLineArgs[i + 1];
                break;
            }
            ++i;
        }
        if (perspId == null) {
            return;
        }
        IPerspectiveDescriptor desc = this.getPerspectiveRegistry().findPerspectiveWithId(perspId);
        if (desc == null) {
            return;
        }
        IWorkbenchWindow win = this.getActiveWorkbenchWindow();
        if (win == null) {
            win = this.getWorkbenchWindowCount() == 0 ? null : this.getWorkbenchWindows()[0];
        }
        try {
            this.showPerspective(perspId, win);
        }
        catch (WorkbenchException e) {
            String msg = "Workbench exception showing specified command line perspective on startup.";
            WorkbenchPlugin.log(msg, (IStatus)new Status(4, "org.eclipse.ui", 0, msg, (Throwable)((Object)e)));
        }
    }

    void openFirstTimeWindow() {
        try {
            this.busyOpenWorkbenchWindow(this.getPerspectiveRegistry().getDefaultPerspective(), this.getDefaultPageInput());
        }
        catch (WorkbenchException e) {
            ShowMessage.printError(e.getMessage(), e.getStatus());
        }
    }

    IStatus restoreState() {
        if (!this.getWorkbenchConfigurer().getSaveAndRestore()) {
            String msg = WorkbenchMessages.Workbench_restoreDisabled;
            return new Status(2, WorkbenchPlugin.PI_WORKBENCH, 1, msg, null);
        }
        final File stateFile = this.getWorkbenchStateFile();
        if (stateFile == null || !stateFile.exists()) {
            String msg = WorkbenchMessages.Workbench_noStateToRestore;
            return new Status(2, WorkbenchPlugin.PI_WORKBENCH, 1, msg, null);
        }
        final IStatus[] result = new IStatus[]{new Status(0, WorkbenchPlugin.PI_WORKBENCH, 0, "", null)};
        Platform.run((ISafeRunnable)new SafeRunnable(WorkbenchMessages.ErrorReadingState){

            public void run() throws Exception {
                FileInputStream input = new FileInputStream(stateFile);
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)input, "utf-8"));
                XMLMemento memento = XMLMemento.createReadRoot(reader);
                String version = memento.getString("version");
                boolean valid = false;
                int i = 0;
                while (i < VERSION_STRING.length) {
                    if (VERSION_STRING[i].equals(version)) {
                        valid = true;
                        break;
                    }
                    ++i;
                }
                if (!valid) {
                    reader.close();
                    String msg = WorkbenchMessages.Invalid_workbench_state_ve;
                    ShowMessage.openError(null, WorkbenchMessages.Restoring_Problems, msg);
                    stateFile.delete();
                    result[0] = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, msg, null);
                    return;
                }
                if (VERSION_STRING[0].equals(version)) {
                    boolean ignoreSavedState;
                    reader.close();
                    String msg = WorkbenchMessages.Workbench_incompatibleSavedStateVersion;
                    boolean bl = ignoreSavedState = ShowMessage.openBox(null, WorkbenchMessages.Workbench_incompatibleUIState, msg, 296) == 32;
                    if (ignoreSavedState) {
                        stateFile.delete();
                        result[0] = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 1, msg, null);
                    } else {
                        result[0] = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 2, msg, null);
                    }
                    return;
                }
                IStatus restoreResult = Workbench.this.restoreState(memento);
                reader.close();
                if (restoreResult.getSeverity() == 4) {
                    ShowMessage.printError(WorkbenchMessages.Workbench_problemsRestoringMsg, restoreResult);
                }
            }

            public void handleException(Throwable e) {
                super.handleException(e);
                String msg = e.getMessage() == null ? "" : e.getMessage();
                result[0] = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, msg, e);
                stateFile.delete();
            }
        });
        return result[0];
    }

    public IWorkbenchWindow openWorkbenchWindow(IAdaptable input) throws WorkbenchException {
        return this.openWorkbenchWindow(this.getPerspectiveRegistry().getDefaultPerspective(), input);
    }

    public IWorkbenchWindow openWorkbenchWindow(String perspID, IAdaptable input) throws WorkbenchException {
        Object[] result = new Object[1];
        try {
            result[0] = this.busyOpenWorkbenchWindow(perspID, input);
        }
        catch (WorkbenchException e) {
            result[0] = e;
        }
        if (result[0] instanceof IWorkbenchWindow) {
            return (IWorkbenchWindow)result[0];
        }
        if (result[0] instanceof WorkbenchException) {
            throw (WorkbenchException)((Object)result[0]);
        }
        throw new WorkbenchException(WorkbenchMessages.Abnormal_Workbench_Conditi);
    }

    private XMLMemento recordWorkbenchState() {
        XMLMemento memento = XMLMemento.createWriteRoot("workbench");
        IStatus status = this.saveState(memento);
        if (status.getSeverity() != 0) {
            ShowMessage.printError(WorkbenchMessages.Workbench_problemsSavingMsg, status);
        }
        return memento;
    }

    public boolean restart() {
        return this.close(1, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus restoreState(IMemento memento) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Workbench_problemsRestoring, null);
        try {
            UIStats.start(4, "MRUList");
            memento.getChild("mruList");
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            UIStats.end(4, this, "MRUList");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        UIStats.end(4, this, "MRUList");
        IMemento[] children = memento.getChildren("org.eclipse.jface.window");
        int x = 0;
        while (true) {
            block11: {
                Object var9_11;
                if (x >= children.length) {
                    return result;
                }
                IMemento childMem = children[x];
                WorkbenchWindow newWindow = this.newWorkbenchWindow();
                newWindow.create();
                boolean opened = false;
                try {
                    result.merge(newWindow.restoreState(childMem, null));
                    try {
                        newWindow.fireWindowRestored();
                    }
                    catch (WorkbenchException e) {
                        result.add(e.getStatus());
                    }
                    newWindow.open();
                    opened = true;
                }
                catch (Throwable throwable) {
                    var9_11 = null;
                    if (!opened) {
                        newWindow.close();
                    }
                    throw throwable;
                }
                {
                    var9_11 = null;
                    if (opened) break block11;
                    newWindow.close();
                }
            }
            ++x;
        }
    }

    public String[] getEarlyActivatedPlugins() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "startup");
        IExtension[] extensions = point.getExtensions();
        String[] result = new String[extensions.length];
        int i = 0;
        while (i < extensions.length) {
            result[i] = extensions[i].getNamespace();
            ++i;
        }
        return result;
    }

    private void startPlugins() {
        Runnable work = new Runnable(){
            final String disabledPlugins;
            {
                this.disabledPlugins = Workbench.this.getPreferenceStore().getString("PLUGINS_NOT_ACTIVATED_ON_STARTUP");
            }

            public void run() {
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IExtensionPoint point = registry.getExtensionPoint("org.eclipse.ui", "startup");
                IExtension[] extensions = point.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    if (this.disabledPlugins.indexOf(extension.getNamespace()) == -1) {
                        Platform.run((ISafeRunnable)new EarlyStartupRunnable(extension));
                    }
                    ++i;
                }
            }
        };
        Thread thread = new Thread(work);
        thread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int runUI() {
        UIStats.start(5, "Workbench");
        Listener closeListener = new Listener(){

            public void handleEvent(Event event) {
                event.doit = Workbench.this.close();
            }
        };
        ExceptionHandler handler = ExceptionHandler.getInstance();
        try {
            block8: {
                try {
                    this.display.addListener(21, closeListener);
                    Workbench.setExceptionHandler(handler);
                    boolean initOK = this.init(this.display);
                    this.openShellEnabled = true;
                    Platform.endSplash();
                    if (initOK) {
                        this.advisor.postStartup();
                    }
                    if (initOK && this.runEventLoop) {
                        this.startPlugins();
                        this.display.asyncExec(new Runnable(){

                            public void run() {
                                UIStats.end(5, this, "Workbench");
                            }
                        });
                        this.runEventLoop(handler, this.display);
                    }
                }
                catch (Exception e) {
                    if (!this.display.isDisposed()) {
                        handler.handleException(e);
                        break block8;
                    }
                    String msg = "Exception in Workbench.runUI after display was disposed";
                    WorkbenchPlugin.log(msg, (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, msg, (Throwable)e));
                }
            }
            Object var5_8 = null;
            this.runEventLoop = false;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.runEventLoop = false;
            if (this.display.isDisposed()) throw throwable;
            this.display.removeListener(21, closeListener);
            throw throwable;
        }
        if (this.display.isDisposed()) return this.returnCode;
        this.display.removeListener(21, closeListener);
        return this.returnCode;
    }

    private void runEventLoop(IExceptionHandler handler, Display display) {
        this.runEventLoop = true;
        while (this.runEventLoop) {
            try {
                if (display.readAndDispatch()) continue;
                this.getAdvisor().eventLoopIdle(display);
            }
            catch (Throwable t) {
                t.printStackTrace();
                handler.handleException(t);
            }
        }
    }

    private IStatus saveState(IMemento memento) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Workbench_problemsSaving, null);
        memento.putString("version", VERSION_STRING[1]);
        IWorkbenchWindow[] windows = this.getWorkbenchWindows();
        int nX = 0;
        while (nX < windows.length) {
            WorkbenchWindow window = (WorkbenchWindow)windows[nX];
            IMemento childMem = memento.createChild("org.eclipse.jface.window");
            result.merge(window.saveState(childMem));
            ++nX;
        }
        return result;
    }

    private boolean saveMementoToFile(XMLMemento memento) {
        File stateFile = this.getWorkbenchStateFile();
        if (stateFile == null) {
            return false;
        }
        try {
            FileOutputStream stream = new FileOutputStream(stateFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "utf-8");
            memento.save(writer);
            writer.close();
        }
        catch (IOException iOException) {
            stateFile.delete();
            ShowMessage.openError(null, WorkbenchMessages.SavingProblem, WorkbenchMessages.ProblemSavingState);
            return false;
        }
        return true;
    }

    public IWorkbenchPage showPerspective(String perspectiveId, IWorkbenchWindow window) throws WorkbenchException {
        Object persp;
        int i;
        WorkbenchPage page;
        Assert.isNotNull(perspectiveId);
        WorkbenchWindow win = (WorkbenchWindow)window;
        if (win != null && (page = win.getActiveWorkbenchPage()) != null) {
            IPerspectiveDescriptor[] perspectives = page.getOpenPerspectives();
            i = 0;
            while (i < perspectives.length) {
                IPerspectiveDescriptor persp2 = perspectives[i];
                if (perspectiveId.equals(persp2.getId())) {
                    win.getShell().open();
                    page.setPerspective(persp2);
                    return page;
                }
                ++i;
            }
        }
        IAdaptable input = this.getDefaultPageInput();
        IWorkbenchWindow[] windows = this.getWorkbenchWindows();
        i = 0;
        while (i < windows.length) {
            WorkbenchPage page2;
            win = (WorkbenchWindow)windows[i];
            if (window != win && (page2 = win.getActiveWorkbenchPage()) != null) {
                boolean inputSame = false;
                inputSame = input == null ? page2.getInput() == null : input.equals(page2.getInput());
                if (inputSame && perspectiveId.equals(((Perspective)(persp = page2.getActivePerspective())).getDesc().getId())) {
                    Shell shell = win.getShell();
                    shell.open();
                    if (shell.getMinimized()) {
                        shell.setMinimized(false);
                    }
                    return page2;
                }
            }
            ++i;
        }
        win = (WorkbenchWindow)window;
        if (win != null) {
            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
            int mode = store.getInt("OPEN_PERSPECTIVE_MODE");
            IWorkbenchPage page3 = win.getActiveWorkbenchPage();
            persp = null;
            if (page3 != null) {
                persp = page3.getPerspective();
            }
            if (2 == mode && persp != null) {
                IWorkbenchWindow newWindow = this.openWorkbenchWindow(perspectiveId, input);
                return newWindow.getActivePage();
            }
            IPerspectiveDescriptor desc = this.getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
            if (desc == null) {
                throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.WorkbenchPage_ErrorCreatingPerspective, (Object)perspectiveId));
            }
            win.getShell().open();
            if (page3 == null) {
                page3 = win.openPage(perspectiveId, input);
            } else {
                page3.setPerspective(desc);
            }
            return page3;
        }
        throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.Workbench_showPerspectiveError, (Object)perspectiveId));
    }

    public IWorkbenchPage showPerspective(String perspectiveId, IWorkbenchWindow window, IAdaptable input) throws WorkbenchException {
        IPreferenceStore store;
        int mode;
        Object persp;
        WorkbenchPage page;
        Assert.isNotNull(perspectiveId);
        boolean inputSameAsWindow = false;
        WorkbenchWindow win = (WorkbenchWindow)window;
        if (win != null && (page = win.getActiveWorkbenchPage()) != null) {
            boolean inputSame = false;
            inputSame = input == null ? page.getInput() == null : input.equals(page.getInput());
            if (inputSame) {
                inputSameAsWindow = true;
                IPerspectiveDescriptor[] perspectives = page.getOpenPerspectives();
                int i = 0;
                while (i < perspectives.length) {
                    persp = perspectives[i];
                    if (perspectiveId.equals(persp.getId())) {
                        win.getShell().open();
                        page.setPerspective((IPerspectiveDescriptor)persp);
                        return page;
                    }
                    ++i;
                }
            }
        }
        IWorkbenchWindow[] windows = this.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            WorkbenchPage page2;
            win = (WorkbenchWindow)windows[i];
            if (window != win && (page2 = win.getActiveWorkbenchPage()) != null) {
                boolean inputSame = false;
                inputSame = input == null ? page2.getInput() == null : input.equals(page2.getInput());
                if (inputSame && perspectiveId.equals(((Perspective)(persp = page2.getActivePerspective())).getDesc().getId())) {
                    win.getShell().open();
                    return page2;
                }
            }
            ++i;
        }
        win = (WorkbenchWindow)window;
        if (inputSameAsWindow && win != null && 2 != (mode = (store = WorkbenchPlugin.getDefault().getPreferenceStore()).getInt("OPEN_PERSPECTIVE_MODE"))) {
            IWorkbenchPage page3 = win.getActiveWorkbenchPage();
            IPerspectiveDescriptor desc = this.getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
            if (desc == null) {
                throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.WorkbenchPage_ErrorCreatingPerspective, (Object)perspectiveId));
            }
            win.getShell().open();
            if (page3 == null) {
                page3 = win.openPage(perspectiveId, input);
            } else {
                page3.setPerspective(desc);
            }
            return page3;
        }
        if (win != null) {
            IWorkbenchPage page4 = win.getActiveWorkbenchPage();
            IPerspectiveDescriptor persp2 = null;
            if (page4 != null) {
                persp2 = page4.getPerspective();
            }
            if (persp2 == null) {
                IPerspectiveDescriptor desc = this.getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
                if (desc == null) {
                    throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.WorkbenchPage_ErrorCreatingPerspective, (Object)perspectiveId));
                }
                win.getShell().open();
                if (page4 == null) {
                    page4 = win.openPage(perspectiveId, input);
                } else {
                    page4.setPerspective(desc);
                }
                return page4;
            }
        }
        IWorkbenchWindow newWindow = this.openWorkbenchWindow(perspectiveId, input);
        return newWindow.getActivePage();
    }

    private void shutdown() {
        this.advisor.postShutdown();
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this.extensionEventHandler);
        Platform.getExtensionRegistry().removeRegistryChangeListener(this.startupRegistryListener);
        WorkbenchColors.shutdown();
        this.uninitializeImages();
        if (WorkbenchPlugin.getDefault() != null) {
            WorkbenchPlugin.getDefault().reset();
        }
        if (this.tracker != null) {
            this.tracker.close();
        }
    }

    private WorkbenchWindow getActivatedWindow() {
        Shell shell;
        if (this.activatedWindow != null && (shell = this.activatedWindow.getShell()) != null && !shell.isDisposed()) {
            return this.activatedWindow;
        }
        return null;
    }

    void setActivatedWindow(WorkbenchWindow window) {
        this.activatedWindow = window;
    }

    WorkbenchConfigurer getWorkbenchConfigurer() {
        if (this.workbenchConfigurer == null) {
            this.workbenchConfigurer = new WorkbenchConfigurer();
        }
        return this.workbenchConfigurer;
    }

    WorkbenchAdvisor getAdvisor() {
        return this.advisor;
    }

    public Display getDisplay() {
        return this.display;
    }

    public String getDefaultPerspectiveId() {
        return this.getAdvisor().getInitialWindowPerspectiveId();
    }

    public IAdaptable getDefaultPageInput() {
        return this.getAdvisor().getDefaultPageInput();
    }

    public String getMainPreferencePageId() {
        String id = this.getAdvisor().getMainPreferencePageId();
        return id;
    }

    public IElementFactory getElementFactory(String factoryId) {
        Assert.isNotNull(factoryId);
        return WorkbenchPlugin.getDefault().getElementFactory(factoryId);
    }

    public IWorkbenchCommandSupport getCommandSupport() {
        return this.workbenchCommandSupport;
    }

    private void updateActiveWorkbenchWindowMenuManager(boolean textOnly) {
        WorkbenchWindow window;
        IWorkbenchWindow workbenchWindow = this.getActiveWorkbenchWindow();
        if (workbenchWindow instanceof WorkbenchWindow && (window = (WorkbenchWindow)workbenchWindow).isClosing()) {
            return;
        }
    }

    public boolean isRunning() {
        return this.runEventLoop;
    }

    public String getPresentationId() {
        String factoryId = PrefUtil.getAPIPreferenceStore().getString("presentationFactoryId");
        if (factoryId == null || factoryId.equals("")) {
            factoryId = "org.eclipse.ui.presentations.default";
        }
        return factoryId;
    }

    public final void largeUpdateStart() {
        if (this.largeUpdates++ == 0) {
            IWorkbenchWindow[] windows = this.getWorkbenchWindows();
            int i = 0;
            while (i < windows.length) {
                IWorkbenchWindow window = windows[i];
                if (window instanceof WorkbenchWindow) {
                    ((WorkbenchWindow)window).largeUpdateStart();
                }
                ++i;
            }
        }
    }

    public final void largeUpdateEnd() {
        if (--this.largeUpdates == 0) {
            IWorkbenchWindow[] windows = this.getWorkbenchWindows();
            int i = 0;
            while (i < windows.length) {
                IWorkbenchWindow window = windows[i];
                if (window instanceof WorkbenchWindow) {
                    ((WorkbenchWindow)window).largeUpdateEnd();
                }
                ++i;
            }
        }
    }

    public IExtensionTracker getExtensionTracker() {
        if (this.tracker == null) {
            this.tracker = new UIExtensionTracker(this.getDisplay());
        }
        return this.tracker;
    }

    private void addStartupRegistryListener() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener(this.startupRegistryListener);
    }

    public IViewRegistry getViewRegistry() {
        return WorkbenchPlugin.getDefault().getViewRegistry();
    }

    public final Object getAdapter(Class key) {
        return this.services.get(key);
    }

    public static void setExceptionHandler(IExceptionHandler handler) {
        if (exceptionHandler instanceof DefaultExceptionHandler) {
            exceptionHandler = handler;
        }
    }

    boolean isOpenShellEnabled() {
        return this.openShellEnabled;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public static interface IExceptionHandler {
        public void handleException(Throwable var1);
    }

    private static class DefaultExceptionHandler
    implements IExceptionHandler {
        private DefaultExceptionHandler() {
        }

        public void handleException(Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            t.printStackTrace();
        }
    }
}

