/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.dnd.SwtUtil;
import org.eclipse.ui.presentations.IPresentablePart;

public class PresentablePart
implements IPresentablePart {
    private PartPane part;
    private List listeners = new ArrayList();
    private IPropertyListener lazyPropertyListenerProxy;

    public PresentablePart(PartPane part) {
        this.part = part;
    }

    private IPropertyListener getPropertyListenerProxy() {
        if (this.lazyPropertyListenerProxy == null) {
            this.lazyPropertyListenerProxy = new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    PresentablePart.this.firePropertyChange(propId);
                }
            };
        }
        return this.lazyPropertyListenerProxy;
    }

    private WorkbenchPartReference getPartReference() {
        return (WorkbenchPartReference)this.part.getPartReference();
    }

    public void dispose() {
        this.getPartReference().removePropertyListener(this.getPropertyListenerProxy());
        this.part = null;
        this.listeners.clear();
        this.listeners = null;
    }

    public void firePropertyChange(int propertyId) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((IPropertyListener)this.listeners.get(i)).propertyChanged(this, propertyId);
            ++i;
        }
    }

    public void addPropertyListener(IPropertyListener listener) {
        if (this.listeners.isEmpty()) {
            this.getPartReference().addPropertyListener(this.getPropertyListenerProxy());
        }
        this.listeners.add(listener);
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.getPartReference().removePropertyListener(this.getPropertyListenerProxy());
        }
    }

    public void setBounds(Rectangle bounds) {
        if (!SwtUtil.isDisposed(this.part.getControl())) {
            this.part.setBounds(bounds);
        }
    }

    public void setVisible(boolean isVisible) {
        this.part.setVisible(isVisible);
    }

    public void setFocus() {
        if (!SwtUtil.isDisposed(this.part.getControl())) {
            this.part.setFocus();
        }
    }

    public String getName() {
        return this.getPartReference().getPartName();
    }

    public String getTitle() {
        return this.getPartReference().getTitle();
    }

    public String getTitleStatus() {
        return this.getPartReference().getContentDescription();
    }

    public Image getTitleImage() {
        return this.getPartReference().getTitleImage();
    }

    public String getTitleToolTip() {
        return this.getPartReference().getTitleToolTip();
    }

    public boolean isDirty() {
        return this.getPartReference().isDirty();
    }

    public boolean isBusy() {
        return this.part.isBusy();
    }

    public Control getToolBar() {
        return this.part.getToolBar();
    }

    public boolean isCloseable() {
        return this.part.isCloseable();
    }

    public Control getControl() {
        return this.part.getControl();
    }
}

