/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.AllPermission;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.PermissionStorage;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleCombinedPermissions;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionInfoImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.permissionadmin.PermissionInfo;

public class ConditionalPermissionAdminImpl
implements ConditionalPermissionAdmin {
    public static final ConditionalPermissionInfoImpl[] EMPTY_COND_PERM_INFO = new ConditionalPermissionInfoImpl[0];
    public static final Condition[] EMPTY_COND = new Condition[0];
    public static final ConditionInfo[] EMPTY_COND_INFO = new ConditionInfo[0];
    public static final PermissionInfo[] EMPTY_PERM_INFO = new PermissionInfo[0];
    private Vector condPerms;
    private Framework framework;
    private PermissionStorage storage;
    private long nextID = System.currentTimeMillis();
    static /* synthetic */ Class class$0;

    public ConditionalPermissionAdminImpl(Framework framework, PermissionStorage permissionStorage) {
        ConditionalPermissionInfoImpl.setConditionalPermissionAdminImpl(this);
        this.framework = framework;
        this.storage = permissionStorage;
        try {
            String[] stringArray = permissionStorage.getConditionalPermissionInfos();
            if (stringArray != null && stringArray.length > 0) {
                this.condPerms = new Vector(stringArray.length);
                int n = 0;
                while (n < stringArray.length) {
                    this.condPerms.add(new ConditionalPermissionInfoImpl(stringArray[n]));
                    ++n;
                }
            } else {
                this.condPerms = new Vector(0);
            }
        }
        catch (IOException iOException) {
            framework.publishFrameworkEvent(2, framework.systemBundle, iOException);
            this.condPerms = new Vector();
        }
    }

    public ConditionalPermissionInfo addConditionalPermissionInfo(ConditionInfo[] conditionInfoArray, PermissionInfo[] permissionInfoArray) {
        return this.setConditionalPermissionInfo(null, conditionInfoArray, permissionInfoArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConditionalPermissionInfo setConditionalPermissionInfo(String string, ConditionInfo[] conditionInfoArray, PermissionInfo[] permissionInfoArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AllPermission());
        }
        if (string == null) {
            string = "generated_" + Long.toString(this.nextID++);
        }
        ConditionalPermissionInfoImpl conditionalPermissionInfoImpl = null;
        AbstractBundle[] abstractBundleArray = this.condPerms;
        synchronized (this.condPerms) {
            conditionalPermissionInfoImpl = (ConditionalPermissionInfoImpl)this.getConditionalPermissionInfo(string);
            if (conditionalPermissionInfoImpl == null) {
                conditionalPermissionInfoImpl = new ConditionalPermissionInfoImpl(string, conditionInfoArray, permissionInfoArray);
                this.condPerms.add(conditionalPermissionInfoImpl);
            } else {
                conditionalPermissionInfoImpl.conds = conditionInfoArray;
                conditionalPermissionInfoImpl.perms = permissionInfoArray;
            }
            this.saveCondPermInfos();
            // ** MonitorExit[var6_6] (shouldn't be in output)
            abstractBundleArray = this.framework.getAllBundles();
            int n = 0;
            while (n < abstractBundleArray.length) {
                AbstractBundle abstractBundle = abstractBundleArray[n];
                if (abstractBundle.domain != null) {
                    BundleCombinedPermissions bundleCombinedPermissions = (BundleCombinedPermissions)abstractBundle.domain.getPermissions();
                    if (permissionInfoArray != null) {
                        bundleCombinedPermissions.checkConditionalPermissionInfo(conditionalPermissionInfoImpl);
                    }
                }
                ++n;
            }
            return conditionalPermissionInfoImpl;
        }
    }

    public ConditionalPermissionInfo getConditionalPermissionInfo(String string) {
        Enumeration enumeration = this.condPerms.elements();
        while (enumeration.hasMoreElements()) {
            ConditionalPermissionInfoImpl conditionalPermissionInfoImpl = (ConditionalPermissionInfoImpl)enumeration.nextElement();
            if (!string.equals(conditionalPermissionInfoImpl.getName())) continue;
            return conditionalPermissionInfoImpl;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getConditionalPermissionInfos() {
        Vector vector = this.condPerms;
        synchronized (vector) {
            return this.condPerms.elements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteConditionalPermissionInfo(ConditionalPermissionInfo conditionalPermissionInfo) {
        Vector vector = this.condPerms;
        synchronized (vector) {
            this.condPerms.remove(conditionalPermissionInfo);
            this.saveCondPermInfos();
        }
    }

    private void saveCondPermInfos() {
        try {
            String[] stringArray = new String[this.condPerms.size()];
            int n = 0;
            Enumeration enumeration = this.condPerms.elements();
            while (enumeration.hasMoreElements()) {
                stringArray[n] = enumeration.nextElement().toString();
                ++n;
            }
            this.storage.saveConditionalPermissionInfos(stringArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, iOException);
        }
    }

    public AccessControlContext getAccessControlContext(String[] stringArray) {
        ProtectionDomain[] protectionDomainArray;
        Serializable serializable;
        Enumeration enumeration = this.getConditionalPermissionInfos();
        ArrayList<PermissionInfo> arrayList = new ArrayList<PermissionInfo>();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                serializable = (ConditionalPermissionInfoImpl)enumeration.nextElement();
                ConditionInfo[] conditionInfoArray = ((ConditionalPermissionInfoImpl)serializable).getConditionInfos();
                boolean bl = true;
                int n = 0;
                while (n < conditionInfoArray.length) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.osgi.service.condpermadmin.BundleSignerCondition");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!clazz.getName().equals(conditionInfoArray[n].getType())) {
                        bl = false;
                        break;
                    }
                    String[] stringArray2 = conditionInfoArray[n].getArgs();
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        if (!this.framework.adaptor.matchDNChain(stringArray2[n2], stringArray)) {
                            bl = false;
                            break;
                        }
                        ++n2;
                    }
                    ++n;
                }
                if (!bl) continue;
                PermissionInfo[] permissionInfoArray = ((ConditionalPermissionInfoImpl)serializable).getPermissionInfos();
                int n3 = 0;
                while (n3 < permissionInfoArray.length) {
                    arrayList.add(permissionInfoArray[n3]);
                    ++n3;
                }
            }
        }
        if ((serializable = this.framework.permissionAdmin.createPermissions(arrayList.toArray(new PermissionInfo[arrayList.size()]), null, false)) == null) {
            protectionDomainArray = new ProtectionDomain[]{};
        } else {
            ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[1];
            protectionDomainArray = protectionDomainArray2;
            protectionDomainArray2[0] = new ProtectionDomain(null, (PermissionCollection)serializable);
        }
        return new AccessControlContext(protectionDomainArray);
    }
}

