/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import org.eclipse.ercp.swt.mobile.CaptionedControl;
import org.eclipse.ercp.swt.mobile.IndexData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

final class IndexLayout
extends Layout {
    public int type = 256;
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int spacing = 3;
    public boolean wrap = true;
    public boolean pack = true;
    public boolean fill = false;
    public boolean justify = false;
    public int marginLeft = 3;
    public int marginTop = 3;
    public int marginRight = 3;
    public int marginBottom = 3;

    public IndexLayout() {
    }

    public IndexLayout(int type) {
        this.type = type;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Point extent = this.type == 256 ? this.layoutHorizontal(composite, false, wHint != -1 && this.wrap, wHint, flushCache) : this.layoutVertical(composite, false, hHint != -1 && this.wrap, hHint, flushCache);
        if (wHint != -1) {
            extent.x = wHint;
        }
        if (hHint != -1) {
            extent.y = hHint;
        }
        return extent;
    }

    Point computeSize(Control control, boolean flushCache) {
        int wHint = -1;
        int hHint = -1;
        IndexData data = (IndexData)control.getLayoutData();
        if (data != null) {
            wHint = data.width;
            hHint = data.height;
        }
        return control.computeSize(wHint, hHint, flushCache);
    }

    protected boolean flushCache(Control control) {
        return true;
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.lastIndexOf(46);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1, string.length());
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle clientArea = composite.getClientArea();
        if (this.type == 256) {
            Point p = this.layoutHorizontal(composite, true, this.wrap, clientArea.width, flushCache);
        } else {
            this.layoutVertical(composite, true, this.wrap, clientArea.height, flushCache);
        }
    }

    Point layoutHorizontal(Composite composite, boolean move, boolean wrap, int width, boolean flushCache) {
        Control temp;
        Control[] children = composite.getChildren();
        int innerControlWidth = 0;
        int label_count = 0;
        CaptionedControl captionedControl = (CaptionedControl)composite;
        if (children.length == 2) {
            if (children[0] instanceof Label && children[1] instanceof Label) {
                if (((CaptionedControl)composite).orientationStyle == 0x2000000) {
                    if (captionedControl.captionLabel != null) {
                        if (captionedControl.captionLabel.equals((Label)children[1])) {
                            temp = children[0];
                            children[0] = children[1];
                            children[1] = temp;
                        }
                    } else if (captionedControl.trailingLabel != null && captionedControl.trailingLabel.equals((Label)children[0])) {
                        temp = children[1];
                        children[1] = children[0];
                        children[0] = temp;
                    }
                } else if (((CaptionedControl)composite).orientationStyle == 0x4000000) {
                    if (captionedControl.captionLabel != null) {
                        if (captionedControl.captionLabel.equals((Label)children[0])) {
                            temp = children[1];
                            children[1] = children[0];
                            children[0] = temp;
                        }
                    } else if (captionedControl.trailingLabel != null && captionedControl.trailingLabel.equals((Label)children[1])) {
                        temp = children[0];
                        children[0] = children[1];
                        children[1] = temp;
                    }
                }
            } else if (children[0] instanceof Label) {
                innerControlWidth = width - children[0].computeSize((int)-1, (int)-1).x - 3 * this.spacing;
            } else if (children[1] instanceof Label) {
                innerControlWidth = width - children[1].computeSize((int)-1, (int)-1).x - 3 * this.spacing;
            }
        } else if (children.length == 3) {
            if (children[0] instanceof Label && children[1] instanceof Label && children[2] instanceof Label) {
                if (((CaptionedControl)composite).orientationStyle == 0x2000000) {
                    if (captionedControl.captionLabel != null) {
                        for (label_count = 1; label_count <= 2; ++label_count) {
                            if (!captionedControl.captionLabel.equals((Label)children[label_count])) continue;
                            temp = children[0];
                            children[0] = children[label_count];
                            children[label_count] = temp;
                        }
                    }
                    if (captionedControl.trailingLabel != null) {
                        for (label_count = 0; label_count <= 1; ++label_count) {
                            if (!captionedControl.trailingLabel.equals((Label)children[label_count])) continue;
                            temp = children[2];
                            children[2] = children[label_count];
                            children[label_count] = temp;
                        }
                    }
                } else if (((CaptionedControl)composite).orientationStyle == 0x4000000) {
                    if (captionedControl.captionLabel != null) {
                        for (label_count = 0; label_count <= 1; ++label_count) {
                            if (!captionedControl.captionLabel.equals((Label)children[label_count])) continue;
                            temp = children[2];
                            children[2] = children[label_count];
                            children[label_count] = temp;
                        }
                    }
                    if (captionedControl.trailingLabel != null) {
                        for (label_count = 1; label_count <= 2; ++label_count) {
                            if (!captionedControl.trailingLabel.equals((Label)children[label_count])) continue;
                            temp = children[0];
                            children[0] = children[label_count];
                            children[label_count] = temp;
                        }
                    }
                }
            } else if (captionedControl.headingIndex == 0) {
                innerControlWidth = width - children[0].computeSize((int)-1, (int)-1).x - children[2].computeSize((int)-1, (int)-1).x - 4 * this.spacing;
            } else if (captionedControl.imgIndex == 0) {
                innerControlWidth = width - children[0].computeSize((int)-1, (int)-1).x - children[2].computeSize((int)-1, (int)-1).x - 4 * this.spacing;
            } else if (captionedControl.trailingIndex == 0) {
                innerControlWidth = width - children[0].computeSize((int)-1, (int)-1).x - children[1].computeSize((int)-1, (int)-1).x - 4 * this.spacing;
            }
        } else if (children.length == 4) {
            innerControlWidth = width - children[0].computeSize((int)-1, (int)-1).x - children[1].computeSize((int)-1, (int)-1).x - children[3].computeSize((int)-1, (int)-1).x - 5 * this.spacing;
        }
        int count = children.length;
        int childWidth = 0;
        int childHeight = 0;
        int maxHeight = 0;
        if (!this.pack) {
            for (int i = 0; i < count; ++i) {
                Control child = children[i];
                Point size = this.computeSize(child, flushCache);
                childWidth = Math.max(childWidth, size.x);
                childHeight = Math.max(childHeight, size.y);
            }
            maxHeight = childHeight;
        }
        int clientX = 0;
        int clientY = 0;
        if (move) {
            Rectangle rect = composite.getClientArea();
            clientX = rect.x;
            clientY = rect.y;
        }
        int[] wraps = null;
        boolean wrapped = false;
        Rectangle[] bounds = null;
        if (move && (this.justify || this.fill)) {
            bounds = new Rectangle[count];
            wraps = new int[count];
        }
        int maxX = 0;
        int x = this.marginLeft + this.marginWidth;
        int y = this.marginTop + this.marginHeight;
        for (int i = 0; i < count; ++i) {
            Control child = children[i];
            if (this.pack) {
                Point size = this.computeSize(child, flushCache);
                childWidth = size.x;
                childHeight = size.y;
            }
            if (wrap && i != 0 && x + childWidth > width) {
                wrapped = true;
                if (move && (this.justify || this.fill)) {
                    wraps[i - 1] = maxHeight;
                }
                x = this.marginLeft + this.marginWidth;
                y += this.spacing + maxHeight;
                if (this.pack) {
                    maxHeight = 0;
                }
            }
            if (this.pack || this.fill) {
                maxHeight = Math.max(maxHeight, childHeight);
            }
            if (move) {
                int childX = x + clientX;
                int childY = y + clientY;
                if (this.justify || this.fill) {
                    bounds[i] = new Rectangle(childX, childY, childWidth, childHeight);
                } else {
                    if (!(children[i] instanceof Label)) {
                        childWidth = innerControlWidth;
                        childHeight = composite.getSize().y - this.marginTop - this.marginBottom;
                    }
                    child.setBounds(childX, childY, childWidth, childHeight);
                }
            }
            maxX = Math.max(maxX, x += this.spacing + childWidth);
        }
        maxX = Math.max(clientX + this.marginLeft + this.marginWidth, maxX - this.spacing);
        if (!wrapped) {
            maxX += this.marginRight + this.marginWidth;
        }
        if (move && (this.justify || this.fill)) {
            int space = 0;
            int margin = 0;
            if (!wrapped) {
                space = Math.max(0, (width - maxX) / (count + 1));
                margin = Math.max(0, (width - maxX) % (count + 1) / 2);
            } else if (this.fill || this.justify) {
                int last = 0;
                if (count > 0) {
                    wraps[count - 1] = maxHeight;
                }
                for (int i = 0; i < count; ++i) {
                    if (wraps[i] == 0) continue;
                    int wrapCount = i - last + 1;
                    if (this.justify) {
                        int wrapX = 0;
                        for (int j = last; j <= i; ++j) {
                            wrapX += bounds[j].width + this.spacing;
                        }
                        space = Math.max(0, (width - wrapX) / (wrapCount + 1));
                        margin = Math.max(0, (width - wrapX) % (wrapCount + 1) / 2);
                    }
                    for (int j = last; j <= i; ++j) {
                        if (this.justify) {
                            bounds[j].x += space * (j - last + 1) + margin;
                        }
                        if (!this.fill) continue;
                        bounds[j].height = wraps[i];
                    }
                    last = i + 1;
                }
            }
            for (int i = 0; i < count; ++i) {
                if (!wrapped) {
                    if (this.justify) {
                        bounds[i].x += space * (i + 1) + margin;
                    }
                    if (this.fill) {
                        bounds[i].height = maxHeight;
                    }
                }
                children[i].setBounds(bounds[i]);
            }
        }
        return new Point(maxX, y + maxHeight + this.marginBottom + this.marginHeight);
    }

    Point layoutVertical(Composite composite, boolean move, boolean wrap, int height, boolean flushCache) {
        Control temp;
        Control[] children = composite.getChildren();
        if (children.length == 4) {
            if (children[2] instanceof Label) {
                temp = children[2];
                children[2] = children[3];
                children[3] = temp;
            }
            if (((CaptionedControl)composite).orientationStyle == 0x4000000) {
                temp = children[3];
                children[3] = children[0];
                children[0] = temp;
                temp = children[2];
                children[2] = children[1];
                children[1] = temp;
            }
        } else if (children.length == 3 && ((CaptionedControl)composite).orientationStyle == 0x4000000) {
            temp = children[2];
            children[2] = children[0];
            children[0] = temp;
        }
        int count = children.length;
        int childWidth = 0;
        int childHeight = 0;
        int maxWidth = 0;
        if (!this.pack) {
            for (int i = 0; i < count; ++i) {
                Control child = children[i];
                Point size = this.computeSize(child, flushCache);
                childWidth = Math.max(childWidth, size.x);
                childHeight = Math.max(childHeight, size.y);
            }
            maxWidth = childWidth;
        }
        int clientX = 0;
        int clientY = 0;
        if (move) {
            Rectangle rect = composite.getClientArea();
            clientX = rect.x;
            clientY = rect.y;
        }
        int[] wraps = null;
        boolean wrapped = false;
        Rectangle[] bounds = null;
        if (move && (this.justify || this.fill)) {
            bounds = new Rectangle[count];
            wraps = new int[count];
        }
        int maxY = 0;
        int x = this.marginLeft + this.marginWidth;
        int y = this.marginTop + this.marginHeight;
        for (int i = 0; i < count; ++i) {
            Control child = children[i];
            if (this.pack) {
                Point size = this.computeSize(child, flushCache);
                childWidth = size.x;
                childHeight = size.y;
            }
            if (wrap && i != 0 && y + childHeight > height) {
                wrapped = true;
                if (move && (this.justify || this.fill)) {
                    wraps[i - 1] = maxWidth;
                }
                x += this.spacing + maxWidth;
                y = this.marginTop + this.marginHeight;
                if (this.pack) {
                    maxWidth = 0;
                }
            }
            if (this.pack || this.fill) {
                maxWidth = Math.max(maxWidth, childWidth);
            }
            if (move) {
                int childX = x + clientX;
                int childY = y + clientY;
                if (this.justify || this.fill) {
                    bounds[i] = new Rectangle(childX, childY, childWidth, childHeight);
                } else {
                    child.setBounds(childX, childY, childWidth, childHeight);
                }
            }
            maxY = Math.max(maxY, y += this.spacing + childHeight);
        }
        maxY = Math.max(clientY + this.marginTop + this.marginHeight, maxY - this.spacing);
        if (!wrapped) {
            maxY += this.marginBottom + this.marginHeight;
        }
        if (move && (this.justify || this.fill)) {
            int space = 0;
            int margin = 0;
            if (!wrapped) {
                space = Math.max(0, (height - maxY) / (count + 1));
                margin = Math.max(0, (height - maxY) % (count + 1) / 2);
            } else if (this.fill || this.justify) {
                int last = 0;
                if (count > 0) {
                    wraps[count - 1] = maxWidth;
                }
                for (int i = 0; i < count; ++i) {
                    if (wraps[i] == 0) continue;
                    int wrapCount = i - last + 1;
                    if (this.justify) {
                        int wrapY = 0;
                        for (int j = last; j <= i; ++j) {
                            wrapY += bounds[j].height + this.spacing;
                        }
                        space = Math.max(0, (height - wrapY) / (wrapCount + 1));
                        margin = Math.max(0, (height - wrapY) % (wrapCount + 1) / 2);
                    }
                    for (int j = last; j <= i; ++j) {
                        if (this.justify) {
                            bounds[j].y += space * (j - last + 1) + margin;
                        }
                        if (!this.fill) continue;
                        bounds[j].width = wraps[i];
                    }
                    last = i + 1;
                }
            }
            for (int i = 0; i < count; ++i) {
                if (!wrapped) {
                    if (this.justify) {
                        bounds[i].y += space * (i + 1) + margin;
                    }
                    if (this.fill) {
                        bounds[i].width = maxWidth;
                    }
                }
                children[i].setBounds(bounds[i]);
            }
        }
        return new Point(x + maxWidth + this.marginRight + this.marginWidth, maxY);
    }

    public String toString() {
        String string = this.getName() + " {";
        string = string + "type=" + (this.type != 256 ? "SWT.VERTICAL" : "SWT.HORIZONTAL") + " ";
        if (this.marginWidth != 0) {
            string = string + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            string = string + "marginHeight=" + this.marginHeight + " ";
        }
        if (this.marginLeft != 0) {
            string = string + "marginLeft=" + this.marginLeft + " ";
        }
        if (this.marginTop != 0) {
            string = string + "marginTop=" + this.marginTop + " ";
        }
        if (this.marginRight != 0) {
            string = string + "marginRight=" + this.marginRight + " ";
        }
        if (this.marginBottom != 0) {
            string = string + "marginBottom=" + this.marginBottom + " ";
        }
        if (this.spacing != 0) {
            string = string + "spacing=" + this.spacing + " ";
        }
        string = string + "wrap=" + this.wrap + " ";
        string = string + "pack=" + this.pack + " ";
        string = string + "fill=" + this.fill + " ";
        string = string + "justify=" + this.justify + " ";
        string = string.trim();
        string = string + "}";
        return string;
    }
}

