/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.operations.Operation;
import org.eclipse.update.internal.operations.PatchCleaner;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IFeatureOperation;

public abstract class FeatureOperation
extends Operation
implements IFeatureOperation {
    protected IFeature feature;
    protected IFeature oldFeature;
    protected IConfiguredSite targetSite;

    public FeatureOperation(IConfiguredSite iConfiguredSite, IFeature iFeature) {
        this.feature = iFeature;
        this.targetSite = iConfiguredSite;
    }

    public IFeature getFeature() {
        return this.feature;
    }

    public IFeature getOldFeature() {
        return this.oldFeature;
    }

    public IConfiguredSite getTargetSite() {
        return this.targetSite;
    }

    public void setTargetSite(IConfiguredSite iConfiguredSite) {
        this.targetSite = iConfiguredSite;
    }

    static boolean unconfigure(IFeature iFeature, IConfiguredSite iConfiguredSite) throws CoreException {
        IInstallConfiguration iInstallConfiguration = SiteManager.getLocalSite().getCurrentConfiguration();
        if (iConfiguredSite == null) {
            iConfiguredSite = UpdateUtils.getConfigSite(iFeature, iInstallConfiguration);
        }
        if (iConfiguredSite != null) {
            PatchCleaner patchCleaner = new PatchCleaner(iConfiguredSite, iFeature);
            boolean bl = iConfiguredSite.unconfigure(iFeature);
            patchCleaner.dispose();
            return bl;
        }
        return false;
    }
}

