/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.internal.runtime.Activator;
import org.eclipse.core.internal.runtime.DevClassPathHelper;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class ResourceTranslator {
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";

    public static String getResourceString(Bundle bundle, String string) {
        return ResourceTranslator.getResourceString(bundle, string, null);
    }

    public static String getResourceString(Bundle bundle, String string, ResourceBundle resourceBundle) {
        String string2;
        String string3 = string.trim();
        if (!string3.startsWith(KEY_PREFIX, 0)) {
            return string3;
        }
        if (string3.startsWith(KEY_DOUBLE_PREFIX, 0)) {
            return string3.substring(1);
        }
        int n = string3.indexOf(32);
        String string4 = n == -1 ? string3 : string3.substring(0, n);
        String string5 = string2 = n == -1 ? string3 : string3.substring(n + 1);
        if (resourceBundle == null && bundle != null) {
            try {
                resourceBundle = ResourceTranslator.getResourceBundle(bundle);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        if (resourceBundle == null) {
            return string2;
        }
        try {
            return resourceBundle.getString(string4.substring(1));
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    public static ResourceBundle getResourceBundle(Bundle bundle) throws MissingResourceException {
        if (ResourceTranslator.hasRuntime21(bundle)) {
            return ResourceBundle.getBundle("plugin", Locale.getDefault(), ResourceTranslator.createTempClassloader(bundle));
        }
        return Activator.getDefault().getLocalization(bundle, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasRuntime21(Bundle bundle) {
        try {
            ManifestElement[] manifestElementArray = ManifestElement.parseHeader((String)"Require-Bundle", (String)((String)bundle.getHeaders("").get("Require-Bundle")));
            if (manifestElementArray == null) {
                return false;
            }
            int n = 0;
            while (true) {
                if (n >= manifestElementArray.length) {
                    return false;
                }
                if ("2.1".equals(manifestElementArray[n].getAttribute("bundle-version")) && "org.eclipse.core.runtime".equals(manifestElementArray[n].getValue())) {
                    return true;
                }
                ++n;
            }
        }
        catch (BundleException bundleException) {
            return false;
        }
    }

    private static ClassLoader createTempClassloader(Bundle bundle) {
        ArrayList arrayList = new ArrayList();
        ResourceTranslator.addClasspathEntries(bundle, arrayList);
        ResourceTranslator.addBundleRoot(bundle, arrayList);
        ResourceTranslator.addDevEntries(bundle, arrayList);
        ResourceTranslator.addFragments(bundle, arrayList);
        URL[] uRLArray = new URL[arrayList.size()];
        return new URLClassLoader(arrayList.toArray(uRLArray));
    }

    private static void addFragments(Bundle bundle, ArrayList arrayList) {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return;
        }
        Bundle[] bundleArray = activator.getFragments(bundle);
        if (bundleArray == null) {
            return;
        }
        int n = 0;
        while (n < bundleArray.length) {
            ResourceTranslator.addClasspathEntries(bundleArray[n], arrayList);
            ResourceTranslator.addDevEntries(bundleArray[n], arrayList);
            ++n;
        }
    }

    private static void addClasspathEntries(Bundle bundle, ArrayList arrayList) {
        try {
            ManifestElement[] manifestElementArray = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)((String)bundle.getHeaders("").get("Bundle-ClassPath")));
            if (manifestElementArray == null) {
                return;
            }
            int n = 0;
            while (n < manifestElementArray.length) {
                URL uRL = bundle.getEntry(manifestElementArray[n].getValue());
                if (uRL != null) {
                    arrayList.add(uRL);
                }
                ++n;
            }
        }
        catch (BundleException bundleException) {}
    }

    private static void addBundleRoot(Bundle bundle, ArrayList arrayList) {
        arrayList.add(bundle.getEntry("/"));
    }

    private static void addDevEntries(Bundle bundle, ArrayList arrayList) {
        if (!DevClassPathHelper.inDevelopmentMode()) {
            return;
        }
        String[] stringArray = DevClassPathHelper.getDevClassPath(bundle.getSymbolicName());
        int n = 0;
        while (n < stringArray.length) {
            URL uRL = bundle.getEntry(stringArray[n]);
            if (uRL != null) {
                arrayList.add(uRL);
            }
            ++n;
        }
    }
}

