/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener2;
import org.eclipse.ui.IPerspectiveListener3;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.misc.UIStats;

public class PerspectiveListenerList {
    private ListenerList listeners = new ListenerList();

    public void addPerspectiveListener(IPerspectiveListener iPerspectiveListener) {
        this.listeners.add((Object)iPerspectiveListener);
    }

    private void fireEvent(SafeRunnable safeRunnable, IPerspectiveListener iPerspectiveListener, IPerspectiveDescriptor iPerspectiveDescriptor, String string) {
        String string2 = null;
        if (UIStats.isDebugging(12)) {
            string2 = String.valueOf(string) + iPerspectiveDescriptor.getId();
            UIStats.start(12, string2);
        }
        Platform.run((ISafeRunnable)safeRunnable);
        if (UIStats.isDebugging(12)) {
            UIStats.end(12, iPerspectiveListener, string2);
        }
    }

    public void firePerspectiveActivated(final IWorkbenchPage iWorkbenchPage, final IPerspectiveDescriptor iPerspectiveDescriptor) {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IPerspectiveListener iPerspectiveListener = (IPerspectiveListener)objectArray[n];
            this.fireEvent(new SafeRunnable(){

                public void run() {
                    iPerspectiveListener.perspectiveActivated(iWorkbenchPage, iPerspectiveDescriptor);
                }
            }, iPerspectiveListener, iPerspectiveDescriptor, "activated::");
            ++n;
        }
    }

    public void firePerspectiveDeactivated(final IWorkbenchPage iWorkbenchPage, final IPerspectiveDescriptor iPerspectiveDescriptor) {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof IPerspectiveListener3) {
                final IPerspectiveListener3 iPerspectiveListener3 = (IPerspectiveListener3)objectArray[n];
                this.fireEvent(new SafeRunnable(){

                    public void run() {
                        iPerspectiveListener3.perspectiveDeactivated(iWorkbenchPage, iPerspectiveDescriptor);
                    }
                }, iPerspectiveListener3, iPerspectiveDescriptor, "deactivated::");
            }
            ++n;
        }
    }

    public void firePerspectiveChanged(final IWorkbenchPage iWorkbenchPage, final IPerspectiveDescriptor iPerspectiveDescriptor, final String string) {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IPerspectiveListener iPerspectiveListener = (IPerspectiveListener)objectArray[n];
            this.fireEvent(new SafeRunnable(){

                public void run() {
                    iPerspectiveListener.perspectiveChanged(iWorkbenchPage, iPerspectiveDescriptor, string);
                }
            }, iPerspectiveListener, iPerspectiveDescriptor, "changed::");
            ++n;
        }
    }

    public void firePerspectiveChanged(final IWorkbenchPage iWorkbenchPage, final IPerspectiveDescriptor iPerspectiveDescriptor, final IWorkbenchPartReference iWorkbenchPartReference, final String string) {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof IPerspectiveListener2) {
                final IPerspectiveListener2 iPerspectiveListener2 = (IPerspectiveListener2)objectArray[n];
                this.fireEvent(new SafeRunnable(){

                    public void run() {
                        iPerspectiveListener2.perspectiveChanged(iWorkbenchPage, iPerspectiveDescriptor, iWorkbenchPartReference, string);
                    }
                }, iPerspectiveListener2, iPerspectiveDescriptor, "changed::");
            }
            ++n;
        }
    }

    public void firePerspectiveClosed(final IWorkbenchPage iWorkbenchPage, final IPerspectiveDescriptor iPerspectiveDescriptor) {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof IPerspectiveListener3) {
                final IPerspectiveListener3 iPerspectiveListener3 = (IPerspectiveListener3)objectArray[n];
                this.fireEvent(new SafeRunnable(){

                    public void run() {
                        iPerspectiveListener3.perspectiveClosed(iWorkbenchPage, iPerspectiveDescriptor);
                    }
                }, iPerspectiveListener3, iPerspectiveDescriptor, "closed::");
            }
            ++n;
        }
    }

    public void firePerspectiveOpened(final IWorkbenchPage iWorkbenchPage, final IPerspectiveDescriptor iPerspectiveDescriptor) {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof IPerspectiveListener3) {
                final IPerspectiveListener3 iPerspectiveListener3 = (IPerspectiveListener3)objectArray[n];
                this.fireEvent(new SafeRunnable(){

                    public void run() {
                        iPerspectiveListener3.perspectiveOpened(iWorkbenchPage, iPerspectiveDescriptor);
                    }
                }, iPerspectiveListener3, iPerspectiveDescriptor, "opened::");
            }
            ++n;
        }
    }

    public void firePerspectiveSavedAs(final IWorkbenchPage iWorkbenchPage, final IPerspectiveDescriptor iPerspectiveDescriptor, final IPerspectiveDescriptor iPerspectiveDescriptor2) {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof IPerspectiveListener3) {
                final IPerspectiveListener3 iPerspectiveListener3 = (IPerspectiveListener3)objectArray[n];
                this.fireEvent(new SafeRunnable(){

                    public void run() {
                        iPerspectiveListener3.perspectiveSavedAs(iWorkbenchPage, iPerspectiveDescriptor, iPerspectiveDescriptor2);
                    }
                }, iPerspectiveListener3, iPerspectiveDescriptor2, "saveAs::");
            }
            ++n;
        }
    }

    public void removePerspectiveListener(IPerspectiveListener iPerspectiveListener) {
        this.listeners.remove((Object)iPerspectiveListener);
    }
}

