/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.eclipse.ercp.xml.io.IanaJavaMap;
import org.eclipse.ercp.xml.io.SimpleBufferedInputStream;
import org.eclipse.ercp.xml.io.StreamDecoder;
import org.eclipse.ercp.xml.io.StreamDecoder_ASCII;
import org.eclipse.ercp.xml.io.StreamDecoder_ISO8859_1;
import org.eclipse.ercp.xml.io.StreamDecoder_UTF16BE;
import org.eclipse.ercp.xml.io.StreamDecoder_UTF16LE;
import org.eclipse.ercp.xml.io.StreamDecoder_UTF8;

public class XmlInputStreamReader
extends Reader {
    SimpleBufferedInputStream in;
    Reader decoder;

    public XmlInputStreamReader(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    public XmlInputStreamReader(InputStream inputStream, String string) throws IOException {
        this.in = new SimpleBufferedInputStream(inputStream);
        this.decoder = this.createFirstDecoder(string);
    }

    Reader createFirstDecoder(String string) throws UnsupportedEncodingException {
        int n = 3;
        if (string == null) {
            byte[] byArray = new byte[n];
            int n2 = -1;
            try {
                n2 = this.in.read(byArray, 0, n);
            }
            catch (IOException iOException) {}
            if (n2 == -1) {
                string = "UTF-8";
            } else if (n2 < n) {
                this.in.unread(byArray, n2);
            } else {
                int n3 = byArray[0] & 0xFF;
                int n4 = byArray[1] & 0xFF;
                int n5 = byArray[2] & 0xFF;
                if (n3 == 254 && n4 == 255) {
                    string = "UTF-16BE";
                    n -= 2;
                } else if (n3 == 255 && n4 == 254) {
                    string = "UTF-16LE";
                    n -= 2;
                } else if (n3 == 239 && n4 == 187 && n5 == 191) {
                    string = "UTF-8";
                    n -= 3;
                } else {
                    string = "UTF-8";
                }
                this.in.unread(byArray, n);
            }
        }
        return this.createDecoder(string);
    }

    Reader createDecoder(String string) throws UnsupportedEncodingException {
        if ((string = string == null ? "UTF-8" : string.toUpperCase()).equals("UTF-8")) {
            return new StreamDecoder_UTF8(this.in);
        }
        if (string.equals("ASCII")) {
            return new StreamDecoder_ASCII(this.in);
        }
        if (string.equals("ISO8859_1")) {
            return new StreamDecoder_ISO8859_1(this.in);
        }
        if (string.equals("UTF-16BE")) {
            return new StreamDecoder_UTF16BE(this.in);
        }
        if (string.equals("UTF-16LE")) {
            return new StreamDecoder_UTF16LE(this.in);
        }
        if (string == null) {
            return new InputStreamReader(this.in);
        }
        String string2 = IanaJavaMap.getIana2Java(string);
        if (string2 == null) {
            throw new UnsupportedEncodingException(string);
        }
        return new InputStreamReader((InputStream)this.in, string2);
    }

    public void setEncoding(String string) throws UnsupportedEncodingException {
        StreamDecoder streamDecoder;
        if (this.decoder != null && this.decoder instanceof StreamDecoder && !(streamDecoder = (StreamDecoder)this.decoder).getEncoding().equals(string) && streamDecoder.supportNewEncoding()) {
            streamDecoder.restore();
            this.decoder = this.createDecoder(string);
        }
    }

    public final int read() throws IOException {
        return this.decoder.read();
    }

    public final int read(char[] cArray, int n, int n2) throws IOException {
        return this.decoder.read(cArray, n, n2);
    }

    public void close() throws IOException {
        if (this.decoder != null) {
            this.decoder.close();
        } else {
            this.in.close();
        }
    }

    InputStream getInputStream() {
        return this.in;
    }
}

