/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.Calendar;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.ercp.swt.mobile.QueryDialog;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarDataBase;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarDayViewScreen;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarEditDayView;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarEditDayViewListener;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarMonthView;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarMonthWidgetListener;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;

public class CalendarShowCase
extends ShowCase
implements CalendarMonthWidgetListener,
TraverseListener {
    private CalendarDataBase calendardatabase;
    private CalendarMonthView calendarmonthview;
    private CalendarEditDayView calendareditdayview;
    private CalendarDayViewScreen calendarDayViewScreen;
    CalendarEditDayViewListener editdaylistener;
    private boolean landscape;

    public String getName() {
        return Messages.getString("CalendarShowCase.0");
    }

    public void show() {
        Rectangle bgdArea = this.getComposite().getShell().getClientArea();
        this.landscape = bgdArea.width > 360 && bgdArea.width > bgdArea.height;
        this.calendardatabase = new CalendarDataBase();
        this.calendardatabase.buildSample();
        this.buildMonthShell();
        this.buildDayViewScreenShell();
        this.buildDayShell();
        this.calendarmonthview.activate();
    }

    public void editDay() {
        this.calendarmonthview.getDate();
        this.calendareditdayview.activate();
    }

    public Date goToDate(Shell parent) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        QueryDialog queryDate = new QueryDialog(parent, 65536, 4);
        Date defaultDate = (Date)this.calendarmonthview.getDate().clone();
        String defaultDateString = df.format(defaultDate);
        queryDate.setText(Messages.getString("CalendarShowCase.2"));
        queryDate.setPromptText(Messages.getString("CalendarShowCase.3"), defaultDateString);
        String result = queryDate.open();
        if (result != null) {
            try {
                Date resultdate = df.parse(result);
                this.calendarmonthview.setDate(resultdate);
                return resultdate;
            }
            catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public void quit() {
        this.calendarmonthview.dispose();
        this.calendareditdayview.dispose();
        this.dispose();
    }

    public void newDateSelected(Date date) {
        this.calendareditdayview.setDate(date);
        this.calendarmonthview.setTitle(date);
        this.calendarmonthview.redraw();
        this.calendareditdayview.redraw();
    }

    private void buildMonthShell() {
        this.calendarmonthview = new CalendarMonthView(this, this.calendardatabase);
    }

    private void buildDayShell() {
        this.calendareditdayview = new CalendarEditDayView(this, this.calendardatabase);
        this.calendareditdayview.setEditDayListener(this.calendarmonthview);
    }

    private void buildDayViewScreenShell() {
        this.calendarDayViewScreen = CalendarDayViewScreen.createUniqueInstance(this, this.calendardatabase);
    }

    public void keyTraversed(TraverseEvent e) {
        if (this.calendareditdayview.isSwitcher(e.widget)) {
            e.doit = false;
            if (this.landscape && (e.detail == 16 || e.detail == 8)) {
                this.calendarmonthview.activate();
            }
        } else if (this.calendarmonthview.isSwitcher(e.widget)) {
            e.doit = false;
            if (this.landscape && (e.detail == 16 || e.detail == 8)) {
                this.calendareditdayview.activate();
            }
        }
    }

    public void activateMonthView() {
        this.calendarmonthview.activate();
    }

    public CalendarDayViewScreen getDayViewScreen() {
        return this.calendarDayViewScreen;
    }
}

