/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.io;

import java.io.IOException;
import org.eclipse.ercp.xml.io.SimpleBufferedInputStream;
import org.eclipse.ercp.xml.io.StreamDecoder;
import org.eclipse.ercp.xml.parser.EXmlMsg;

public class StreamDecoder_UTF8
extends StreamDecoder {
    byte lastByte2;
    byte lastByte3;
    boolean readOneMoreChar = false;

    public StreamDecoder_UTF8(SimpleBufferedInputStream stream) {
        super(stream, "UTF-8");
    }

    public int read() throws IOException {
        if (this.readOneMoreChar) {
            int temp = ((this.lastByte2 & 0xF) << 6) + (this.lastByte3 & 0x3F) + 56320;
            this.readOneMoreChar = false;
            return temp;
        }
        byte b0 = (byte)this.stream.read();
        if (b0 == -1) {
            return -1;
        }
        if (b0 >= 0) {
            return (char)b0;
        }
        byte b1 = (byte)this.stream.read();
        if (b1 == -1) {
            throw new IOException(EXmlMsg.getDefault().getString(47, Integer.toHexString(b0)));
        }
        if ((b0 & 0xE0) == 192) {
            return ((b0 & 0x1F) << 6) + (b1 & 0x3F);
        }
        byte b2 = (byte)this.stream.read();
        if (b2 == -1) {
            throw new IOException(EXmlMsg.getDefault().getString(48, new String[]{Integer.toHexString(b0), Integer.toHexString(b1)}));
        }
        if ((b0 & 0xF0) == 224) {
            return ((b0 & 0xF) << 12) + ((b1 & 0x3F) << 6) + (b2 & 0x3F);
        }
        byte b3 = (byte)this.stream.read();
        if (b2 == -1) {
            throw new IOException(EXmlMsg.getDefault().getString(49, new String[]{Integer.toHexString(b0), Integer.toHexString(b1), Integer.toHexString(b2)}));
        }
        this.lastByte2 = b2;
        this.lastByte3 = b3;
        this.readOneMoreChar = true;
        return (((b0 & 7) << 2) + (b1 >> 4 & 3) - 1 << 6) + ((b1 & 0xF) << 2) + (b2 >> 4 & 3) + 55296;
    }

    public int read(char[] buf, int offset, int count) throws IOException {
        byte[] buffer;
        if (count <= 0) {
            return count;
        }
        int end = offset + count;
        int charOffset = offset;
        if (this.readOneMoreChar) {
            buf[charOffset++] = (char)(((this.lastByte2 & 0xF) << 6) + (this.lastByte3 & 0x3F) + 56320);
            this.readOneMoreChar = false;
        }
        if (-1 == this.stream.read(buffer = new byte[end - charOffset])) {
            return charOffset - offset == 0 ? -1 : charOffset - offset;
        }
        int index = 0;
        int missingBytes = 0;
        while (charOffset < end) {
            byte b0;
            if ((b0 = buffer[index++]) >= 0) {
                buf[charOffset++] = (char)b0;
                continue;
            }
            if (index == buffer.length) {
                buffer = new byte[missingBytes];
                index = 0;
                missingBytes = 0;
                if (-1 == this.stream.read(buffer)) {
                    throw new IOException(EXmlMsg.getDefault().getString(47, Integer.toHexString(b0)));
                }
            }
            byte b1 = buffer[index++];
            ++missingBytes;
            if ((b0 & 0xE0) == 192) {
                buf[charOffset++] = (char)(((b0 & 0x1F) << 6) + (b1 & 0x3F));
                continue;
            }
            if (index == buffer.length) {
                buffer = new byte[missingBytes];
                index = 0;
                missingBytes = 0;
                if (-1 == this.stream.read(buffer)) {
                    throw new IOException(EXmlMsg.getDefault().getString(48, new String[]{Integer.toHexString(b0), Integer.toHexString(b1)}));
                }
            }
            byte b2 = buffer[index++];
            ++missingBytes;
            if ((b0 & 0xF0) == 224) {
                buf[charOffset++] = (char)(((b0 & 0xF) << 12) + ((b1 & 0x3F) << 6) + (b2 & 0x3F));
                continue;
            }
            if (index == buffer.length) {
                buffer = new byte[missingBytes];
                index = 0;
                missingBytes = 0;
                if (-1 == this.stream.read(buffer)) {
                    throw new IOException(EXmlMsg.getDefault().getString(49, new String[]{Integer.toHexString(b0), Integer.toHexString(b1), Integer.toHexString(b2)}));
                }
            }
            byte b3 = buffer[index++];
            ++missingBytes;
            buf[charOffset++] = (char)((((b0 & 7) << 2) + (b1 >> 4 & 3) - 1 << 6) + ((b1 & 0xF) << 2) + (b2 >> 4 & 3) + 55296);
            if (charOffset < end) {
                buf[charOffset++] = (char)(((b2 & 0xF) << 6) + (b3 & 0x3F) + 56320);
                continue;
            }
            this.lastByte2 = b2;
            this.lastByte3 = b3;
            this.readOneMoreChar = true;
        }
        return count;
    }

    public void restore() {
        if (this.readOneMoreChar) {
            this.stream.unread(new byte[]{this.lastByte2, this.lastByte3}, 2);
            this.readOneMoreChar = false;
        }
    }
}

