/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.parser;

import org.eclipse.ercp.xml.parser.NSDeclaration;
import org.xml.sax.Attributes;

public class AttributesImpl
implements Attributes {
    int elementCount;
    Attribute[] attributes;
    int capacityIncrement;
    public static final String CDATA = "CDATA";
    public static final AttributesImpl EmptyList = new AttributesImpl(0);

    public AttributesImpl() {
        this(20);
    }

    AttributesImpl(int capacityIncrement) {
        this.capacityIncrement = capacityIncrement;
        this.elementCount = 0;
        this.attributes = null;
    }

    public int getLength() {
        return this.elementCount;
    }

    public String getURI(int index) {
        Attribute att;
        block3: {
            try {
                att = this.attributes[index];
                if (att.nsDeclaration != null) break block3;
                return "";
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }
        return att.nsDeclaration.getUriOnAttributeFor(att.prefix);
    }

    public String getLocalName(int index) {
        try {
            return this.attributes[index].localName;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public String getQName(int index) {
        try {
            return this.attributes[index].qName;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public String getType(int index) {
        try {
            return this.attributes[index].type;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public String getValue(int index) {
        try {
            return this.attributes[index].value;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public int getIndex(String uri, String localPart) {
        try {
            int i = 0;
            while (i < this.elementCount) {
                Attribute att = this.attributes[i];
                if (att.getUri().equals(uri) && att.localName.equals(localPart)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        catch (NullPointerException nullPointerException) {
            return -1;
        }
    }

    public int getIndex(String qName) {
        int i = 0;
        while (i < this.elementCount) {
            if (this.attributes[i].localName.equals(qName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getType(String uri, String localName) {
        try {
            int i = 0;
            while (i < this.elementCount) {
                Attribute att = this.attributes[i];
                if (att.getUri().equals(uri) && att.localName.equals(localName)) {
                    return att.type;
                }
                ++i;
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getType(String qName) {
        try {
            int i = 0;
            while (i < this.elementCount) {
                Attribute att = this.attributes[i];
                if (att.localName.equals(qName)) {
                    return att.type;
                }
                ++i;
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getValue(String uri, String localName) {
        try {
            int i = 0;
            while (i < this.elementCount) {
                Attribute att = this.attributes[i];
                if (att.getUri().equals(uri) && att.localName.equals(localName)) {
                    return att.value;
                }
                ++i;
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getValue(String qName) {
        try {
            int i = 0;
            while (i < this.elementCount) {
                Attribute att = this.attributes[i];
                if (att.localName.equals(qName)) {
                    return att.value;
                }
                ++i;
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public void addAttribute(NSDeclaration nsDeclaration, String prefix, String qName, String localName, String type, String value) {
        if (this.elementCount == 0 || this.elementCount == this.attributes.length) {
            this.grow();
        }
        this.attributes[this.elementCount++] = new Attribute(nsDeclaration, prefix, qName, localName, type, value);
    }

    private void grow() {
        Attribute[] newAtts = new Attribute[this.elementCount + this.capacityIncrement];
        if (this.attributes != null) {
            System.arraycopy(this.attributes, 0, newAtts, 0, this.elementCount);
        }
        this.attributes = newAtts;
    }

    class Attribute {
        NSDeclaration nsDeclaration;
        String prefix;
        String qName;
        String localName;
        String type;
        String value;
        private String uri;

        Attribute(NSDeclaration nsDeclaration, String prefix, String qName, String localName, String type, String value) {
            this.nsDeclaration = nsDeclaration;
            this.prefix = prefix;
            this.qName = qName;
            this.localName = localName;
            this.type = type;
            this.value = value;
            this.uri = null;
        }

        final String getUri() {
            if (this.uri != null) {
                return this.uri;
            }
            this.uri = this.nsDeclaration == null ? "" : this.nsDeclaration.getUriOnAttributeFor(this.prefix);
            return this.uri;
        }
    }
}

