/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.parser;

public class NSDeclaration {
    String tagNameOwnerPrefix;
    String tagNameOwner;
    NSDeclaration parent;
    String[][] declarations;
    String defaultNS;
    int elementCount;
    static int CapacityIncrement = 5;

    NSDeclaration() {
        this.tagNameOwnerPrefix = null;
        this.tagNameOwner = null;
        this.parent = null;
        this.defaultNS = "";
        this.elementCount = 1;
        this.declarations = new String[][]{{"xml", "http://www.w3.org/XML/1998/namespace"}};
    }

    NSDeclaration(String tagName, NSDeclaration parent) {
        this(null, tagName, parent);
    }

    NSDeclaration(String prefix, String tagName, NSDeclaration parent) {
        this.tagNameOwnerPrefix = prefix;
        this.tagNameOwner = tagName;
        this.parent = parent;
        this.elementCount = 0;
        this.declarations = null;
        this.defaultNS = null;
    }

    public void addDeclaration(String prefix, String uri) {
        if (prefix.length() == 0) {
            this.defaultNS = uri;
        }
        if (this.declarations == null || this.elementCount == this.declarations.length) {
            this.grow();
        }
        this.declarations[this.elementCount++] = new String[]{prefix, uri};
    }

    private void grow() {
        String[][] newDecl = new String[this.elementCount + CapacityIncrement][2];
        if (this.declarations != null) {
            System.arraycopy(this.declarations, 0, newDecl, 0, this.elementCount);
        }
        this.declarations = newDecl;
    }

    public String[][] getDeclarations() {
        if (this.declarations == null) {
            return null;
        }
        String[][] res = new String[this.elementCount][2];
        System.arraycopy(this.declarations, 0, res, 0, this.elementCount);
        return res;
    }

    public String getUriFor(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return this.getDefaultNS();
        }
        return this.primGetUriFor(prefix);
    }

    public String getUriOnAttributeFor(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return "";
        }
        return this.primGetUriFor(prefix);
    }

    String getDefaultNS() {
        if (this.defaultNS != null) {
            return this.defaultNS;
        }
        if (this.parent != null) {
            return this.parent.getDefaultNS();
        }
        return "";
    }

    private String primGetUriFor(String prefix) {
        if (this.declarations != null) {
            int i = 0;
            while (i < this.elementCount) {
                if (prefix.equals(this.declarations[i][0])) {
                    return this.declarations[i][1];
                }
                ++i;
            }
        }
        if (this.parent != null) {
            return this.parent.primGetUriFor(prefix);
        }
        return "";
    }

    public boolean isNamed(String namespace, String tagname) {
        if (namespace == null) {
            return this.tagNameOwnerPrefix == null && tagname.equals(this.tagNameOwner);
        }
        return namespace.equals(this.tagNameOwnerPrefix) && tagname.equals(this.tagNameOwner);
    }
}

