/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.ContainerPlaceholder;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewSashContainer;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.misc.StringMatcher;

public class PerspectiveHelper {
    private WorkbenchPage page;
    private Composite parentWidget;
    private ViewSashContainer mainLayout;
    private ArrayList detachedWindowList = new ArrayList(1);
    private ArrayList detachedPlaceHolderList = new ArrayList(1);
    private boolean detachable = false;
    private boolean active = false;
    private static final int MIN_DETACH_WIDTH = 150;
    private static final int MIN_DETACH_HEIGHT = 250;
    private Perspective perspective;

    public PerspectiveHelper(WorkbenchPage workbenchPage, ViewSashContainer mainLayout, Perspective perspective) {
        this.page = workbenchPage;
        this.mainLayout = mainLayout;
        this.perspective = perspective;
        this.detachable = false;
        Composite client = workbenchPage.getClientComposite();
        if (client != null) {
            Composite testChild = new Composite(client, 0);
            this.detachable = testChild.isReparentable();
            testChild.dispose();
        }
    }

    public void activate(Composite parent) {
        if (this.active) {
            return;
        }
        this.parentWidget = parent;
        Vector children = new Vector();
        this.collectViewPanes(children, this.mainLayout.getChildren());
        Enumeration itr = children.elements();
        while (itr.hasMoreElements()) {
            LayoutPart part = (LayoutPart)itr.nextElement();
            part.reparent(parent);
        }
        this.mainLayout.createControl(parent);
        this.active = true;
    }

    public void addPart(LayoutPart part) {
        LayoutPart placeholder = null;
        LayoutPart testPart = null;
        String primaryId = part.getID();
        String secondaryId = null;
        if (part instanceof ViewPane) {
            ViewPane pane = (ViewPane)part;
            IViewReference ref = (IViewReference)pane.getPartReference();
            secondaryId = ref.getSecondaryId();
        }
        if ((testPart = secondaryId != null ? this.findPart(primaryId, secondaryId) : this.findPart(primaryId)) != null && testPart instanceof PartPlaceholder) {
            placeholder = (PartPlaceholder)testPart;
        }
        if (placeholder == null) {
            part.reparent(this.mainLayout.getParent());
            LayoutPart relative = this.mainLayout.findBottomRight();
            if (relative != null && relative instanceof ILayoutContainer) {
                ILayoutContainer stack = (ILayoutContainer)((Object)relative);
                if (stack.allowsAdd(part)) {
                    this.mainLayout.stack(part, stack);
                } else {
                    this.mainLayout.add(part);
                }
            } else {
                this.mainLayout.add(part);
            }
        } else {
            ILayoutContainer container = placeholder.getContainer();
            if (container != null) {
                if (container instanceof ContainerPlaceholder) {
                    ContainerPlaceholder containerPlaceholder = (ContainerPlaceholder)container;
                    ILayoutContainer parentContainer = containerPlaceholder.getContainer();
                    container = (ILayoutContainer)((Object)containerPlaceholder.getRealContainer());
                    if (container instanceof LayoutPart) {
                        parentContainer.replace(containerPlaceholder, (LayoutPart)((Object)container));
                    }
                    containerPlaceholder.setRealContainer(null);
                }
                if (!(container instanceof ViewStack)) {
                    part.reparent(this.mainLayout.getParent());
                }
                if (((PartPlaceholder)placeholder).hasWildCard()) {
                    container.add(part);
                } else {
                    container.replace(placeholder, part);
                }
            }
        }
    }

    public void attachPart(IViewReference ref) {
        ViewPane pane = (ViewPane)((WorkbenchPartReference)((Object)ref)).getPane();
        this.derefPart(pane);
        this.addPart(pane);
        this.bringPartToTop(pane);
        pane.setFocus();
    }

    public boolean canDetach() {
        return this.detachable;
    }

    public boolean bringPartToTop(LayoutPart part) {
        PartStack folder;
        ILayoutContainer container = part.getContainer();
        if (container != null && container instanceof PartStack && (folder = (PartStack)container).getVisiblePart() != part) {
            folder.setSelection(part);
            return true;
        }
        return false;
    }

    public boolean isPartVisible(IWorkbenchPartReference partRef) {
        LayoutPart foundPart = partRef instanceof IViewReference ? this.findPart(partRef.getId(), ((IViewReference)partRef).getSecondaryId()) : this.findPart(partRef.getId());
        if (foundPart == null) {
            return false;
        }
        if (foundPart instanceof PartPlaceholder) {
            return false;
        }
        ILayoutContainer container = foundPart.getContainer();
        if (container instanceof ContainerPlaceholder) {
            return false;
        }
        if (container instanceof ViewStack) {
            ViewStack folder = (ViewStack)container;
            PartPane visiblePart = folder.getVisiblePart();
            if (visiblePart == null) {
                return false;
            }
            return partRef.equals(visiblePart.getPartReference());
        }
        return true;
    }

    public boolean willPartBeVisible(String partId) {
        return this.willPartBeVisible(partId, null);
    }

    public boolean willPartBeVisible(String partId, String secondaryId) {
        LayoutPart part = this.findPart(partId, secondaryId);
        if (part == null) {
            return false;
        }
        ILayoutContainer container = part.getContainer();
        if (container != null && container instanceof ContainerPlaceholder) {
            container = (ILayoutContainer)((Object)((ContainerPlaceholder)container).getRealContainer());
        }
        if (container != null && container instanceof ViewStack) {
            ViewStack folder = (ViewStack)container;
            if (folder.getVisiblePart() == null) {
                return false;
            }
            return part.getCompoundId().equals(folder.getVisiblePart().getCompoundId());
        }
        return true;
    }

    private PartPlaceholder[] collectPlaceholders() {
        PartPlaceholder[] results = this.collectPlaceholders(this.mainLayout.getChildren());
        return results;
    }

    private PartPlaceholder[] collectPlaceholders(LayoutPart[] parts) {
        PartPlaceholder[] result = new PartPlaceholder[]{};
        int i = 0;
        int length = parts.length;
        while (i < length) {
            LayoutPart part = parts[i];
            if (part instanceof ILayoutContainer) {
                PartPlaceholder[] newParts = this.collectPlaceholders(((ILayoutContainer)((Object)part)).getChildren());
                PartPlaceholder[] newResult = new PartPlaceholder[result.length + newParts.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(newParts, 0, newResult, result.length, newParts.length);
                result = newResult;
            } else if (part instanceof PartPlaceholder) {
                PartPlaceholder[] newResult = new PartPlaceholder[result.length + 1];
                System.arraycopy(result, 0, newResult, 0, result.length);
                newResult[result.length] = (PartPlaceholder)part;
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    public void collectViewPanes(List result) {
        this.collectViewPanes(result, this.mainLayout.getChildren());
    }

    private void collectViewPanes(List result, LayoutPart[] parts) {
        int i = 0;
        int length = parts.length;
        while (i < length) {
            LayoutPart part = parts[i];
            if (part instanceof ViewPane) {
                result.add(part);
            } else if (part instanceof ILayoutContainer) {
                this.collectViewPanes(result, ((ILayoutContainer)((Object)part)).getChildren());
            }
            ++i;
        }
    }

    public void deactivate() {
        if (!this.active) {
            return;
        }
        this.disableAllDrag();
        Composite parent = this.mainLayout.getParent();
        Vector children = new Vector();
        this.collectViewPanes(children, this.mainLayout.getChildren());
        Enumeration itr = children.elements();
        while (itr.hasMoreElements()) {
            LayoutPart part = (LayoutPart)itr.nextElement();
            part.reparent(parent);
        }
        this.mainLayout.dispose();
        this.active = false;
    }

    public void describeLayout(StringBuffer buf) {
        if (this.detachable && this.detachedWindowList.size() != 0) {
            buf.append("detachedWindows (");
        }
        this.getLayout().describeLayout(buf);
    }

    void derefPart(LayoutPart part) {
        if (part instanceof ViewPane) {
            this.page.removeFastView(((ViewPane)part).getViewReference());
        }
        boolean wasDocked = part.isDocked();
        part.getShell();
        ILayoutContainer oldContainer = part.getContainer();
        part.reparent(this.mainLayout.getParent());
        if (oldContainer == null) {
            return;
        }
        oldContainer.remove(part);
        LayoutPart[] children = oldContainer.getChildren();
        if (wasDocked) {
            LayoutPart parent;
            ILayoutContainer parentContainer;
            boolean hasChildren;
            boolean bl = hasChildren = children != null && children.length > 0;
            if (hasChildren) {
                int childVisible = 0;
                int i = 0;
                while (i < children.length) {
                    if (children[i].getControl() != null) {
                        ++childVisible;
                    }
                    ++i;
                }
                if (oldContainer instanceof ViewStack) {
                    ViewStack folder = (ViewStack)oldContainer;
                    if (childVisible == 0) {
                        ILayoutContainer parentContainer2 = folder.getContainer();
                        int i2 = 0;
                        while (i2 < children.length) {
                            folder.remove(children[i2]);
                            parentContainer2.add(children[i2]);
                            ++i2;
                        }
                        hasChildren = false;
                    }
                }
            }
            if (!hasChildren && oldContainer instanceof LayoutPart && (parentContainer = (parent = (LayoutPart)((Object)oldContainer)).getContainer()) != null) {
                parentContainer.remove(parent);
                parent.dispose();
            }
        } else if (!wasDocked && children != null && children.length != 0) {
            boolean allInvisible = true;
            int i = 0;
            int length = children.length;
            while (i < length) {
                if (!(children[i] instanceof PartPlaceholder)) {
                    allInvisible = false;
                    break;
                }
                ++i;
            }
        }
    }

    private void detach(LayoutPart source, int x, int y) {
    }

    public void detachPart(IViewReference ref) {
        ViewPane pane = (ViewPane)((WorkbenchPartReference)((Object)ref)).getPane();
        if (this.canDetach() && pane != null) {
            Rectangle bounds = pane.getParentBounds();
            this.detach(pane, bounds.x, bounds.y);
        }
    }

    public void addDetachedPart(LayoutPart part) {
        Rectangle bounds = this.parentWidget.getShell().getBounds();
        bounds.x += (bounds.width - 300) / 2;
        bounds.y += (bounds.height - 300) / 2;
        this.addDetachedPart(part, bounds);
    }

    public void addDetachedPart(LayoutPart part, Rectangle bounds) {
        if (!this.detachable) {
            this.addPart(part);
            return;
        }
    }

    private void disableAllDrag() {
    }

    private void enableAllDrag() {
    }

    private LayoutPart findPart(String id) {
        return this.findPart(id, null);
    }

    private LayoutPart findPart(String primaryId, String secondaryId) {
        LayoutPart part;
        ArrayList matchingParts = new ArrayList();
        LayoutPart layoutPart = part = secondaryId != null ? this.findPart(primaryId, secondaryId, this.mainLayout.getChildren(), matchingParts) : this.findPart(primaryId, this.mainLayout.getChildren(), matchingParts);
        if (part != null) {
            return part;
        }
        if (matchingParts.size() > 0) {
            Collections.sort(matchingParts);
            MatchingPart mostSignificantPart = (MatchingPart)matchingParts.get(0);
            if (mostSignificantPart != null) {
                return mostSignificantPart.part;
            }
        }
        return null;
    }

    private LayoutPart findPart(String id, LayoutPart[] parts, ArrayList matchingParts) {
        int i = 0;
        int length = parts.length;
        while (i < length) {
            LayoutPart part = parts[i];
            if (part.getID().equals(id)) {
                ViewPane pane;
                IViewReference ref;
                if (!(part instanceof ViewPane) || (ref = (IViewReference)(pane = (ViewPane)part).getPartReference()).getSecondaryId() == null) {
                    return part;
                }
            } else if (part instanceof PartPlaceholder && ((PartPlaceholder)part).hasWildCard()) {
                StringMatcher sm = new StringMatcher(part.getID(), true, false);
                if (sm.match(id)) {
                    matchingParts.add(new MatchingPart(part.getID(), null, part));
                }
            } else if (part instanceof ILayoutContainer && (part = this.findPart(id, ((ILayoutContainer)((Object)part)).getChildren(), matchingParts)) != null) {
                return part;
            }
            ++i;
        }
        return null;
    }

    private LayoutPart findPart(String primaryId, String secondaryId, LayoutPart[] parts, ArrayList matchingParts) {
        int i = 0;
        int length = parts.length;
        while (i < length) {
            LayoutPart testPart;
            LayoutPart part = parts[i];
            if (part instanceof ILayoutContainer && (testPart = this.findPart(primaryId, secondaryId, ((ILayoutContainer)((Object)part)).getChildren(), matchingParts)) != null) {
                return testPart;
            }
            if (part instanceof ViewPane) {
                ViewPane pane = (ViewPane)part;
                IViewReference ref = (IViewReference)pane.getPartReference();
                if (ref.getId().equals(primaryId) && ref.getSecondaryId() != null && ref.getSecondaryId().equals(secondaryId)) {
                    return part;
                }
            } else if (parts[i] instanceof PartPlaceholder) {
                String id = part.getID();
                String phSecondaryId = ViewFactory.extractSecondaryId(id);
                if (phSecondaryId == null) {
                    if (id.equals(PartPlaceholder.WILD_CARD)) {
                        matchingParts.add(new MatchingPart(id, null, part));
                    }
                } else {
                    String phPrimaryId = ViewFactory.extractPrimaryId(id);
                    if (phPrimaryId.equals(primaryId) && phSecondaryId.equals(secondaryId)) {
                        return part;
                    }
                    StringMatcher sm = new StringMatcher(phPrimaryId, true, false);
                    if (sm.match(primaryId) && (sm = new StringMatcher(phSecondaryId, true, false)).match(secondaryId)) {
                        matchingParts.add(new MatchingPart(phPrimaryId, phSecondaryId, part));
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public boolean hasPlaceholder(String id) {
        return this.hasPlaceholder(id, null);
    }

    public boolean hasPlaceholder(String primaryId, String secondaryId) {
        LayoutPart testPart = secondaryId == null ? this.findPart(primaryId) : this.findPart(primaryId, secondaryId);
        return testPart != null && testPart instanceof PartPlaceholder;
    }

    public ViewSashContainer getLayout() {
        return this.mainLayout;
    }

    public boolean isActive() {
        return this.active;
    }

    private boolean isFastView(IWorkbenchPartReference ref) {
        if (ref instanceof IViewReference) {
            WorkbenchPage page = (WorkbenchPage)ref.getPage();
            return page.isFastView((IViewReference)ref);
        }
        return false;
    }

    public boolean isZoomed() {
        return false;
    }

    public static float getDockingRatio(LayoutPart source, LayoutPart target) {
        return 0.5f;
    }

    public boolean partChangeAffectsZoom(LayoutPart pane) {
        return pane.isObscuredByZoom();
    }

    public void removePart(LayoutPart part) {
        Composite parent = this.mainLayout.getParent();
        part.reparent(parent);
        ILayoutContainer container = part.getContainer();
        if (container != null) {
            String placeHolderId = part.getPlaceHolderId();
            container.replace(part, new PartPlaceholder(placeHolderId));
            if (container == this.mainLayout) {
                return;
            }
            LayoutPart[] children = container.getChildren();
            if (children != null) {
                int i = 0;
                int length = children.length;
                while (i < length) {
                    if (!(children[i] instanceof PartPlaceholder)) break;
                    ++i;
                }
            }
        }
    }

    public void replacePlaceholderWithPart(LayoutPart part) {
        PartPlaceholder[] placeholders = this.collectPlaceholders();
        int i = 0;
        int length = placeholders.length;
        while (i < length) {
            ILayoutContainer container;
            if (placeholders[i].getCompoundId().equals(part.getCompoundId()) && (container = placeholders[i].getContainer()) != null) {
                if (container instanceof ContainerPlaceholder) {
                    ContainerPlaceholder containerPlaceholder = (ContainerPlaceholder)container;
                    ILayoutContainer parentContainer = containerPlaceholder.getContainer();
                    container = (ILayoutContainer)((Object)containerPlaceholder.getRealContainer());
                    if (container instanceof LayoutPart) {
                        parentContainer.replace(containerPlaceholder, (LayoutPart)((Object)container));
                    }
                    containerPlaceholder.setRealContainer(null);
                }
                container.replace(placeholders[i], part);
                return;
            }
            ++i;
        }
    }

    public IStatus restoreState(IMemento memento) {
        IMemento childMem = memento.getChild("mainWindow");
        IStatus r = this.mainLayout.restoreState(childMem);
        return r;
    }

    public IStatus saveState(IMemento memento) {
        IMemento childMem = memento.createChild("mainWindow");
        IStatus r = this.mainLayout.saveState(childMem);
        return r;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void zoomIn(IWorkbenchPartReference ref) {
        PartPane pane = ((WorkbenchPartReference)ref).getPane();
        this.parentWidget.setRedraw(false);
        try {
            pane.requestZoomIn();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.parentWidget.setRedraw(true);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.parentWidget.setRedraw(true);
    }

    public void zoomOut() {
        LayoutPart zoomPart = this.mainLayout.getZoomedPart();
        if (zoomPart != null) {
            zoomPart.requestZoomOut();
        }
    }

    private class MatchingPart
    implements Comparable {
        String pid;
        String sid;
        LayoutPart part;
        boolean hasWildcard;
        int len;

        MatchingPart(String pid, String sid, LayoutPart part) {
            this.pid = pid;
            this.sid = sid;
            this.part = part;
            this.len = (pid == null ? 0 : pid.length()) + (sid == null ? 0 : sid.length());
            this.hasWildcard = pid != null && pid.indexOf(PartPlaceholder.WILD_CARD) != -1 || sid != null && sid.indexOf(PartPlaceholder.WILD_CARD) != -1;
        }

        public int compareTo(Object a) {
            MatchingPart ma = (MatchingPart)a;
            if (this.hasWildcard && !ma.hasWildcard) {
                return -1;
            }
            if (!this.hasWildcard && ma.hasWildcard) {
                return 1;
            }
            return ma.len - this.len;
        }
    }
}

