/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dnd;

import org.eclipse.swt.widgets.Control;

public class SwtUtil {
    private SwtUtil() {
    }

    public static boolean isDisposed(Control toTest) {
        return toTest == null || toTest.isDisposed();
    }

    public static boolean isChild(Control potentialParent, Control childToTest) {
        if (childToTest == null) {
            return false;
        }
        if (childToTest == potentialParent) {
            return true;
        }
        return SwtUtil.isChild(potentialParent, (Control)childToTest.getParent());
    }

    public static Control[] getAncestors(Control theControl) {
        return SwtUtil.getAncestors(theControl, 1);
    }

    private static Control[] getAncestors(Control theControl, int children) {
        Control[] result = theControl.getParent() == null ? new Control[children] : SwtUtil.getAncestors((Control)theControl.getParent(), children + 1);
        result[result.length - children] = theControl;
        return result;
    }

    public static Control findCommonAncestor(Control control1, Control control2) {
        Control[] control1Ancestors = SwtUtil.getAncestors(control1);
        Control[] control2Ancestors = SwtUtil.getAncestors(control2);
        Control mostSpecific = null;
        int idx = 0;
        while (idx < Math.min(control1Ancestors.length, control2Ancestors.length)) {
            Control control1Ancestor = control1Ancestors[idx];
            if (control1Ancestor != control2Ancestors[idx]) break;
            mostSpecific = control1Ancestor;
            ++idx;
        }
        return mostSpecific;
    }
}

