/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.commands.Parameter;

final class CommandPersistence {
    private static final String ATTRIBUTE_CATEGORY = "category";
    private static final String ATTRIBUTE_CATEGORY_ID = "categoryId";
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_OPTIONAL = "optional";
    private static final String ELEMENT_ACTION_DEFINITION = "actionDefinition";
    private static final String ELEMENT_CATEGORY = "category";
    private static final String ELEMENT_COMMAND = "command";
    private static final String ELEMENT_COMMAND_PARAMETER = "commandParameter";
    private static final String EXTENSION_ACTION_DEFINITIONS = "org.eclipse.ui.actionDefinitions";
    private static final String EXTENSION_COMMANDS = "org.eclipse.ui.commands";
    private static final int INDEX_CATEGORY_DEFINITIONS = 0;
    private static final int INDEX_COMMAND_DEFINITIONS = 1;

    private static final void addElementToIndexedArray(IConfigurationElement iConfigurationElement, IConfigurationElement[][] iConfigurationElementArray, int n, int n2) {
        IConfigurationElement[] iConfigurationElementArray2;
        if (n2 == 0) {
            iConfigurationElementArray2 = new IConfigurationElement[1];
            iConfigurationElementArray[n] = iConfigurationElementArray2;
        } else if (n2 >= iConfigurationElementArray[n].length) {
            IConfigurationElement[] iConfigurationElementArray3 = new IConfigurationElement[iConfigurationElementArray[n].length * 2];
            System.arraycopy(iConfigurationElementArray[n], 0, iConfigurationElementArray3, 0, n2);
            iConfigurationElementArray2 = iConfigurationElementArray3;
            iConfigurationElementArray[n] = iConfigurationElementArray2;
        } else {
            iConfigurationElementArray2 = iConfigurationElementArray[n];
        }
        iConfigurationElementArray2[n2] = iConfigurationElement;
    }

    static final void read(CommandManager commandManager) {
        String string;
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        int n = 0;
        int n2 = 0;
        IConfigurationElement[][] iConfigurationElementArray = new IConfigurationElement[2][];
        IConfigurationElement[] iConfigurationElementArray2 = iExtensionRegistry.getConfigurationElementsFor(EXTENSION_COMMANDS);
        int n3 = 0;
        while (n3 < iConfigurationElementArray2.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n3];
            string = iConfigurationElement.getName();
            if (ELEMENT_COMMAND.equals(string)) {
                CommandPersistence.addElementToIndexedArray(iConfigurationElement, iConfigurationElementArray, 1, n++);
            } else if ("category".equals(string)) {
                CommandPersistence.addElementToIndexedArray(iConfigurationElement, iConfigurationElementArray, 0, n2++);
            }
            ++n3;
        }
        IConfigurationElement[] iConfigurationElementArray3 = iExtensionRegistry.getConfigurationElementsFor(EXTENSION_ACTION_DEFINITIONS);
        int n4 = 0;
        while (n4 < iConfigurationElementArray3.length) {
            string = iConfigurationElementArray3[n4];
            String string2 = string.getName();
            if (ELEMENT_ACTION_DEFINITION.equals(string2)) {
                CommandPersistence.addElementToIndexedArray((IConfigurationElement)string, iConfigurationElementArray, 1, n++);
            }
            ++n4;
        }
        CommandPersistence.readCategoriesFromCommandsExtensionPoint(iConfigurationElementArray[0], n2, commandManager);
        CommandPersistence.readCommandsFromCommandsExtensionPoint(iConfigurationElementArray[1], n, commandManager);
    }

    private static final void readCategoriesFromCommandsExtensionPoint(IConfigurationElement[] iConfigurationElementArray, int n, CommandManager commandManager) {
        ArrayList<String> arrayList = null;
        int n2 = 0;
        while (n2 < n) {
            String string;
            String string2;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String string3 = iConfigurationElement.getAttribute(ATTRIBUTE_ID);
            if (string3 == null || string3.length() == 0) {
                string2 = "Categories need an id: '" + iConfigurationElement.getNamespace() + "'.";
                string = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, string2, null);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(string);
            } else {
                Category category;
                string2 = iConfigurationElement.getAttribute(ATTRIBUTE_NAME);
                if (string2 == null || string2.length() == 0) {
                    string = "Categories need a name: '" + iConfigurationElement.getNamespace() + "', '" + string3 + "'.";
                    category = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, string, null);
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                    }
                    arrayList.add((String)category);
                } else {
                    string = iConfigurationElement.getAttribute(ATTRIBUTE_DESCRIPTION);
                    if (string != null && string.length() == 0) {
                        string = null;
                    }
                    category = commandManager.getCategory(string3);
                    category.define(string2, string);
                }
            }
            ++n2;
        }
        if (arrayList != null) {
            MultiStatus multiStatus = new MultiStatus(WorkbenchPlugin.PI_WORKBENCH, 0, arrayList.toArray(new IStatus[arrayList.size()]), "Warnings while parsing the commands from the 'org.eclipse.ui.commands' and 'org.eclipse.ui.actionDefinitions' extension points.", null);
            WorkbenchPlugin.log("Warnings while parsing the commands from the 'org.eclipse.ui.commands' and 'org.eclipse.ui.actionDefinitions' extension points.", (IStatus)multiStatus);
        }
    }

    private static final void readCommandsFromCommandsExtensionPoint(IConfigurationElement[] iConfigurationElementArray, int n, CommandManager commandManager) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        int n2 = 0;
        while (n2 < n) {
            String string;
            String string2;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String string3 = iConfigurationElement.getAttribute(ATTRIBUTE_ID);
            if (string3 == null || string3.length() == 0) {
                string2 = "Commands need an id: '" + iConfigurationElement.getNamespace() + "'.";
                string = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, string2, null);
                arrayList.add(string);
            } else {
                String string4;
                string2 = iConfigurationElement.getAttribute(ATTRIBUTE_NAME);
                if (string2 == null || string2.length() == 0) {
                    string = "Commands need a name: '" + iConfigurationElement.getNamespace() + "', '" + string3 + "'.";
                    string4 = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, string, null);
                    arrayList.add(string4);
                } else {
                    string = iConfigurationElement.getAttribute(ATTRIBUTE_DESCRIPTION);
                    if (string != null && string.length() == 0) {
                        string = null;
                    }
                    if (((string4 = iConfigurationElement.getAttribute(ATTRIBUTE_CATEGORY_ID)) == null || string4.length() == 0) && (string4 = iConfigurationElement.getAttribute("category")) == null) {
                        string4 = "";
                    }
                    IParameter[] iParameterArray = CommandPersistence.readParameters(iConfigurationElement, arrayList);
                    Command command = commandManager.getCommand(string3);
                    Category category = commandManager.getCategory(string4);
                    if (!category.isDefined()) {
                        String string5 = "Commands should really have a category, not '" + string4 + "': '" + iConfigurationElement.getNamespace() + "', '" + string3 + "'.";
                        Status status = new Status(1, WorkbenchPlugin.PI_WORKBENCH, 0, string5, null);
                        arrayList.add((String)status);
                    }
                    command.define(string2, string, category, iParameterArray);
                }
            }
            ++n2;
        }
        if (!arrayList.isEmpty()) {
            MultiStatus multiStatus = new MultiStatus(WorkbenchPlugin.PI_WORKBENCH, 0, arrayList.toArray(new IStatus[arrayList.size()]), "Warnings while parsing the commands from the 'org.eclipse.ui.commands' and 'org.eclipse.ui.actionDefinitions' extension points.", null);
            WorkbenchPlugin.log("Warnings while parsing the commands from the 'org.eclipse.ui.commands' and 'org.eclipse.ui.actionDefinitions' extension points.", (IStatus)multiStatus);
        }
    }

    private static final Parameter[] readParameters(IConfigurationElement iConfigurationElement, List list) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren(ELEMENT_COMMAND_PARAMETER);
        if (iConfigurationElementArray == null || iConfigurationElementArray.length == 0) {
            return null;
        }
        int n = 0;
        Parameter[] parameterArray = new Parameter[iConfigurationElementArray.length];
        int n2 = 0;
        while (n2 < iConfigurationElementArray.length) {
            String string;
            String string2;
            IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[n2];
            String string3 = iConfigurationElement2.getAttribute(ATTRIBUTE_ID);
            if (string3 == null || string3.length() == 0) {
                string2 = "Parameters need an id: '" + iConfigurationElement.getNamespace() + "'.";
                string = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, string2, null);
                list.add(string);
            } else {
                string2 = iConfigurationElement2.getAttribute(ATTRIBUTE_NAME);
                if (string2 == null || string2.length() == 0) {
                    string = "Parameters need a name: '" + iConfigurationElement.getNamespace() + "', '" + string3 + "'.";
                    Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, string, null);
                    list.add(status);
                } else {
                    string = iConfigurationElement2.getAttribute(ATTRIBUTE_OPTIONAL);
                    boolean bl = string == null || string.length() == 0 ? true : !"false".equalsIgnoreCase(string);
                    Parameter parameter = new Parameter(string3, string2, iConfigurationElement2, bl);
                    parameterArray[n++] = parameter;
                }
            }
            ++n2;
        }
        if (n != parameterArray.length) {
            Parameter[] parameterArray2 = new Parameter[n];
            System.arraycopy(parameterArray, 0, parameterArray2, 0, n);
            parameterArray = parameterArray2;
        }
        return parameterArray;
    }

    private CommandPersistence() {
    }
}

