/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.dom;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.ercp.xml.dom.AttrImpl;
import org.eclipse.ercp.xml.dom.ElementImpl;
import org.eclipse.ercp.xml.parser.EXmlMsg;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttributeMap
implements NamedNodeMap {
    ElementImpl owner;
    Hashtable attributes;

    public AttributeMap(ElementImpl elementImpl) {
        this.owner = elementImpl;
        this.attributes = new Hashtable();
    }

    public Node getNamedItem(String string) {
        return (Node)this.attributes.get(string);
    }

    public Node setNamedItem(Node node) throws DOMException {
        if (this.owner.getOwnerDocument() != node.getOwnerDocument()) {
            throw new DOMException(4, EXmlMsg.getDefault().getString(30));
        }
        AttrImpl attrImpl = (AttrImpl)node;
        if (attrImpl.getOwnerElement() != null && attrImpl.getOwnerElement() != this.owner) {
            throw new DOMException(10, EXmlMsg.getDefault().getString(31));
        }
        attrImpl.setOwnerElement(this.owner);
        AttrImpl attrImpl2 = (AttrImpl)this.getNamedItem(attrImpl.getName());
        this.attributes.put(attrImpl.getName(), attrImpl);
        if (attrImpl2 != null) {
            attrImpl2.setOwnerElement(null);
        }
        return attrImpl2;
    }

    public Node removeNamedItem(String string) throws DOMException {
        AttrImpl attrImpl = (AttrImpl)this.getNamedItem(string);
        this.attributes.remove(string);
        if (attrImpl != null) {
            attrImpl.setOwnerElement(null);
        }
        return attrImpl;
    }

    public Node item(int n) {
        Enumeration enumeration = this.attributes.elements();
        int n2 = -1;
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (++n2 != n) continue;
            return node;
        }
        return null;
    }

    public int getLength() {
        return this.attributes.size();
    }

    public Node getNamedItemNS(String string, String string2) {
        if (this.attributes == null) {
            return null;
        }
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (!string.equals(node.getNamespaceURI()) || !string2.equals(node.getLocalName())) continue;
            return node;
        }
        return null;
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        return this.owner.setAttributeNodeNS((Attr)node);
    }

    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        AttrImpl attrImpl = (AttrImpl)this.getNamedItemNS(string, string2);
        if (attrImpl != null) {
            this.attributes.remove(attrImpl.getName());
            attrImpl.setOwnerElement(null);
        }
        return attrImpl;
    }

    Node removeItem(Node node) throws DOMException {
        if (node == null) {
            return null;
        }
        AttrImpl attrImpl = (AttrImpl)node;
        if (attrImpl.getOwnerElement() != this.owner) {
            throw new DOMException(8, EXmlMsg.getDefault().getString(32));
        }
        this.attributes.remove(attrImpl.getName());
        attrImpl.setOwnerElement(null);
        return attrImpl;
    }

    void setNamedItemNS(String string, String string2, String string3) throws DOMException {
        AttrImpl attrImpl = (AttrImpl)this.getNamedItem(string2);
        if (attrImpl == null) {
            attrImpl = (AttrImpl)this.owner.getOwnerDocument().createAttributeNS(string, string2);
            this.attributes.put(string2, attrImpl);
            attrImpl.setOwnerElement(this.owner);
        }
        attrImpl.setValue(string3);
    }

    void setNamedItem(String string, String string2) throws DOMException {
        AttrImpl attrImpl = (AttrImpl)this.getNamedItem(string);
        if (attrImpl == null) {
            attrImpl = (AttrImpl)this.owner.getOwnerDocument().createAttribute(string);
            this.attributes.put(string, attrImpl);
            attrImpl.setOwnerElement(this.owner);
        }
        attrImpl.setValue(string2);
    }
}

