/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLine;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class StatusLineManager
extends ContributionManager
implements IStatusLineManager {
    public static final String BEGIN_GROUP = "BEGIN_GROUP";
    public static final String MIDDLE_GROUP = "MIDDLE_GROUP";
    public static final String END_GROUP = "END_GROUP";
    private Composite statusLine = null;

    public Control createControl(Composite composite) {
        return this.createControl(composite, 0);
    }

    public Control createControl(Composite composite, int n) {
        if (!this.statusLineExist() && composite != null) {
            this.statusLine = new StatusLine(composite, n);
            this.update(false);
        }
        return this.statusLine;
    }

    public void dispose() {
        if (this.statusLineExist()) {
            this.statusLine.dispose();
        }
        this.statusLine = null;
        IContributionItem[] iContributionItemArray = this.getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            iContributionItemArray[n].dispose();
            ++n;
        }
    }

    public Control getControl() {
        return this.statusLine;
    }

    protected IProgressMonitor getProgressMonitorDelegate() {
        return (IProgressMonitor)this.getControl();
    }

    public IProgressMonitor getProgressMonitor() {
        return new IProgressMonitorWithBlocking(){
            IProgressMonitor progressDelegate;
            {
                this.progressDelegate = StatusLineManager.this.getProgressMonitorDelegate();
            }

            public void beginTask(String string, int n) {
                this.progressDelegate.beginTask(string, n);
            }

            public void done() {
                this.progressDelegate.done();
            }

            public void internalWorked(double d) {
                this.progressDelegate.internalWorked(d);
            }

            public boolean isCanceled() {
                return this.progressDelegate.isCanceled();
            }

            public void setCanceled(boolean bl) {
                if (StatusLineManager.this.statusLine.isDisposed()) {
                    return;
                }
                this.progressDelegate.setCanceled(bl);
            }

            public void setTaskName(String string) {
                this.progressDelegate.setTaskName(string);
            }

            public void subTask(String string) {
                this.progressDelegate.subTask(string);
            }

            public void worked(int n) {
                this.progressDelegate.worked(n);
            }

            public void clearBlocked() {
            }

            public void setBlocked(IStatus iStatus) {
            }
        };
    }

    public boolean isCancelEnabled() {
        return this.statusLineExist() && ((StatusLine)this.statusLine).isCancelEnabled();
    }

    public void setCancelEnabled(boolean bl) {
        if (this.statusLineExist()) {
            ((StatusLine)this.statusLine).setCancelEnabled(bl);
        }
    }

    public void setErrorMessage(String string) {
        if (this.statusLineExist()) {
            ((StatusLine)this.statusLine).setErrorMessage(string);
        }
    }

    public void setErrorMessage(Image image, String string) {
        if (this.statusLineExist()) {
            ((StatusLine)this.statusLine).setErrorMessage(image, string);
        }
    }

    public void setMessage(String string) {
        if (this.statusLineExist()) {
            ((StatusLine)this.statusLine).setMessage(string);
        }
    }

    public void setMessage(Image image, String string) {
        if (this.statusLineExist()) {
            ((StatusLine)this.statusLine).setMessage(image, string);
        }
    }

    private boolean statusLineExist() {
        return this.statusLine != null && !this.statusLine.isDisposed();
    }

    public void update(boolean bl) {
        if ((this.isDirty() || bl) && this.statusLineExist()) {
            IContributionItem[] iContributionItemArray;
            this.statusLine.setRedraw(false);
            Control[] controlArray = this.statusLine.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                iContributionItemArray = controlArray[n];
                Object object = iContributionItemArray.getData();
                if (object instanceof IContributionItem) {
                    iContributionItemArray.dispose();
                }
                ++n;
            }
            n = this.statusLine.getChildren().length;
            iContributionItemArray = this.getItems();
            int n2 = 0;
            while (n2 < iContributionItemArray.length) {
                IContributionItem iContributionItem = iContributionItemArray[n2];
                if (iContributionItem.isVisible()) {
                    iContributionItem.fill(this.statusLine);
                    Control[] controlArray2 = this.statusLine.getChildren();
                    int n3 = n;
                    while (n3 < controlArray2.length) {
                        controlArray2[n3].setData((Object)iContributionItem);
                        ++n3;
                    }
                    n = controlArray2.length;
                }
                ++n2;
            }
            this.setDirty(false);
            this.statusLine.layout();
            this.statusLine.setRedraw(true);
        }
    }
}

