/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import com.ibm.ugl.eswt.expanded.OS;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public abstract class ByteArrayTransfer
extends Transfer {
    int size = 0;

    public TransferData[] getSupportedTypes() {
        int[] ids = this.getTypeIds();
        TransferData[] datas = new TransferData[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            datas[i] = new TransferData();
            datas[i].type = ids[i];
        }
        return datas;
    }

    public boolean isSupportedType(TransferData transferData) {
        int[] ids = this.getTypeIds();
        for (int i = 0; i < ids.length; ++i) {
            if (transferData.type != ids[i]) continue;
            return true;
        }
        return false;
    }

    protected void javaToNative(Object object, TransferData transferData) {
        if (object instanceof byte[]) {
            transferData.data = object;
            transferData.result = 1;
        } else {
            transferData.result = 0;
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        if (transferData.data instanceof byte[]) {
            return (byte[])transferData.data;
        }
        return null;
    }

    boolean getNativeData(TransferData data) {
        byte[] bytes = OS.Clipboard_GetByteData(data.type);
        if (bytes != null) {
            byte[] temp = new byte[this.size];
            for (int i = 0; i < this.size; ++i) {
                temp[i] = bytes[i];
            }
            data.data = temp;
            return true;
        }
        return false;
    }

    void setNativeData(TransferData transfer) {
        if (transfer.data instanceof byte[]) {
            byte[] data = (byte[])transfer.data;
            OS.Clipboard_SetByteData(transfer.type, data, data.length);
        }
    }
}

