/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.InstallConfiguration;
import org.eclipse.update.internal.operations.FeatureHierarchyElement;
import org.eclipse.update.internal.operations.FeatureOperation;
import org.eclipse.update.internal.operations.JobRoot;
import org.eclipse.update.internal.operations.UpdateUtils;

public abstract class OptionalFeatureOperation
extends FeatureOperation {
    IFeatureReference[] optionalFeatures;
    IFeature[] unconfiguredOptionalFeatures;

    public OptionalFeatureOperation(IConfiguredSite iConfiguredSite, IFeature iFeature) {
        super(iConfiguredSite, iFeature);
    }

    void preserveOptionalState() {
        if (this.unconfiguredOptionalFeatures == null) {
            return;
        }
        int n = 0;
        while (n < this.unconfiguredOptionalFeatures.length) {
            try {
                IFeature iFeature = UpdateUtils.getLocalFeature(this.targetSite, this.unconfiguredOptionalFeatures[n]);
                if (iFeature != null) {
                    this.targetSite.unconfigure(iFeature);
                }
            }
            catch (CoreException coreException) {}
            ++n;
        }
    }

    void setOptionalFeatures() {
        try {
            if (this.optionalFeatures == null && UpdateUtils.hasOptionalFeatures(this.feature)) {
                JobRoot jobRoot = new JobRoot(this);
                IInstallConfiguration iInstallConfiguration = SiteManager.getLocalSite().getCurrentConfiguration();
                HashSet hashSet = new HashSet();
                boolean bl = this.oldFeature != null;
                boolean bl2 = UpdateUtils.isPatch(this.feature);
                FeatureHierarchyElement[] featureHierarchyElementArray = jobRoot.getElements();
                int n = 0;
                while (n < featureHierarchyElementArray.length) {
                    featureHierarchyElementArray[n].addCheckedOptionalFeatures(bl, bl2, iInstallConfiguration, hashSet);
                    ++n;
                }
                this.optionalFeatures = new IFeatureReference[hashSet.size()];
                hashSet.toArray(this.optionalFeatures);
                this.unconfiguredOptionalFeatures = jobRoot.getUnconfiguredOptionalFeatures(iInstallConfiguration, this.targetSite);
            }
        }
        catch (CoreException coreException) {
            UpdateUtils.logException(coreException);
        }
    }

    boolean isManagedOnly() {
        int n = InstallConfiguration.getDefaultPolicy();
        return n == 2;
    }
}

