/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import com.ibm.ugl.eswt.OS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;

public final class Font {
    public int internal_handle;
    private FontData fontData;

    Font(int handle) {
        this.internal_handle = handle;
    }

    public Font(Device device, FontData fd) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (fd == null) {
            SWT.error(4);
        }
        if (fd.getName() == null) {
            SWT.error(4);
        }
        this.init(device, fd.getName(), fd.getHeight(), fd.getStyle());
    }

    public Font(Device device, FontData[] fds) {
        if (fds == null) {
            SWT.error(4);
        }
        if (fds.length == 0) {
            SWT.error(5);
        }
        for (int i = 0; i < fds.length; ++i) {
            if (fds[i] != null) continue;
            SWT.error(4);
        }
        this.init(device, fds[0].getName(), fds[0].getHeight(), fds[0].getStyle());
    }

    public Font(Device device, String name, int height, int style) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (name == null) {
            SWT.error(4);
        }
        this.init(device, name, height, style);
    }

    public void dispose() {
        if (this.internal_handle == 0) {
            return;
        }
        OS.Font_Dispose(this.internal_handle);
        this.internal_handle = 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Font)) {
            return false;
        }
        Font font = (Font)object;
        return this.internal_handle == font.internal_handle;
    }

    public FontData[] getFontData() {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        if (this.fontData == null) {
            this.fontData = new FontData();
            this.fontData.height = OS.Font_GetSizeInPoints(this.internal_handle);
            this.fontData.style = FontData.internal_convertToSWTStyle(OS.Font_GetStyle(this.internal_handle));
            this.fontData.name = OS.Font_GetName(this.internal_handle);
        }
        return new FontData[]{this.fontData};
    }

    public int hashCode() {
        return this.internal_handle;
    }

    void init(Device device, String name, int height, int style) {
        if (height < 0) {
            SWT.error(4);
        }
        this.fontData = new FontData(name, height, style);
        this.internal_handle = OS.Font_New(device.internal_handle, name, height, FontData.internal_convertToNativeStyle(style));
    }

    public boolean isDisposed() {
        return this.internal_handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Font {*DISPOSED*}";
        }
        return "Font {" + this.internal_handle + "}";
    }
}

