/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands.operations;

import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class LinearUndoViolationDetector
implements IOperationApprover {
    protected abstract IStatus allowLinearRedoViolation(IUndoableOperation var1, IUndoContext var2, IOperationHistory var3, IAdaptable var4);

    protected abstract IStatus allowLinearUndoViolation(IUndoableOperation var1, IUndoContext var2, IOperationHistory var3, IAdaptable var4);

    public final IStatus proceedRedoing(IUndoableOperation iUndoableOperation, IOperationHistory iOperationHistory, IAdaptable iAdaptable) {
        IUndoContext[] iUndoContextArray = iUndoableOperation.getContexts();
        int n = 0;
        while (n < iUndoContextArray.length) {
            IStatus iStatus;
            IUndoContext iUndoContext = iUndoContextArray[n];
            if (iOperationHistory.getRedoOperation(iUndoContext) != iUndoableOperation && !(iStatus = this.allowLinearRedoViolation(iUndoableOperation, iUndoContext, iOperationHistory, iAdaptable)).isOK()) {
                return iStatus;
            }
            ++n;
        }
        return Status.OK_STATUS;
    }

    public final IStatus proceedUndoing(IUndoableOperation iUndoableOperation, IOperationHistory iOperationHistory, IAdaptable iAdaptable) {
        IUndoContext[] iUndoContextArray = iUndoableOperation.getContexts();
        int n = 0;
        while (n < iUndoContextArray.length) {
            IStatus iStatus;
            IUndoContext iUndoContext = iUndoContextArray[n];
            if (iOperationHistory.getUndoOperation(iUndoContext) != iUndoableOperation && !(iStatus = this.allowLinearUndoViolation(iUndoableOperation, iUndoContext, iOperationHistory, iAdaptable)).isOK()) {
                return iStatus;
            }
            ++n;
        }
        return Status.OK_STATUS;
    }
}

