/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.core.internal.content.TextContentDescriber;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;

public class XMLContentDescriber
extends TextContentDescriber
implements ITextContentDescriber {
    private static final QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
    private static final String ENCODING = "encoding=";
    private static final String XML_PREFIX = "<?xml ";

    public int describe(InputStream inputStream, IContentDescription iContentDescription) throws IOException {
        String string;
        String string2;
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3 = this.getByteOrderMark(inputStream);
        String string3 = "UTF-8";
        inputStream.reset();
        if (byArray3 != null) {
            if (byArray3 == IContentDescription.BOM_UTF_16BE) {
                string3 = "UTF-16BE";
            } else if (byArray3 == IContentDescription.BOM_UTF_16LE) {
                string3 = "UTF-16LE";
            }
            inputStream.skip(byArray3.length);
            if (iContentDescription != null && iContentDescription.isRequested(IContentDescription.BYTE_ORDER_MARK)) {
                iContentDescription.setProperty(IContentDescription.BYTE_ORDER_MARK, byArray3);
            }
        }
        if (inputStream.read(byArray2 = new byte[(byArray = XML_PREFIX.getBytes(string3)).length]) < byArray2.length) {
            return 1;
        }
        int n = 0;
        while (n < byArray2.length) {
            if (byArray2[n] != byArray[n]) {
                return 1;
            }
            ++n;
        }
        if (iContentDescription == null) {
            return 2;
        }
        if (iContentDescription.isRequested(IContentDescription.CHARSET) && (string2 = this.readFullXMLDecl(inputStream, string3)) != null && (string = this.getCharset(string2)) != null && !"UTF-8".equalsIgnoreCase(string)) {
            iContentDescription.setProperty(IContentDescription.CHARSET, this.getCharset(string2));
        }
        return 2;
    }

    private String readFullXMLDecl(InputStream inputStream, String string) throws IOException {
        byte[] byArray = new byte[100];
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length && (n = inputStream.read()) != -1 && n != 63) {
            byArray[n2++] = (byte)n;
        }
        return n == 63 ? new String(byArray, 0, n2, string) : null;
    }

    public int describe(Reader reader, IContentDescription iContentDescription) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = bufferedReader.readLine();
        if (string == null) {
            return 1;
        }
        if (!string.startsWith(XML_PREFIX)) {
            return 1;
        }
        if (iContentDescription == null) {
            return 2;
        }
        if (iContentDescription.isRequested(IContentDescription.CHARSET)) {
            iContentDescription.setProperty(IContentDescription.CHARSET, this.getCharset(string));
        }
        return 2;
    }

    private String getCharset(String string) {
        int n = string.indexOf(ENCODING);
        if (n == -1) {
            return null;
        }
        int n2 = 34;
        int n3 = string.indexOf(n2, n);
        if (n3 == -1) {
            n2 = 39;
            n3 = string.indexOf(n2, n);
        }
        if (n3 == -1 || string.length() == n3 - 1) {
            return null;
        }
        int n4 = string.indexOf(n2, n3 + 1);
        if (n4 == -1) {
            return null;
        }
        return string.substring(n3 + 1, n4);
    }

    public QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }
}

