/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.HashMap;
import java.util.Stack;
import org.eclipse.core.internal.jobs.Deadlock;
import org.eclipse.core.internal.jobs.DeadlockDetector;
import org.eclipse.core.internal.jobs.OrderedLock;
import org.eclipse.core.internal.jobs.Worker;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.LockListener;

public class LockManager {
    protected LockListener lockListener;
    private DeadlockDetector locks = new DeadlockDetector();
    private HashMap suspendedLocks = new HashMap();

    public void aboutToRelease() {
        if (this.lockListener == null) {
            return;
        }
        try {
            this.lockListener.aboutToRelease();
        }
        catch (Exception exception) {
            LockManager.handleException(exception);
        }
        catch (LinkageError linkageError) {
            LockManager.handleException(linkageError);
        }
    }

    public boolean aboutToWait(Thread thread) {
        if (this.lockListener == null) {
            return false;
        }
        try {
            return this.lockListener.aboutToWait(thread);
        }
        catch (Exception exception) {
            LockManager.handleException(exception);
        }
        catch (LinkageError linkageError) {
            LockManager.handleException(linkageError);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLockThread(Thread thread, ISchedulingRule iSchedulingRule) {
        if (this.locks == null) {
            return;
        }
        try {
            DeadlockDetector deadlockDetector = this.locks;
            synchronized (deadlockDetector) {
                this.locks.lockAcquired(thread, iSchedulingRule);
            }
        }
        catch (Exception exception) {
            this.handleInternalError(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLockWaitThread(Thread thread, ISchedulingRule iSchedulingRule) {
        if (this.locks == null) {
            return;
        }
        try {
            Deadlock deadlock = null;
            ISchedulingRule[] iSchedulingRuleArray = this.locks;
            synchronized (this.locks) {
                deadlock = this.locks.lockWaitStart(thread, iSchedulingRule);
                // ** MonitorExit[var4_5] (shouldn't be in output)
                if (deadlock == null) {
                    return;
                }
                iSchedulingRuleArray = deadlock.getLocks();
                LockState[] lockStateArray = new LockState[iSchedulingRuleArray.length];
                int n = 0;
                while (n < iSchedulingRuleArray.length) {
                    lockStateArray[n] = LockState.suspend((OrderedLock)iSchedulingRuleArray[n]);
                    ++n;
                }
                HashMap hashMap = this.suspendedLocks;
                synchronized (hashMap) {
                    Stack<LockState[]> stack = (Stack<LockState[]>)this.suspendedLocks.get(deadlock.getCandidate());
                    if (stack == null) {
                        stack = new Stack<LockState[]>();
                    }
                    stack.push(lockStateArray);
                    this.suspendedLocks.put(deadlock.getCandidate(), stack);
                }
            }
        }
        catch (Exception exception) {
            this.handleInternalError(exception);
        }
        {
            return;
        }
    }

    private static void handleException(Throwable throwable) {
        MultiStatus multiStatus;
        if (throwable instanceof CoreException) {
            multiStatus = new MultiStatus("org.eclipse.core.jobs", 2, "LockManager.handleException", throwable);
            multiStatus.merge(((CoreException)throwable).getStatus());
        } else {
            multiStatus = new Status(4, "org.eclipse.core.jobs", 2, "LockManager.handleException", throwable);
        }
        RuntimeLog.log((IStatus)multiStatus);
    }

    private void handleInternalError(Throwable throwable) {
        try {
            LockManager.handleException(throwable);
            LockManager.handleException(new Exception(this.locks.toDebugString()));
        }
        catch (Exception exception) {}
        this.locks = null;
    }

    public boolean isEmpty() {
        return this.locks.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLockOwner() {
        Thread thread = Thread.currentThread();
        if (thread instanceof Worker) {
            return true;
        }
        if (this.locks == null) {
            return false;
        }
        DeadlockDetector deadlockDetector = this.locks;
        synchronized (deadlockDetector) {
            return this.locks.contains(Thread.currentThread());
        }
    }

    public synchronized OrderedLock newLock() {
        return new OrderedLock(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLockCompletely(Thread thread, ISchedulingRule iSchedulingRule) {
        if (this.locks == null) {
            return;
        }
        try {
            DeadlockDetector deadlockDetector = this.locks;
            synchronized (deadlockDetector) {
                this.locks.lockReleasedCompletely(thread, iSchedulingRule);
            }
        }
        catch (Exception exception) {
            this.handleInternalError(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLockThread(Thread thread, ISchedulingRule iSchedulingRule) {
        try {
            DeadlockDetector deadlockDetector = this.locks;
            synchronized (deadlockDetector) {
                this.locks.lockReleased(thread, iSchedulingRule);
            }
        }
        catch (Exception exception) {
            this.handleInternalError(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLockWaitThread(Thread thread, ISchedulingRule iSchedulingRule) {
        try {
            DeadlockDetector deadlockDetector = this.locks;
            synchronized (deadlockDetector) {
                this.locks.lockWaitStop(thread, iSchedulingRule);
            }
        }
        catch (Exception exception) {
            this.handleInternalError(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resumeSuspendedLocks(Thread thread) {
        LockState[] lockStateArray;
        HashMap hashMap = this.suspendedLocks;
        synchronized (hashMap) {
            Stack stack = (Stack)this.suspendedLocks.get(thread);
            if (stack == null) {
                return;
            }
            lockStateArray = (LockState[])stack.pop();
            if (stack.empty()) {
                this.suspendedLocks.remove(thread);
            }
        }
        int n = 0;
        while (n < lockStateArray.length) {
            lockStateArray[n].resume();
            ++n;
        }
    }

    public void setLockListener(LockListener lockListener) {
        this.lockListener = lockListener;
    }

    private static class LockState {
        private int depth;
        private OrderedLock lock;

        private LockState() {
        }

        protected static LockState suspend(OrderedLock orderedLock) {
            LockState lockState = new LockState();
            lockState.lock = orderedLock;
            lockState.depth = orderedLock.forceRelease();
            return lockState;
        }

        public void resume() {
            while (true) {
                try {
                    while (!this.lock.acquire(Long.MAX_VALUE)) {
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            this.lock.setDepth(this.depth);
        }
    }
}

