/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core.model;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class FeatureReferenceModel
extends ModelObject {
    private String type;
    private URL url;
    private String urlString;
    private String featureId;
    private String featureVersion;
    private SiteModel site;
    private String label;
    private String localizedLabel;
    private URL bundleURL;
    private URL base;
    private boolean resolved = false;
    private String os;
    private String ws;
    private String nl;
    private String arch;
    private String patch;

    public FeatureReferenceModel() {
    }

    public FeatureReferenceModel(FeatureReferenceModel featureReferenceModel) {
        this.setFeatureIdentifier(featureReferenceModel.getFeatureIdentifier());
        this.setFeatureVersion(featureReferenceModel.getFeatureVersion());
        this.setType(featureReferenceModel.getType());
        this.setSiteModel(featureReferenceModel.getSiteModel());
        this.setLabel(featureReferenceModel.getLabel());
        this.setWS(featureReferenceModel.getWS());
        this.setOS(featureReferenceModel.getOS());
        this.setArch(featureReferenceModel.getOSArch());
        this.setNL(featureReferenceModel.getNL());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getURL() == null) {
            return false;
        }
        if (!(object instanceof FeatureReferenceModel)) {
            return false;
        }
        FeatureReferenceModel featureReferenceModel = (FeatureReferenceModel)((Object)object);
        return UpdateManagerUtils.sameURL(this.getURL(), featureReferenceModel.getURL());
    }

    public String getType() {
        return this.type;
    }

    public SiteModel getSiteModel() {
        return this.site;
    }

    public String getURLString() {
        return this.urlString;
    }

    public URL getURL() {
        this.delayedResolve();
        return this.url;
    }

    public String getFeatureIdentifier() {
        return this.featureId;
    }

    public String getFeatureVersion() {
        return this.featureVersion;
    }

    public void setType(String string) {
        this.assertIsWriteable();
        this.type = string;
    }

    public void setSiteModel(SiteModel siteModel) {
        this.assertIsWriteable();
        this.site = siteModel;
    }

    public void setURLString(String string) {
        this.assertIsWriteable();
        this.urlString = string;
        this.url = null;
    }

    public void setFeatureIdentifier(String string) {
        this.assertIsWriteable();
        this.featureId = string;
    }

    public void setFeatureVersion(String string) {
        this.assertIsWriteable();
        this.featureVersion = string;
    }

    public void resolve(URL uRL, URL uRL2) throws MalformedURLException {
        this.base = uRL;
        this.bundleURL = uRL2;
    }

    private void delayedResolve() {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        this.localizedLabel = this.resolveNLString(this.bundleURL, this.label);
        try {
            this.url = this.resolveURL(this.base, this.bundleURL, this.urlString);
        }
        catch (MalformedURLException malformedURLException) {
            UpdateCore.warn("", malformedURLException);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(((Object)((Object)this)).getClass().toString()) + " :");
        stringBuffer.append(" at ");
        if (this.url != null) {
            stringBuffer.append(this.url.toExternalForm());
        }
        return stringBuffer.toString();
    }

    protected String getPropertyName() {
        return "site";
    }

    public String getLabel() {
        this.delayedResolve();
        if (this.localizedLabel != null) {
            return this.localizedLabel;
        }
        return this.label;
    }

    public String getLabelNonLocalized() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getOS() {
        return this.os;
    }

    public String getWS() {
        return this.ws;
    }

    public String getOSArch() {
        return this.arch;
    }

    public String getNL() {
        return this.nl;
    }

    public void setOS(String string) {
        this.assertIsWriteable();
        this.os = string;
    }

    public void setWS(String string) {
        this.assertIsWriteable();
        this.ws = string;
    }

    public void setNL(String string) {
        this.assertIsWriteable();
        this.nl = string;
    }

    public void setArch(String string) {
        this.assertIsWriteable();
        this.arch = string;
    }

    public String getPatch() {
        return this.patch;
    }

    public void setPatch(String string) {
        this.patch = string;
    }
}

