/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor.loader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingStatsHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.FragmentClasspath;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.internal.baseadaptor.AdaptorMsg;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;

public class ClasspathManager {
    private static final FragmentClasspath[] emptyFragments = new FragmentClasspath[0];
    private static final String PROP_CLASSLOADER_LOCK = "osgi.classloader.lock";
    private static final String VALUE_CLASSNAME_LOCK = "classname";
    private static final boolean LOCK_CLASSNAME = "classname".equals(FrameworkProperties.getProperty("osgi.classloader.lock"));
    private BaseData data;
    private String[] classpath;
    private ClasspathEntry[] entries;
    private BaseClassLoader classloader;
    private FragmentClasspath[] fragments = emptyFragments;
    private Collection loadedLibraries = null;
    private HashMap classNameLocks = new HashMap(5);

    public ClasspathManager(BaseData baseData, String[] stringArray, BaseClassLoader baseClassLoader) {
        this.data = baseData;
        this.classpath = stringArray;
        this.classloader = baseClassLoader;
    }

    public void initialize() {
        this.entries = ClasspathManager.buildClasspath(this.classpath, this, this.data, this.classloader.getDomain());
        ClassLoadingHook[] classLoadingHookArray = this.data.getAdaptor().getHookRegistry().getClassLoadingHooks();
        int n = 0;
        while (n < classLoadingHookArray.length) {
            classLoadingHookArray[n].initializedClassLoader(this.classloader, this.data);
            ++n;
        }
    }

    public void close() {
        int n;
        if (this.entries != null) {
            n = 0;
            while (n < this.entries.length) {
                if (this.entries[n] != null) {
                    try {
                        this.entries[n].getBundleFile().close();
                    }
                    catch (IOException iOException) {
                        this.data.getAdaptor().getEventPublisher().publishFrameworkEvent(2, this.data.getBundle(), iOException);
                    }
                }
                ++n;
            }
        }
        n = 0;
        while (n < this.fragments.length) {
            this.fragments[n].close();
            ++n;
        }
    }

    public void attachFragment(BundleData bundleData, ProtectionDomain protectionDomain, String[] stringArray) {
        try {
            bundleData.open();
        }
        catch (IOException iOException) {
            ((BaseData)bundleData).getAdaptor().getEventPublisher().publishFrameworkEvent(2, ((BaseData)bundleData).getBundle(), iOException);
        }
        ClasspathEntry[] classpathEntryArray = ClasspathManager.buildClasspath(stringArray, this, (BaseData)bundleData, protectionDomain);
        FragmentClasspath fragmentClasspath = new FragmentClasspath((BaseData)bundleData, classpathEntryArray, protectionDomain);
        this.insertFragment(fragmentClasspath);
    }

    private synchronized void insertFragment(FragmentClasspath fragmentClasspath) {
        FragmentClasspath[] fragmentClasspathArray = new FragmentClasspath[this.fragments.length + 1];
        long l = fragmentClasspath.getBundleData().getBundleID();
        int n = 0;
        int n2 = 0;
        while (n2 < this.fragments.length) {
            long l2 = this.fragments[n2].getBundleData().getBundleID();
            if (n == 0 && l < l2) {
                fragmentClasspathArray[n2] = fragmentClasspath;
                n = 1;
            }
            fragmentClasspathArray[n2 + n] = this.fragments[n2];
            ++n2;
        }
        if (n == 0) {
            fragmentClasspathArray[this.fragments.length] = fragmentClasspath;
        }
        this.fragments = fragmentClasspathArray;
    }

    private static ClasspathEntry[] buildClasspath(String[] stringArray, ClasspathManager classpathManager, BaseData baseData, ProtectionDomain protectionDomain) {
        ArrayList arrayList = new ArrayList(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            ClasspathManager.findClassPathEntry(arrayList, stringArray[n], classpathManager, baseData, protectionDomain);
            ++n;
        }
        return arrayList.toArray(new ClasspathEntry[arrayList.size()]);
    }

    public static void findClassPathEntry(ArrayList arrayList, String string, ClasspathManager classpathManager, BaseData baseData, ProtectionDomain protectionDomain) {
        ClassLoadingHook[] classLoadingHookArray = baseData.getAdaptor().getHookRegistry().getClassLoadingHooks();
        boolean bl = false;
        int n = 0;
        while (n < classLoadingHookArray.length) {
            bl |= classLoadingHookArray[n].addClassPathEntry(arrayList, string, classpathManager, baseData, protectionDomain);
            ++n;
        }
        if (!ClasspathManager.addClassPathEntry(arrayList, string, classpathManager, baseData, protectionDomain) && !bl) {
            BundleException bundleException = new BundleException(NLS.bind(AdaptorMsg.BUNDLE_CLASSPATH_ENTRY_NOT_FOUND_EXCEPTION, string, baseData.getLocation()));
            baseData.getAdaptor().getEventPublisher().publishFrameworkEvent(32, baseData.getBundle(), bundleException);
        }
    }

    public static boolean addClassPathEntry(ArrayList arrayList, String string, ClasspathManager classpathManager, BaseData baseData, ProtectionDomain protectionDomain) {
        if (string.equals(".")) {
            arrayList.add(classpathManager.createClassPathEntry(baseData.getBundleFile(), protectionDomain));
            return true;
        }
        ClasspathEntry classpathEntry = classpathManager.getClasspath(string, baseData, protectionDomain);
        if (classpathEntry != null) {
            arrayList.add(classpathEntry);
            return true;
        }
        if (classpathManager.data == baseData) {
            int n = 0;
            while (n < classpathManager.fragments.length) {
                FragmentClasspath fragmentClasspath = classpathManager.fragments[n];
                classpathEntry = classpathManager.getClasspath(string, fragmentClasspath.getBundleData(), fragmentClasspath.getDomain());
                if (classpathEntry != null) {
                    arrayList.add(classpathEntry);
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public ClasspathEntry getClasspath(String string, BaseData baseData, ProtectionDomain protectionDomain) {
        BundleFile bundleFile = null;
        BundleEntry bundleEntry = baseData.getBundleFile().getEntry(string);
        if (bundleEntry != null && bundleEntry.getName().endsWith("/")) {
            bundleFile = ClasspathManager.createBundleFile(string, baseData);
        } else {
            File file = baseData.getBundleFile().getFile(string, false);
            if (file != null) {
                bundleFile = ClasspathManager.createBundleFile(file, baseData);
            }
        }
        if (bundleFile != null) {
            return this.createClassPathEntry(bundleFile, protectionDomain);
        }
        return null;
    }

    public ClasspathEntry getExternalClassPath(String string, BaseData baseData, ProtectionDomain protectionDomain) {
        File file = new File(string);
        if (!file.isAbsolute()) {
            return null;
        }
        BundleFile bundleFile = ClasspathManager.createBundleFile(file, baseData);
        if (bundleFile != null) {
            return this.createClassPathEntry(bundleFile, protectionDomain);
        }
        return null;
    }

    private static BundleFile createBundleFile(Object object, BaseData baseData) {
        if (object == null || object instanceof File && !((File)object).exists()) {
            return null;
        }
        try {
            return baseData.getAdaptor().createBundleFile(object, baseData);
        }
        catch (IOException iOException) {
            baseData.getAdaptor().getEventPublisher().publishFrameworkEvent(2, baseData.getBundle(), iOException);
            return null;
        }
    }

    private ClasspathEntry createClassPathEntry(BundleFile bundleFile, ProtectionDomain protectionDomain) {
        return this.classloader.createClassPathEntry(bundleFile, protectionDomain);
    }

    /*
     * Unable to fully structure code
     */
    public URL findLocalResource(String var1_1) {
        var2_2 = this.data.getAdaptor().getHookRegistry().getClassLoadingStatsHooks();
        var3_3 = 0;
        while (var3_3 < var2_2.length) {
            var2_2[var3_3].preFindLocalResource(var1_1, this);
            ++var3_3;
        }
        var3_4 = null;
        try {
            var6_5 = var3_4 = this.findLocalResourceImpl(var1_1);
            var4_6 = null;
            var7_8 = 0;
            ** while (var7_8 < var2_2.length)
        }
        catch (Throwable var5_10) {
            var4_7 = null;
            var7_9 = 0;
            ** while (var7_9 < var2_2.length)
        }
lbl-1000:
        // 1 sources

        {
            var2_2[var7_8].postFindLocalResource(var1_1, var3_4, this);
            ++var7_8;
            continue;
        }
lbl17:
        // 1 sources

        return var6_5;
lbl-1000:
        // 1 sources

        {
            var2_2[var7_9].postFindLocalResource(var1_1, var3_4, this);
            ++var7_9;
            continue;
        }
lbl26:
        // 1 sources

        throw var5_10;
    }

    private URL findLocalResourceImpl(String string) {
        URL uRL = null;
        int n = 0;
        while (n < this.entries.length) {
            if (this.entries[n] != null && (uRL = this.findResourceImpl(string, this.entries[n].getBundleFile())) != null) {
                return uRL;
            }
            ++n;
        }
        n = 0;
        while (n < this.fragments.length) {
            ClasspathEntry[] classpathEntryArray = this.fragments[n].getEntries();
            int n2 = 0;
            while (n2 < classpathEntryArray.length) {
                uRL = this.findResourceImpl(string, classpathEntryArray[n2].getBundleFile());
                if (uRL != null) {
                    return uRL;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public Enumeration findLocalResources(String string) {
        Object object;
        Vector<Object> vector = new Vector<Object>(6);
        int n = 0;
        while (n < this.entries.length) {
            if (this.entries[n] != null && (object = this.findResourceImpl(string, this.entries[n].getBundleFile(), vector.size())) != null) {
                vector.addElement(object);
            }
            ++n;
        }
        n = 0;
        while (n < this.fragments.length) {
            object = this.fragments[n].getEntries();
            int n2 = 0;
            while (n2 < ((ClasspathEntry[])object).length) {
                URL uRL = this.findResourceImpl(string, object[n2].getBundleFile(), vector.size());
                if (uRL != null) {
                    vector.addElement(uRL);
                }
                ++n2;
            }
            ++n;
        }
        if (vector.size() > 0) {
            return vector.elements();
        }
        return null;
    }

    private URL findResourceImpl(String string, BundleFile bundleFile) {
        return this.findResourceImpl(string, bundleFile, 0);
    }

    private URL findResourceImpl(String string, BundleFile bundleFile, int n) {
        return bundleFile.getResourceURL(string, this.data, n);
    }

    public BundleEntry findLocalEntry(String string) {
        BundleEntry bundleEntry = null;
        int n = 0;
        while (n < this.entries.length) {
            if (this.entries[n] != null && (bundleEntry = this.findEntryImpl(string, this.entries[n].getBundleFile())) != null) {
                return bundleEntry;
            }
            ++n;
        }
        n = 0;
        while (n < this.fragments.length) {
            ClasspathEntry[] classpathEntryArray = this.fragments[n].getEntries();
            int n2 = 0;
            while (n2 < classpathEntryArray.length) {
                bundleEntry = this.findEntryImpl(string, classpathEntryArray[n2].getBundleFile());
                if (bundleEntry != null) {
                    return bundleEntry;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public Enumeration findLocalEntries(String string) {
        Object object;
        Vector<Object> vector = new Vector<Object>(6);
        int n = 0;
        while (n < this.entries.length) {
            if (this.entries[n] != null && (object = this.findEntryImpl(string, this.entries[n].getBundleFile())) != null) {
                vector.addElement(object);
            }
            ++n;
        }
        n = 0;
        while (n < this.fragments.length) {
            object = this.fragments[n].getEntries();
            int n2 = 0;
            while (n2 < ((ClasspathEntry[])object).length) {
                BundleEntry bundleEntry = this.findEntryImpl(string, object[n2].getBundleFile());
                if (bundleEntry != null) {
                    vector.addElement(bundleEntry);
                }
                ++n2;
            }
            ++n;
        }
        if (vector.size() > 0) {
            return vector.elements();
        }
        return null;
    }

    private BundleEntry findEntryImpl(String string, BundleFile bundleFile) {
        return bundleFile.getEntry(string);
    }

    /*
     * Unable to fully structure code
     */
    public Class findLocalClass(String var1_1) throws ClassNotFoundException {
        var2_2 = null;
        var3_3 = this.data.getAdaptor().getHookRegistry().getClassLoadingStatsHooks();
        try {
            var4_4 = 0;
            while (var4_4 < var3_3.length) {
                var3_3[var4_4].preFindLocalClass(var1_1, this);
                ++var4_4;
            }
            var2_2 = ClasspathManager.LOCK_CLASSNAME != false ? this.findLocalClass_LockClassName(var1_1, var3_3) : this.findLocalClass_LockClassLoader(var1_1, var3_3);
            var7_5 = var2_2;
            var5_6 = null;
            var8_8 = 0;
            ** while (var8_8 < var3_3.length)
        }
        catch (Throwable var6_10) {
            var5_7 = null;
            var8_9 = 0;
            ** while (var8_9 < var3_3.length)
        }
lbl-1000:
        // 1 sources

        {
            var3_3[var8_8].postFindLocalClass(var1_1, var2_2, this);
            ++var8_8;
            continue;
        }
lbl18:
        // 1 sources

        return var7_5;
lbl-1000:
        // 1 sources

        {
            var3_3[var8_9].postFindLocalClass(var1_1, var2_2, this);
            ++var8_9;
            continue;
        }
lbl27:
        // 1 sources

        throw var6_10;
    }

    private Class findLocalClass_LockClassName(String string, ClassLoadingStatsHook[] classLoadingStatsHookArray) throws ClassNotFoundException {
        boolean bl = this.lockClassName(string);
        try {
            Class clazz = this.findLocalClassImpl(string, classLoadingStatsHookArray);
            Object var4_5 = null;
            if (bl) {
                this.unlockClassName(string);
            }
            return clazz;
        }
        catch (Throwable throwable) {
            block3: {
                Object var4_6 = null;
                if (!bl) break block3;
                this.unlockClassName(string);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class findLocalClass_LockClassLoader(String string, ClassLoadingStatsHook[] classLoadingStatsHookArray) throws ClassNotFoundException {
        BaseClassLoader baseClassLoader = this.classloader;
        synchronized (baseClassLoader) {
            return this.findLocalClassImpl(string, classLoadingStatsHookArray);
        }
    }

    private Class findLocalClassImpl(String string, ClassLoadingStatsHook[] classLoadingStatsHookArray) throws ClassNotFoundException {
        Class clazz = this.classloader.publicFindLoaded(string);
        if (clazz != null) {
            return clazz;
        }
        int n = 0;
        while (n < this.entries.length) {
            if (this.entries[n] != null && (clazz = this.findClassImpl(string, this.entries[n], classLoadingStatsHookArray)) != null) {
                return clazz;
            }
            ++n;
        }
        n = 0;
        while (n < this.fragments.length) {
            ClasspathEntry[] classpathEntryArray = this.fragments[n].getEntries();
            int n2 = 0;
            while (n2 < classpathEntryArray.length) {
                clazz = this.findClassImpl(string, classpathEntryArray[n2], classLoadingStatsHookArray);
                if (clazz != null) {
                    return clazz;
                }
                ++n2;
            }
            ++n;
        }
        throw new ClassNotFoundException(string);
    }

    /*
     * Unable to fully structure code
     */
    private boolean lockClassName(String var1_1) throws ClassNotFoundException {
        var2_2 = this.classNameLocks;
        synchronized (var2_2) {
            block8: {
                var3_3 = this.classNameLocks.get(var1_1);
                var4_4 = Thread.currentThread();
                if (var3_3 != var4_4) break block8;
                return false;
            }
            while (true) lbl-1000:
            // 2 sources

            {
                if (var3_3 != null) ** break block9
                this.classNameLocks.put(var1_1, var4_4);
                return true;
                break;
            }
            {
                try {
                    this.classNameLocks.wait();
                    var3_3 = this.classNameLocks.get(var1_1);
                    continue;
                }
                catch (InterruptedException v1) {
                    var4_4.interrupt();
                    throw new ClassNotFoundException(var1_1);
                }
                ** while (true)
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockClassName(String string) {
        HashMap hashMap = this.classNameLocks;
        synchronized (hashMap) {
            this.classNameLocks.remove(string);
            this.classNameLocks.notifyAll();
        }
    }

    private Class findClassImpl(String string, ClasspathEntry classpathEntry, ClassLoadingStatsHook[] classLoadingStatsHookArray) {
        byte[] byArray;
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleClassLoader[" + classpathEntry.getBundleFile() + "].findClass(" + string + ")");
        }
        String string2 = string.replace('.', '/').concat(".class");
        BundleEntry bundleEntry = classpathEntry.getBundleFile().getEntry(string2);
        if (bundleEntry == null) {
            return null;
        }
        try {
            byArray = bundleEntry.getBytes();
        }
        catch (IOException iOException) {
            if (Debug.DEBUG_LOADER) {
                Debug.println("  IOException reading " + string2 + " from " + classpathEntry.getBundleFile());
            }
            return null;
        }
        if (Debug.DEBUG_LOADER) {
            Debug.println("  read " + byArray.length + " bytes from " + classpathEntry.getBundleFile() + "/" + string2);
            Debug.println("  defining class " + string);
        }
        try {
            return this.defineClass(string, byArray, classpathEntry, bundleEntry, classLoadingStatsHookArray);
        }
        catch (Error error) {
            if (Debug.DEBUG_LOADER) {
                Debug.println("  error defining class " + string);
            }
            throw error;
        }
    }

    private Class defineClass(String string, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry, ClassLoadingStatsHook[] classLoadingStatsHookArray) {
        ClassLoadingHook[] classLoadingHookArray = this.data.getAdaptor().getHookRegistry().getClassLoadingHooks();
        byte[] byArray2 = byArray;
        int n = 0;
        while (n < classLoadingHookArray.length) {
            byArray2 = classLoadingHookArray[n].processClass(string, byArray, classpathEntry, bundleEntry, this);
            if (byArray2 != null) {
                byArray = byArray2;
            }
            ++n;
        }
        Class clazz = this.classloader.defineClass(string, byArray, classpathEntry, bundleEntry);
        int n2 = 0;
        while (n2 < classLoadingStatsHookArray.length) {
            classLoadingStatsHookArray[n2].recordClassDefine(string, clazz, byArray, classpathEntry, bundleEntry, this);
            ++n2;
        }
        return clazz;
    }

    public BaseData getBaseData() {
        return this.data;
    }

    public FragmentClasspath[] getFragmentClasspaths() {
        return this.fragments;
    }

    public ClasspathEntry[] getHostClasspathEntries() {
        return this.entries;
    }

    public BaseClassLoader getBaseClassLoader() {
        return this.classloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findLibrary(String string) {
        Object object = this;
        synchronized (object) {
            if (this.loadedLibraries == null) {
                this.loadedLibraries = new ArrayList(1);
            }
        }
        object = this.loadedLibraries;
        synchronized (object) {
            Object object2 = this.loadedLibraries.iterator();
            while (object2.hasNext()) {
                String[] stringArray = (String[])object2.next();
                if (!stringArray[0].equals(string)) continue;
                return stringArray[1];
            }
            object2 = this.classloader.getDelegate().findLibrary(string);
            if (object2 != null) {
                this.loadedLibraries.add(new String[]{string, object2});
            }
            return object2;
        }
    }
}

