/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class BundleFragment
extends AbstractBundle {
    protected BundleLoaderProxy[] hosts = null;

    public BundleFragment(BundleData bundleData, Framework framework) throws BundleException {
        super(bundleData, framework);
    }

    protected void load() {
        SecurityManager securityManager;
        if (Debug.DEBUG_GENERAL && (this.state & 2) == 0) {
            Debug.println("Bundle.load called when state != INSTALLED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (this.framework.isActive() && (securityManager = System.getSecurityManager()) != null && this.framework.permissionAdmin != null) {
            this.domain = this.framework.permissionAdmin.createProtectionDomain(this);
        }
    }

    protected boolean reload(AbstractBundle abstractBundle) {
        if (Debug.DEBUG_GENERAL && (this.state & 6) == 0) {
            Debug.println("Bundle.reload called when state != INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean bl = false;
        if (this.framework.isActive()) {
            if (this.hosts != null && this.state == 4) {
                bl = true;
                this.hosts = null;
                this.state = 2;
            }
        } else {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        if (!bl) {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        this.bundledata = abstractBundle.bundledata;
        this.bundledata.setBundle(this);
        if (this.framework.isActive() && System.getSecurityManager() != null && this.framework.permissionAdmin != null) {
            this.domain = this.framework.permissionAdmin.createProtectionDomain(this);
        }
        return bl;
    }

    protected void refresh() {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.refresh called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (this.state == 4) {
            this.hosts = null;
            this.state = 2;
        }
        this.manifestLocalization = null;
    }

    protected boolean unload() {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.unload called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean bl = false;
        if (this.framework.isActive() && this.hosts != null) {
            if (this.state == 4) {
                bl = true;
                this.hosts = null;
                this.state = 2;
            }
            this.domain = null;
        }
        if (!bl) {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (bl) {
            try {
                this.framework.checkAdminPermission(this, "class");
            }
            catch (SecurityException securityException) {
                throw new ClassNotFoundException();
            }
            this.checkValid();
        }
        throw new ClassNotFoundException(NLS.bind(Msg.BUNDLE_FRAGMENT_CNFE, string));
    }

    public URL getResource(String string) {
        this.checkValid();
        return null;
    }

    public Enumeration getResources(String string) {
        this.checkValid();
        return null;
    }

    protected void startWorker(int n) throws BundleException {
        throw new BundleException(NLS.bind(Msg.BUNDLE_FRAGMENT_START, this));
    }

    protected void stopWorker(int n) throws BundleException {
        throw new BundleException(NLS.bind(Msg.BUNDLE_FRAGMENT_STOP, this));
    }

    public ServiceReference[] getRegisteredServices() {
        this.checkValid();
        return null;
    }

    public ServiceReference[] getServicesInUse() {
        this.checkValid();
        return null;
    }

    protected BundleLoaderProxy[] getHosts() {
        return this.hosts;
    }

    protected boolean isFragment() {
        return true;
    }

    protected boolean addHost(BundleLoaderProxy bundleLoaderProxy) {
        if (bundleLoaderProxy == null) {
            return false;
        }
        try {
            ((BundleHost)bundleLoaderProxy.getBundleHost()).attachFragment(this);
        }
        catch (BundleException bundleException) {
            this.framework.publishFrameworkEvent(2, bundleLoaderProxy.getBundleHost(), bundleException);
            return false;
        }
        if (this.hosts == null) {
            this.hosts = new BundleLoaderProxy[]{bundleLoaderProxy};
            return true;
        }
        int n = 0;
        while (n < this.hosts.length) {
            if (bundleLoaderProxy.getBundleHost() == this.hosts[n].getBundleHost()) {
                return true;
            }
            ++n;
        }
        BundleLoaderProxy[] bundleLoaderProxyArray = new BundleLoaderProxy[this.hosts.length + 1];
        System.arraycopy(this.hosts, 0, bundleLoaderProxyArray, 0, this.hosts.length);
        bundleLoaderProxyArray[bundleLoaderProxyArray.length - 1] = bundleLoaderProxy;
        this.hosts = bundleLoaderProxyArray;
        return true;
    }

    protected BundleLoader getBundleLoader() {
        return null;
    }

    protected BundleContextImpl getContext() {
        return null;
    }
}

