/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.OS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.InternalGCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.RGBUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    protected Composite internal_parent;
    Object layoutData;
    String toolTipText;
    Menu menu;
    Font font;
    Color foregroundColor;
    Color backgroundColor;
    private int swtKeycode;
    protected boolean enableTraverse = false;
    boolean enabled = true;
    boolean visible = true;

    Control() {
    }

    public Control(Composite parent, int style) {
        super(parent, style);
        this.internal_parent = parent;
        this.createWidget(0);
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void dispose() {
        if (this.visible) {
            this.setVisible(false);
        }
        super.dispose();
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(5, typedListener);
    }

    public void addPaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(9, typedListener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(31, typedListener);
    }

    boolean causesTraversal(int detail) {
        return true;
    }

    void checkOrientation(Widget parent) {
        super.checkOrientation(parent);
        if ((this.internal_style & 0x4000000) != 0) {
            this.internal_style |= 0x8000000;
        }
    }

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (wHint == -1 || hHint == -1) {
            int[] pointArray = OS.Control_GetMinimumSize(this.internal_handle);
            width = pointArray[0];
            height = pointArray[1];
        }
        if (wHint != -1) {
            width = wHint + 2 * this.getBorderWidth();
        }
        if (hHint != -1) {
            height = hHint + 2 * this.getBorderWidth();
        }
        return new Point(width, height);
    }

    Control computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.internal_parent.computeTabGroup();
    }

    Control computeTabRoot() {
        Control[] tabList = this.internal_parent._getTabList();
        if (tabList != null) {
            int index;
            for (index = 0; index < tabList.length && tabList[index] != this; ++index) {
            }
            if (index == tabList.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.internal_parent.computeTabRoot();
    }

    Control[] computeTabList() {
        if (this.isTabGroup() && this.isVisible() && this.getEnabled()) {
            return new Control[]{this};
        }
        return new Control[0];
    }

    Rectangle computeTrim(int x, int y, int width, int height) {
        return new Rectangle(0, 0, 0, 0);
    }

    void createWidget(int index) {
        this.checkOrientation(this.internal_parent);
        super.createWidget(index);
        this.backgroundColor = null;
        this.foregroundColor = null;
        OS.Control_SetVisible(this.internal_handle, this.visible);
    }

    Font defaultFont() {
        return this.getDisplay().getSystemFont();
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (!(this.getVisible() && this.getEnabled())) {
            return false;
        }
        boolean result = OS.Control_ForceFocus(this.internal_handle);
        if (result) {
            this.display.setFocusControl(this);
        }
        if (this.isDisposed()) {
            return false;
        }
        this.getShell().setSavedFocus(this);
        return result;
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.backgroundColor != null) {
            return this.backgroundColor;
        }
        int rgb = OS.Control_GetBackgroundRGB(this.internal_handle);
        RGB rgbObject = RGBUtils.fromRGBInt(rgb);
        this.backgroundColor = new Color(this.getDisplay(), rgbObject);
        return this.backgroundColor;
    }

    public int getBorderWidth() {
        this.checkWidget();
        return OS.Control_GetBorderWidth(this.internal_handle);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int[] rect = OS.Control_GetBounds(this.internal_handle);
        return new Rectangle(rect[0], rect[1], rect[2], rect[3]);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return this.enabled;
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        return this.getDisplay().getSystemFont();
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.foregroundColor != null) {
            return this.foregroundColor;
        }
        int rgb = OS.Control_GetForegroundRGB(this.internal_handle);
        RGB rgbObject = RGBUtils.fromRGBInt(rgb);
        this.foregroundColor = new Color(this.getDisplay(), rgbObject);
        return this.foregroundColor;
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Point getLocation() {
        this.checkWidget();
        int[] rect = OS.Control_GetBounds(this.internal_handle);
        return new Point(rect[0], rect[1]);
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    protected int internal_getNativeStyle() {
        int nativeStyle = 0;
        if ((this.internal_style & 0x800) == 2048) {
            nativeStyle |= 0x800;
        }
        if ((this.internal_style & 0x2000000) == 0x2000000) {
            nativeStyle |= 0x4000;
        }
        if ((this.internal_style & 0x4000000) == 0x4000000) {
            nativeStyle |= 0x8000;
        }
        return nativeStyle;
    }

    public Composite getParent() {
        this.checkWidget();
        return this.internal_parent;
    }

    public Shell getShell() {
        this.checkWidget();
        if (this.internal_parent == null) {
            return null;
        }
        return this.internal_parent.getShell();
    }

    public Point getSize() {
        this.checkWidget();
        int[] rect = OS.Control_GetBounds(this.internal_handle);
        return new Point(rect[2], rect[3]);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.visible;
    }

    boolean hasFocus() {
        return this == this.getDisplay().getFocusControl();
    }

    int hasMenuCallback(int x, int y) {
        if (this.menu != null || this.hooks(35)) {
            return 1;
        }
        return 2;
    }

    boolean hideEvent(int eventPtr) {
        return false;
    }

    public void internal_copyArea(int imageHandle, int x, int y, int width, int height) {
        OS.Control_CopyArea(this.internal_handle, imageHandle, x, y, width, height);
    }

    public void internal_dispose_GC(int painter, InternalGCData data) {
        data.background = null;
        data.background = null;
    }

    public Rectangle internal_getBounds() {
        return this.getBounds();
    }

    public Rectangle internal_getDefaultClipping() {
        Rectangle bounds = this.getBounds();
        int[] insets = OS.Scrollable_GetInsets(this.internal_handle);
        int width = bounds.width - insets[0] - insets[2];
        int height = bounds.height - insets[1] - insets[3];
        return new Rectangle(0, 0, width, height);
    }

    public int internal_new_GC(InternalGCData data) {
        this.checkWidget();
        int graphics = OS.Control_NewGraphics(this.internal_handle);
        data.device = this.getDisplay();
        data.foreground = this.getForeground();
        data.background = this.getBackground();
        data.font = this.getFont();
        return graphics;
    }

    public boolean isEnabled() {
        this.checkWidget();
        boolean parentEnabled = true;
        if (this.internal_parent != null) {
            parentEnabled = this.internal_parent.isEnabled();
        }
        return this.getEnabled() && parentEnabled;
    }

    public boolean isFocusControl() {
        this.checkWidget();
        return this.hasFocus();
    }

    public boolean isReparentable() {
        return OS.Control_IsReparentable(this.internal_handle);
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            Point size = control.getSize();
            if (size.x == 1 || size.y == 1) {
                return false;
            }
            control = control.internal_parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int code;
        Control[] tabList;
        if (!this.enabled) {
            return false;
        }
        Control[] controlArray = tabList = this.internal_parent != null ? this.internal_parent._getTabList() : null;
        if (tabList != null) {
            for (int i = 0; i < tabList.length; ++i) {
                if (tabList[i] != this) continue;
                return true;
            }
        }
        if (((code = this.traversalCode()) & 0x60) != 0) {
            return false;
        }
        return (code & 0x18) != 0;
    }

    boolean isTabItem() {
        int code;
        Control[] tabList = this.internal_parent._getTabList();
        if (tabList != null) {
            for (int i = 0; i < tabList.length; ++i) {
                if (tabList[i] != this) continue;
                return false;
            }
        }
        return ((code = this.traversalCode()) & 0x60) != 0;
    }

    public boolean isVisible() {
        this.checkWidget();
        boolean result = this.getVisible();
        if (this.internal_parent != null) {
            result = result && this.internal_parent.isVisible();
        }
        return result;
    }

    Decorations menuShell() {
        return this.internal_parent.menuShell();
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                Control.error(5);
            }
            if (this.internal_parent != control.internal_parent) {
                return;
            }
        }
        OS.Control_MoveAbove(this.internal_handle, control == null ? 0 : control.internal_handle);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                Control.error(5);
            }
            if (this.internal_parent != control.internal_parent) {
                return;
            }
        }
        OS.Control_MoveBelow(this.internal_handle, control == null ? 0 : control.internal_handle);
    }

    boolean moveEvent(int eventPtr) {
        return false;
    }

    public void pack() {
        this.pack(true);
    }

    public void pack(boolean changed) {
        this.checkWidget();
        this.setSize(this.computeSize(-1, -1, changed));
    }

    public void redraw() {
        this.checkWidget();
        OS.Control_Redraw(this.internal_handle);
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        OS.Control_RedrawRegion(this.internal_handle, x, y, width, height);
    }

    void releaseWidget() {
        if (this.internal_parent != null) {
            this.internal_parent.internal_removeChild(this);
        }
        if (this.foregroundColor != null && !this.foregroundColor.isDisposed()) {
            this.foregroundColor.dispose();
        }
        this.foregroundColor = null;
        if (this.backgroundColor != null && !this.backgroundColor.isDisposed()) {
            this.backgroundColor.dispose();
        }
        this.backgroundColor = null;
        this.internal_parent = null;
        this.toolTipText = null;
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.releaseResources();
        }
        this.menu = null;
        super.releaseWidget();
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, listener);
        this.eventTable.unhook(16, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener);
        this.eventTable.unhook(1, listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, listener);
        this.eventTable.unhook(4, listener);
        this.eventTable.unhook(8, listener);
    }

    public void removeMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, listener);
    }

    boolean resizeEvent(int eventPtr) {
        return false;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color == null) {
            OS.Control_SetBackground(this.internal_handle, 0);
        } else {
            if (this.backgroundColor == color) {
                return;
            }
            OS.Control_SetBackground(this.internal_handle, color.internal_handle);
        }
        if (this.backgroundColor != null && !this.backgroundColor.isDisposed()) {
            this.backgroundColor.dispose();
        }
        this.backgroundColor = null;
    }

    public void setBackgroundImage(Image image) {
        throw new RuntimeException("Not Supported");
    }

    public void setBounds(int x, int y, int width, int height) {
        boolean sameExtent;
        this.checkWidget();
        int[] rect = OS.Control_GetBounds(this.internal_handle);
        boolean sameOrigin = x == rect[0] && y == rect[1];
        boolean bl = sameExtent = width == rect[2] && height == rect[3];
        if (sameOrigin && sameExtent) {
            return;
        }
        OS.Control_SetBounds(this.internal_handle, x, y, width, height);
        if (!sameOrigin) {
            this.internal_sendEvent(10);
        }
        if (!sameExtent) {
            this.internal_sendEvent(11);
        }
    }

    public void setBounds(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public void setCapture(boolean capture) {
        this.checkWidget();
        OS.Control_SetPointerCapture(this.internal_handle, capture);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.enabled = enabled;
        OS.Control_SetEnabled(this.internal_handle, enabled);
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.internal_style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setFont(Font font) {
        this.checkWidget();
        int fontHandle = 0;
        if (font != null) {
            if (font.isDisposed()) {
                SWT.error(5);
            }
            fontHandle = font.internal_handle;
        }
        if (fontHandle == 0) {
            fontHandle = this.defaultFont().internal_handle;
            font = null;
        }
        this.font = font;
        OS.Control_SetFont(this.internal_handle, fontHandle);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color == null) {
            OS.Control_SetForeground(this.internal_handle, 0);
        } else {
            if (this.foregroundColor == color) {
                return;
            }
            OS.Control_SetForeground(this.internal_handle, color.internal_handle);
        }
        if (this.foregroundColor != null && !this.foregroundColor.isDisposed()) {
            this.foregroundColor.dispose();
        }
        this.foregroundColor = null;
    }

    public void setLayoutData(Object layoutData) {
        this.checkWidget();
        this.layoutData = layoutData;
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        int[] rect = OS.Control_GetBounds(this.internal_handle);
        int oldX = rect[0];
        int oldY = rect[1];
        if (x != oldX || y != oldY) {
            OS.Control_SetBounds(this.internal_handle, x, y, rect[2], rect[3]);
            this.internal_sendEvent(10);
        }
    }

    public void setLocation(Point location) {
        if (location == null) {
            SWT.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                SWT.error(5);
            }
            if ((menu.internal_style & 8) == 0) {
                Control.error(37);
            }
            if (menu.parent != this.menuShell()) {
                Control.error(32);
            }
        }
        this.menu = menu;
    }

    public boolean setParent(Composite newParent) {
        this.checkWidget();
        if (this.internal_parent == null) {
            Control.error(4);
        }
        if (this.internal_parent.isDisposed()) {
            SWT.error(5);
        }
        if (this.internal_parent == newParent) {
            return true;
        }
        boolean result = OS.Control_SetParent(this.internal_handle, newParent.internal_handle);
        if (result) {
            Shell newShell;
            Shell oldShell;
            if (this.menu != null && (oldShell = this.getShell()) != (newShell = newParent.getShell())) {
                this.menu.fixMenus(newShell);
            }
            this.internal_parent.internal_removeChild(this);
            this.internal_parent = newParent;
            newParent.addChild(this);
            OS.Control_MoveBelow(this.internal_handle, 0);
        }
        return result;
    }

    boolean setRadioSelection(boolean value) {
        return false;
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        OS.Control_SetRedraw(this.internal_handle, redraw);
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        int[] rect = OS.Control_GetBounds(this.internal_handle);
        if (width != rect[2] || height != rect[3]) {
            OS.Control_SetBounds(this.internal_handle, rect[0], rect[1], width, height);
            this.internal_sendEvent(11);
        }
    }

    public void setSize(Point size) {
        if (size == null) {
            SWT.error(4);
        }
        this.setSize(size.x, size.y);
    }

    boolean setTabGroupFocus() {
        return this.setTabItemFocus();
    }

    boolean setTabItemFocus() {
        if (!this.isShowing()) {
            return false;
        }
        return this.setFocus();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        this.visible = visible;
        OS.Control_SetVisible(this.internal_handle, visible);
        if (visible) {
            this.internal_sendEvent(22);
        } else {
            this.internal_sendEvent(23);
        }
    }

    boolean showEvent(int eventPtr) {
        return false;
    }

    public Point toControl(int x, int y) {
        this.checkWidget();
        Control control = this;
        Point controlPoint = new Point(x, y);
        while (control != null) {
            Point location = control.getLocation();
            Rectangle trim = control.computeTrim(0, 0, 0, 0);
            location.x -= trim.x;
            location.y -= trim.y;
            controlPoint.x -= location.x;
            controlPoint.y -= location.y;
            control = control.internal_parent;
        }
        return controlPoint;
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            Control.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int x, int y) {
        this.checkWidget();
        Control control = this;
        Point displayPoint = new Point(x, y);
        while (control != null) {
            Point location = control.getLocation();
            Rectangle trim = control.computeTrim(0, 0, 0, 0);
            location.x -= trim.x;
            location.y -= trim.y;
            displayPoint.x += location.x;
            displayPoint.y += location.y;
            control = control.internal_parent;
        }
        return displayPoint;
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            Control.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    int traversalCode() {
        int code = 28;
        Shell shell = this.getShell();
        if (shell.internal_parent != null) {
            code |= 2;
        }
        return code;
    }

    protected boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return false;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event.character);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    protected boolean traverseByArrowKey(Event event) {
        switch (event.keyCode) {
            case 0x1000001: 
            case 0x1000003: {
                this.sendEvent(31, event);
                if (!event.doit) {
                    return true;
                }
                return this.traverseGroup(false);
            }
            case 0x1000002: 
            case 0x1000004: {
                this.sendEvent(31, event);
                if (!event.doit) {
                    return true;
                }
                return this.traverseGroup(true);
            }
        }
        return this.traverse(event);
    }

    public boolean traverse(int traversal) {
        this.checkWidget();
        if (!this.isFocusControl() && !this.setFocus()) {
            return false;
        }
        Event event = new Event();
        event.doit = true;
        event.detail = traversal;
        event.keyCode = this.swtKeycode;
        return this.traverse(event);
    }

    boolean traverseEscape() {
        return false;
    }

    protected boolean traverseGroup(boolean next) {
        int offset;
        int index;
        Control root = this.computeTabRoot();
        Control group = this.computeTabGroup();
        Control[] list = root.computeTabList();
        int length = list.length;
        for (index = 0; index < length && list[index] != group; ++index) {
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int n = offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control control = list[index];
            if (control.isDisposed() || !control.setTabGroupFocus() || this.isDisposed() || this.isFocusControl()) continue;
            return true;
        }
        if (group.isDisposed()) {
            return false;
        }
        return group.setTabGroupFocus();
    }

    boolean traverseItem(boolean next) {
        int offset;
        int index;
        Control[] children = this.internal_parent.getChildren();
        int length = children.length;
        for (index = 0; index < length && children[index] != this; ++index) {
        }
        int start = index;
        int n = offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control child = children[index];
            if (child.isDisposed() || !child.isTabItem() || !child.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traversePage(boolean next) {
        return false;
    }

    boolean traverseMnemonic(char key) {
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    public void update() {
        this.checkWidget();
        this.update(false);
    }

    void update(boolean all) {
        OS.Control_Update(this.internal_handle, all);
    }

    int computeTabTraversal(int modifiers) {
        return (modifiers & 2) != 0 ? 8 : 16;
    }

    String verifyText(String string, int start, int end, Event keyEvent) {
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        if (keyEvent != null) {
            event.character = keyEvent.character;
            event.keyCode = keyEvent.keyCode;
            event.stateMask = keyEvent.stateMask;
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }

    boolean textVerifyCallback(String originalText, int start, int end, String[] returnedText) {
        String modifiedText = this.verifyText(originalText, start, end, null);
        if (modifiedText == null) {
            return true;
        }
        if (returnedText == null || returnedText.length == 0) {
            SWT.error(5);
        }
        returnedText[0] = modifiedText == originalText ? null : modifiedText;
        return false;
    }

    boolean keyCallback(int type, char character, int keycode, int modifiers) {
        char swtCharacter = character;
        int traversal = 0;
        this.swtKeycode = Display.convertToSwtKeyCode(keycode);
        if (this.swtKeycode == 0) {
            this.swtKeycode = keycode;
        }
        switch (keycode) {
            case 1001: {
                traversal = this.computeTabTraversal(modifiers);
                break;
            }
            case 1002: {
                traversal = 4;
                if (type != 2) break;
                this.enableTraverse = !this.enableTraverse;
                break;
            }
            case 1003: {
                traversal = 2;
                break;
            }
            case 1009: {
                traversal = (modifiers & 4) != 0 ? 256 : 0;
                break;
            }
            case 1010: {
                traversal = (modifiers & 4) != 0 ? 512 : 0;
                break;
            }
            case 1013: {
                traversal = 32;
                break;
            }
            case 1014: {
                traversal = 64;
                break;
            }
            case 1015: {
                traversal = 32;
                break;
            }
            case 1016: {
                traversal = 64;
            }
        }
        if (traversal != 0 && type == 1 && this.traverse(traversal)) {
            return true;
        }
        int swtModifiers = Control.convertToSWTModifiers(modifiers);
        Event event = new Event();
        event.character = swtCharacter;
        event.keyCode = this.swtKeycode;
        event.stateMask = swtModifiers;
        switch (type) {
            case 1: {
                this.sendEvent(1, event);
                break;
            }
            case 2: {
                this.sendEvent(2, event);
            }
        }
        return !event.doit;
    }

    private static int convertToSWTModifiers(int modifiers) {
        int rc = 0;
        if ((modifiers & 1) != 0) {
            rc |= 0x10000;
        }
        if ((modifiers & 2) != 0) {
            rc |= 0x20000;
        }
        if ((modifiers & 4) != 0) {
            rc |= 0x40000;
        }
        if ((modifiers & 8) != 0) {
            rc |= 0x80000;
        }
        if ((modifiers & 0x10) != 0) {
            rc |= 0x100000;
        }
        if ((modifiers & 0x20) != 0) {
            rc |= 0x200000;
        }
        return rc;
    }

    void paintCallback(int x, int y, int width, int height) {
        Event event = new Event();
        event.gc = new GC(this);
        event.x = x;
        event.y = y;
        event.width = width;
        event.height = height;
        this.sendEvent(9, event);
        event.gc.dispose();
        event.gc = null;
    }

    void pointerCallback(int type, int x, int y, int buttonState, int modifiers) {
        Event event = new Event();
        event.x = x;
        event.y = y;
        event.button = 0;
        event.stateMask = 0;
        if ((buttonState & 8) != 0) {
            event.button = 1;
        }
        if ((buttonState & 0x10) != 0) {
            event.button = 2;
        }
        if ((buttonState & 0x20) != 0) {
            event.button = 3;
        }
        if ((modifiers & 0x40) != 0) {
            Point p = this.getDisplay().map(this, null, x, y);
            Event e = new Event();
            e.x = p.x;
            e.y = p.y;
            this.sendEvent(35, e);
            if (e.doit && this.menu != null) {
                this.menu.setLocation(p);
                this.menu.setVisible(true);
            }
        }
        event.stateMask |= Control.convertToSWTModifiers(modifiers);
        switch (type) {
            case 1: {
                this.sendEvent(3, event);
                break;
            }
            case 2: {
                this.sendEvent(4, event);
                break;
            }
            case 3: {
                this.sendEvent(5, event);
                break;
            }
            case 6: {
                this.sendEvent(5, event);
                break;
            }
            case 7: {
                this.sendEvent(8, event);
            }
        }
    }

    void focusCallback(int type) {
        switch (type) {
            case 1: {
                this.getDisplay().setFocusControl(this);
                this.internal_sendEvent(15);
                this.enableTraverse = false;
                break;
            }
            case 2: {
                this.internal_sendEvent(16);
            }
        }
    }

    public boolean isEnableTraverse() {
        return this.enableTraverse;
    }

    public boolean allowTraverseByArrowKey(Event event) {
        return false;
    }

    boolean setSavedFocus() {
        return this.setFocus();
    }
}

