/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.io;

import java.io.IOException;
import org.eclipse.ercp.xml.io.SimpleBufferedInputStream;
import org.eclipse.ercp.xml.io.StreamDecoder;

public class StreamDecoder_ASCII
extends StreamDecoder {
    public StreamDecoder_ASCII(SimpleBufferedInputStream stream) {
        super(stream, "ASCII");
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public int read() throws IOException {
        int c = this.stream.read();
        if (c == -1) {
            return -1;
        }
        int data = c;
        return data <= 127 ? data : 65533;
    }

    public int read(char[] buf, int offset, int count) throws IOException {
        byte[] bytes = new byte[count];
        int available = this.stream.read(bytes, 0, count);
        int charOffset = offset;
        int i = 0;
        while (i < available) {
            int data = bytes[i];
            buf[charOffset++] = data <= 127 ? data : 65533;
            ++i;
        }
        return available;
    }
}

