/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.util.Assert;

public class PreferenceManager {
    public static final int PRE_ORDER = 0;
    public static final int POST_ORDER = 1;
    PreferenceNode root = new PreferenceNode("");
    String separator = ".";

    protected IPreferenceNode getRoot() {
        return this.root;
    }

    public void addToRoot(IPreferenceNode node) {
        Assert.isNotNull(node);
        this.root.add(node);
    }

    public boolean addTo(String path, IPreferenceNode node) {
        IPreferenceNode target = this.find(path);
        if (target == null) {
            return false;
        }
        target.add(node);
        return true;
    }

    public boolean remove(IPreferenceNode node) {
        Assert.isNotNull(node);
        return this.root.remove(node);
    }

    public void removeAll() {
        this.root = new PreferenceNode("");
    }

    protected void buildSequence(IPreferenceNode node, List sequence, int order) {
        if (order == 0) {
            sequence.add(node);
        }
        IPreferenceNode[] subnodes = node.getSubNodes();
        int i = 0;
        while (i < subnodes.length) {
            this.buildSequence(subnodes[i], sequence, order);
            ++i;
        }
        if (order == 1) {
            sequence.add(node);
        }
    }

    public List getElements(int order) {
        Assert.isTrue(order == 0 || order == 1, "invalid traversal order");
        ArrayList sequence = new ArrayList();
        IPreferenceNode[] subnodes = this.getRoot().getSubNodes();
        int i = 0;
        while (i < subnodes.length) {
            this.buildSequence(subnodes[i], sequence, order);
            ++i;
        }
        return sequence;
    }

    public List getRootElements() {
        ArrayList<IPreferenceNode> sequence = new ArrayList<IPreferenceNode>();
        IPreferenceNode[] subnodes = this.getRoot().getSubNodes();
        int i = 0;
        while (i < subnodes.length) {
            sequence.add(subnodes[i]);
            ++i;
        }
        return sequence;
    }

    public IPreferenceNode find(String path) {
        return this.find(path, this.root);
    }

    protected IPreferenceNode find(String path, IPreferenceNode top) {
        Assert.isNotNull(path);
        StringTokenizer stok = new StringTokenizer(path, this.separator);
        IPreferenceNode node = top;
        while (stok.hasMoreTokens()) {
            String id = stok.nextToken();
            if ((node = node.findSubNode(id)) != null) continue;
            return null;
        }
        if (node == top) {
            return null;
        }
        return node;
    }
}

