/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.util;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class StatusLineContributionItem
extends ContributionItem {
    public static final int DEFAULT_CHAR_WIDTH = 40;
    private int charWidth;
    private Label label;
    private Composite statusLine = null;
    private String text = "";
    private int widthHint = -1;
    private int heightHint = -1;

    public StatusLineContributionItem(String string) {
        this(string, 40);
    }

    public StatusLineContributionItem(String string, int n) {
        super(string);
        this.charWidth = n;
        this.setVisible(false);
    }

    public void fill(Composite composite) {
        StatusLineLayoutData statusLineLayoutData;
        this.statusLine = composite;
        Label label = new Label(composite, 2);
        this.label = new Label(this.statusLine, 32);
        if (this.widthHint < 0) {
            statusLineLayoutData = new GC((Drawable)this.statusLine);
            statusLineLayoutData.setFont(this.statusLine.getFont());
            FontMetrics fontMetrics = statusLineLayoutData.getFontMetrics();
            this.widthHint = fontMetrics.getAverageCharWidth() * this.charWidth;
            this.heightHint = fontMetrics.getHeight();
            statusLineLayoutData.dispose();
        }
        statusLineLayoutData = new StatusLineLayoutData();
        statusLineLayoutData.widthHint = this.widthHint;
        this.label.setLayoutData((Object)statusLineLayoutData);
        this.label.setText(this.text);
        statusLineLayoutData = new StatusLineLayoutData();
        statusLineLayoutData.heightHint = this.heightHint;
        label.setLayoutData((Object)statusLineLayoutData);
    }

    public Point getDisplayLocation() {
        if (this.label != null && this.statusLine != null) {
            return this.statusLine.toDisplay(this.label.getLocation());
        }
        return null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.text = string;
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setText(this.text);
        }
        if (this.text.length() == 0) {
            if (this.isVisible()) {
                this.setVisible(false);
                IContributionManager iContributionManager = this.getParent();
                if (iContributionManager != null) {
                    iContributionManager.update(true);
                }
            }
        } else if (!this.isVisible()) {
            this.setVisible(true);
            IContributionManager iContributionManager = this.getParent();
            if (iContributionManager != null) {
                iContributionManager.update(true);
            }
        }
    }
}

