/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.eworkbench;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ercp.eworkbench.ApplicationDescriptor;
import org.eclipse.ercp.eworkbench.ApplicationRegistry;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.RegistryReader;

public class ApplicationRegistryReader
extends RegistryReader {
    private static final String TAG_APPLICATION = "application";
    private static final String TAG_VIEWS = "views";
    public static final String ATT_LARGE = "large";
    public static final String ATT_NORMAL = "normal";
    public static final String ATT_STATUS = "status";
    private ApplicationRegistry registry;

    public ApplicationRegistryReader(ApplicationRegistry applicationRegistry) {
        this.registry = applicationRegistry;
    }

    protected boolean readElement(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement.getName().equals(TAG_APPLICATION)) {
            try {
                ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor(iConfigurationElement.getAttribute("id"), iConfigurationElement);
                IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
                int n = 0;
                while (n < iConfigurationElementArray.length) {
                    if (iConfigurationElementArray[n].getName().equals(TAG_VIEWS)) {
                        String string = iConfigurationElementArray[n].getAttribute(ATT_NORMAL);
                        if (string != null) {
                            applicationDescriptor.setViewId(ATT_NORMAL, string);
                        } else {
                            WorkbenchPlugin.log((String)"Unable to find normal view in application descriptor.");
                        }
                        string = iConfigurationElementArray[n].getAttribute(ATT_LARGE);
                        if (string != null) {
                            applicationDescriptor.setViewId(ATT_LARGE, string);
                        }
                        if ((string = iConfigurationElementArray[n].getAttribute(ATT_STATUS)) != null) {
                            applicationDescriptor.setViewId(ATT_STATUS, string);
                        }
                    }
                    ++n;
                }
                this.registry.addApplication(applicationDescriptor);
            }
            catch (CoreException coreException) {
                WorkbenchPlugin.log((String)"Unable to create application descriptor.", (IStatus)coreException.getStatus());
            }
            return true;
        }
        return false;
    }

    public void readApplications(IExtensionRegistry iExtensionRegistry) {
        this.readRegistry(iExtensionRegistry, "org.eclipse.ercp.eworkbench", "applications");
    }
}

