/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.IArchiveReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteContentProvider;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;

public abstract class SiteContentProvider
implements ISiteContentProvider {
    private URL base;
    private ISite site;

    public SiteContentProvider(URL uRL) {
        this.base = uRL;
    }

    public URL getURL() {
        return this.base;
    }

    private URL getArchiveReference1(String string) throws CoreException {
        try {
            return new URL(this.getURL(), string);
        }
        catch (MalformedURLException malformedURLException) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.SiteContentProvider_ErrorCreatingURLForArchiveID, (Object[])new String[]{string, this.getURL().toExternalForm()}), malformedURLException);
        }
    }

    public ISite getSite() {
        return this.site;
    }

    public void setSite(ISite iSite) {
        this.site = iSite;
    }

    public URL getArchiveReference(String string) throws CoreException {
        URL uRL = null;
        uRL = this.getArchiveURLfor(string);
        if (uRL == null) {
            return this.getArchiveReference1(string);
        }
        return uRL;
    }

    private URL getArchiveURLfor(String string) {
        URL uRL = null;
        boolean bl = false;
        IArchiveReference[] iArchiveReferenceArray = this.getSite().getArchives();
        if (iArchiveReferenceArray.length > 0) {
            int n = 0;
            while (n < iArchiveReferenceArray.length && !bl) {
                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_INSTALL) {
                    UpdateCore.debug("GetArchiveURL for:" + string + " compare to " + iArchiveReferenceArray[n].getPath());
                }
                if (string.trim().equalsIgnoreCase(iArchiveReferenceArray[n].getPath())) {
                    uRL = iArchiveReferenceArray[n].getURL();
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return uRL;
    }
}

