/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ercp.swt.mobile.OS;
import org.eclipse.ercp.swt.mobile.ScreenEvent;
import org.eclipse.ercp.swt.mobile.ScreenListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Platform;
import org.eclipse.swt.widgets.Display;

public class Screen {
    private static int rotDetectDisplay_handle = 0;
    private List eventListeners;
    private static boolean eventsRegistered;
    public static final int PRIMARY = 1;
    public static final int SECONDARY = 2;
    public static final int STATUS = 3;
    public static final int PORTRAIT = 0;
    public static final int LANDSCAPE = 1;

    Screen() {
        if (!eventsRegistered) {
            com.ibm.ugl.p3ml.OS.Display_RegisterCallback(Display.getDefault().internal_handle, 34, "org/eclipse/ercp/swt/mobile/Screen", "rotationCallBack");
            eventsRegistered = true;
        }
    }

    public void addEventListener(ScreenListener listener) {
        if (listener == null) {
            SWT.error(4);
        }
        if (Platform.isWin32()) {
            return;
        }
        if (this.eventListeners == null) {
            this.eventListeners = new ArrayList();
            rotDetectDisplay_handle = OS.RotDetectDisplay_New(Display.getDefault().internal_handle);
            com.ibm.ugl.p3ml.OS.Widget_SetData(rotDetectDisplay_handle, this);
        }
        this.eventListeners.add(listener);
    }

    public Rectangle getBounds() {
        int[] res = OS.Screen_GetRes();
        return new Rectangle(0, 0, res[0], res[1]);
    }

    public int getColorDepth() {
        return OS.Screen_GetColorDepth();
    }

    public int getLocation() {
        return 0;
    }

    public int getOrientation() {
        return OS.Screen_GetOrientation();
    }

    public int getUsage() {
        return 1;
    }

    public boolean isActive() {
        return true;
    }

    public boolean isTouchScreen() {
        return true;
    }

    public void removeEventListener(ScreenListener listener) {
        if (listener == null) {
            SWT.error(4);
        }
        if (Platform.isWin32()) {
            return;
        }
        if (this.eventListeners == null) {
            return;
        }
        this.eventListeners.remove(listener);
        if (this.eventListeners.isEmpty()) {
            com.ibm.ugl.p3ml.OS.Widget_SetData(rotDetectDisplay_handle, null);
            com.ibm.ugl.p3ml.OS.Widget_Dispose(rotDetectDisplay_handle);
            this.eventListeners = null;
        }
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            SWT.error(5);
        }
        OS.Screen_SetOrientation(orientation);
    }

    private void rotationCallBack(int value) {
        if (this.eventListeners != null) {
            ScreenEvent event = new ScreenEvent(this);
            event.isActive = true;
            event.orientation = value;
            event.time = (int)System.currentTimeMillis() & Integer.MAX_VALUE;
            int listenerCount = this.eventListeners.size();
            for (int i = 0; i < listenerCount; ++i) {
                ScreenListener listener = (ScreenListener)this.eventListeners.get(i);
                listener.screenOrientationChanged(event);
            }
        }
    }
}

