/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.LayoutPartSash;
import org.eclipse.ui.internal.LayoutTree;
import org.eclipse.ui.internal.LayoutTreeNode;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.dnd.SwtUtil;

public abstract class PartSashContainer
extends LayoutPart
implements ILayoutContainer {
    protected Composite parent;
    protected ControlListener resizeListener;
    protected LayoutTree root;
    private LayoutPart zoomedPart;
    protected WorkbenchPage page;
    boolean active = false;
    boolean layoutDirty = false;
    protected ArrayList children = new ArrayList();

    public PartSashContainer(String string, WorkbenchPage workbenchPage) {
        super(string);
        this.page = workbenchPage;
        this.resizeListener = new ControlListener(){

            public void controlResized(ControlEvent controlEvent) {
                PartSashContainer.this.resizeSashes();
            }

            public void controlMoved(ControlEvent controlEvent) {
            }
        };
    }

    public boolean childObscuredByZoom(LayoutPart layoutPart) {
        LayoutPart layoutPart2 = this.getZoomedPart();
        if (layoutPart2 != null && layoutPart != layoutPart2) {
            return true;
        }
        return this.isObscuredByZoom();
    }

    private PartPane[] getVisibleParts(LayoutPart layoutPart) {
        if (layoutPart instanceof PartPane) {
            return new PartPane[]{(PartPane)layoutPart};
        }
        if (layoutPart instanceof PartStack) {
            PartStack partStack = (PartStack)layoutPart;
            LayoutPart[] layoutPartArray = partStack.getChildren();
            ArrayList<LayoutPart> arrayList = new ArrayList<LayoutPart>(layoutPartArray.length);
            int n = 0;
            while (n < layoutPartArray.length) {
                LayoutPart layoutPart2 = layoutPartArray[n];
                if (layoutPart2 instanceof PartPane) {
                    arrayList.add(layoutPart2);
                }
                ++n;
            }
            return arrayList.toArray(new PartPane[arrayList.size()]);
        }
        return new PartPane[0];
    }

    public void add(LayoutPart layoutPart) {
        if (layoutPart == null) {
            return;
        }
        this.addEnhanced(layoutPart, 131072, 0.5f, this.findBottomRight());
    }

    void addEnhanced(LayoutPart layoutPart, int n, float f, LayoutPart layoutPart2) {
        this.add(layoutPart, n, f, layoutPart2);
    }

    public void add(LayoutPart layoutPart, int n, float f, LayoutPart layoutPart2) {
        Rectangle rectangle;
        boolean bl = n == 1 || n == 2;
        LayoutTree layoutTree = null;
        if (this.root != null && layoutPart2 != null) {
            layoutTree = this.root.find(layoutPart2);
        }
        if (this.getParent() == null) {
            Composite composite = this.getPage().getClientComposite();
            rectangle = composite != null && !composite.isDisposed() ? composite.getBounds() : new Rectangle(0, 0, 800, 600);
            rectangle.x = 0;
            rectangle.y = 0;
        } else {
            rectangle = this.getBounds();
        }
        int n2 = PartSashContainer.measureTree(rectangle, layoutTree, bl);
        int n3 = (int)((float)n2 * f);
        int n4 = n2 - n3;
        this.add(layoutPart, n, n3, n4, layoutPart2);
    }

    static int measureTree(Rectangle rectangle, LayoutTree layoutTree, boolean bl) {
        if (layoutTree == null) {
            return Geometry.getDimension((Rectangle)rectangle, (boolean)bl);
        }
        LayoutTreeNode layoutTreeNode = layoutTree.getParent();
        if (layoutTreeNode == null) {
            return Geometry.getDimension((Rectangle)rectangle, (boolean)bl);
        }
        if (layoutTreeNode.getSash().isHorizontal() == bl) {
            return PartSashContainer.measureTree(rectangle, layoutTreeNode, bl);
        }
        boolean bl2 = layoutTreeNode.isLeftChild(layoutTree);
        LayoutTree layoutTree2 = layoutTreeNode.getChild(!bl2);
        if (layoutTree2.isVisible()) {
            int n = layoutTreeNode.getSash().getLeft();
            int n2 = layoutTreeNode.getSash().getRight();
            int n3 = bl2 ? n : n2;
            int n4 = layoutTreeNode.getCompressionBias();
            if (bl2) {
                n4 = -n4;
            }
            if (n4 == 1) {
                return n3;
            }
            if (n4 == -1) {
                return PartSashContainer.measureTree(rectangle, layoutTreeNode, bl) - (n + n2 - n3);
            }
            return PartSashContainer.measureTree(rectangle, layoutTreeNode, bl) * n3 / (n + n2);
        }
        return PartSashContainer.measureTree(rectangle, layoutTreeNode, bl);
    }

    protected void addChild(RelationshipInfo relationshipInfo) {
        LayoutPart layoutPart = relationshipInfo.part;
        this.children.add(layoutPart);
        if (this.root == null) {
            this.root = new LayoutTree(layoutPart);
        } else {
            int n = relationshipInfo.relationship == 1 || relationshipInfo.relationship == 2 ? 512 : 256;
            boolean bl = relationshipInfo.relationship == 1 || relationshipInfo.relationship == 3;
            LayoutPartSash layoutPartSash = new LayoutPartSash(this, n);
            layoutPartSash.setSizes(relationshipInfo.left, relationshipInfo.right);
            if (this.parent != null && !(layoutPart instanceof PartPlaceholder)) {
                layoutPartSash.createControl(this.parent);
            }
            this.root = this.root.insert(layoutPart, bl, layoutPartSash, relationshipInfo.relative);
        }
        this.childAdded(layoutPart);
        if (this.active) {
            layoutPart.createControl(this.parent);
            layoutPart.setVisible(true);
            layoutPart.setContainer(this);
            this.resizeChild(layoutPart);
        }
    }

    void addChildForPlaceholder(LayoutPart layoutPart, LayoutPart layoutPart2) {
        RelationshipInfo relationshipInfo = new RelationshipInfo();
        relationshipInfo.part = layoutPart;
        if (this.root != null) {
            relationshipInfo.relationship = 2;
            relationshipInfo.relative = this.root.findBottomRight();
            relationshipInfo.left = 200;
            relationshipInfo.right = 200;
        }
        RelationshipInfo[] relationshipInfoArray = this.computeRelation();
        int n = 0;
        while (n < relationshipInfoArray.length) {
            RelationshipInfo relationshipInfo2 = relationshipInfoArray[n];
            if (relationshipInfo2.part == layoutPart2) {
                relationshipInfo.left = relationshipInfo2.left;
                relationshipInfo.right = relationshipInfo2.right;
                relationshipInfo.relationship = relationshipInfo2.relationship;
                relationshipInfo.relative = relationshipInfo2.relative;
            }
            ++n;
        }
        this.addChild(relationshipInfo);
        this.flushLayout();
    }

    public boolean allowsBorder() {
        return true;
    }

    protected void childAdded(LayoutPart layoutPart) {
        if (this.isDeferred()) {
            layoutPart.deferUpdates(true);
        }
    }

    protected void childRemoved(LayoutPart layoutPart) {
        if (this.isDeferred()) {
            layoutPart.deferUpdates(false);
        }
    }

    public RelationshipInfo[] computeRelation() {
        LayoutTree layoutTree = this.root;
        ArrayList<RelationshipInfo> arrayList = new ArrayList<RelationshipInfo>();
        if (layoutTree == null) {
            return new RelationshipInfo[0];
        }
        RelationshipInfo relationshipInfo = new RelationshipInfo();
        relationshipInfo.part = layoutTree.computeRelation(arrayList);
        arrayList.add(0, relationshipInfo);
        RelationshipInfo[] relationshipInfoArray = new RelationshipInfo[arrayList.size()];
        arrayList.toArray(relationshipInfoArray);
        return relationshipInfoArray;
    }

    public void createControl(Composite composite) {
        if (this.active) {
            return;
        }
        this.parent = this.createParent(composite);
        this.parent.addControlListener(this.resizeListener);
        ArrayList arrayList = (ArrayList)this.children.clone();
        int n = 0;
        int n2 = arrayList.size();
        while (n < n2) {
            LayoutPart layoutPart = (LayoutPart)arrayList.get(n);
            layoutPart.setContainer(this);
            layoutPart.createControl(this.parent);
            layoutPart.setVisible(this.zoomedPart == null || layoutPart == this.zoomedPart);
            ++n;
        }
        if (this.root != null) {
            this.root.flushChildren();
            if (!this.isZoomed()) {
                this.root.createControl(this.parent);
            }
        }
        this.active = true;
        this.resizeSashes();
    }

    protected abstract Composite createParent(Composite var1);

    public void dispose() {
        if (!this.active) {
            return;
        }
        if (this.resizeListener != null && this.parent != null) {
            this.parent.removeControlListener(this.resizeListener);
        }
        if (this.children != null) {
            int n = 0;
            int n2 = this.children.size();
            while (n < n2) {
                LayoutPart layoutPart = (LayoutPart)this.children.get(n);
                layoutPart.setContainer(null);
                if (layoutPart instanceof ViewStack) {
                    layoutPart.dispose();
                }
                ++n;
            }
        }
        this.disposeParent();
        this.disposeSashes();
        this.parent = null;
        this.active = false;
    }

    protected abstract void disposeParent();

    public void disposeSashes() {
        if (this.root != null) {
            this.root.disposeSashes();
        }
    }

    public void setVisible(boolean bl) {
        if (bl == this.getVisible()) {
            return;
        }
        if (!SwtUtil.isDisposed((Control)this.parent)) {
            this.parent.setEnabled(bl);
        }
        super.setVisible(bl);
        ArrayList arrayList = (ArrayList)this.children.clone();
        int n = 0;
        int n2 = arrayList.size();
        while (n < n2) {
            LayoutPart layoutPart = (LayoutPart)arrayList.get(n);
            layoutPart.setVisible(bl && (this.zoomedPart == null || layoutPart == this.zoomedPart));
            ++n;
        }
    }

    public LayoutPart findBottomRight() {
        if (this.root == null) {
            return null;
        }
        return this.root.findBottomRight();
    }

    public Rectangle getBounds() {
        return this.parent.getBounds();
    }

    public LayoutPart[] getChildren() {
        LayoutPart[] layoutPartArray = new LayoutPart[this.children.size()];
        this.children.toArray(layoutPartArray);
        return layoutPartArray;
    }

    public Control getControl() {
        return this.parent;
    }

    public LayoutTree getLayoutTree() {
        return this.root;
    }

    public WorkbenchPage getPage() {
        return this.page;
    }

    public Composite getParent() {
        return this.parent;
    }

    protected boolean isChild(LayoutPart layoutPart) {
        return this.children.indexOf(layoutPart) >= 0;
    }

    private boolean isRelationshipCompatible(int n, boolean bl) {
        if (bl) {
            return n == 2 || n == 1;
        }
        return n == 3 || n == 4;
    }

    public boolean isZoomed() {
        return this.zoomedPart != null;
    }

    public void resizeChild(LayoutPart layoutPart) {
        LayoutTree layoutTree;
        if (this.root != null && (layoutTree = this.root.find(layoutPart)) != null) {
            layoutTree.flushCache();
        }
        this.flushLayout();
    }

    public void remove(LayoutPart layoutPart) {
        if (layoutPart == this.getZoomedPart()) {
            this.childRequestZoomOut();
        }
        if (!this.isChild(layoutPart)) {
            return;
        }
        this.children.remove(layoutPart);
        if (this.root != null) {
            this.root = this.root.remove(layoutPart);
        }
        this.childRemoved(layoutPart);
        if (this.active) {
            layoutPart.setVisible(false);
            layoutPart.setContainer(null);
            this.flushLayout();
        }
    }

    public void flushLayout() {
        this.layoutDirty = true;
        super.flushLayout();
        if (this.layoutDirty) {
            this.resizeSashes();
        }
    }

    public void replace(LayoutPart layoutPart, LayoutPart layoutPart2) {
        if (!this.isChild(layoutPart)) {
            return;
        }
        if (layoutPart == this.getZoomedPart()) {
            if (layoutPart2 instanceof PartPlaceholder) {
                this.childRequestZoomOut();
            } else {
                this.zoomedPart.setZoomed(false);
                this.zoomedPart = layoutPart2;
                this.zoomedPart.setZoomed(true);
            }
        }
        this.children.remove(layoutPart);
        this.children.add(layoutPart2);
        this.childAdded(layoutPart2);
        if (this.root != null) {
            LayoutTree layoutTree = null;
            layoutTree = this.root.find(layoutPart);
            if (layoutTree != null) {
                layoutTree.setPart(layoutPart2);
            }
        }
        this.childRemoved(layoutPart);
        if (this.active) {
            layoutPart.setVisible(false);
            layoutPart.setContainer(null);
            layoutPart2.createControl(this.parent);
            layoutPart2.setContainer(this);
            layoutPart2.setVisible(this.zoomedPart == null || this.zoomedPart == layoutPart2);
            this.resizeChild(layoutPart2);
        }
    }

    private void resizeSashes() {
        this.layoutDirty = false;
        if (!this.active) {
            return;
        }
        if (this.isZoomed()) {
            this.getZoomedPart().setBounds(this.parent.getClientArea());
        } else if (this.root != null) {
            this.root.setBounds(this.parent.getClientArea());
        }
    }

    public int computePreferredSize(boolean bl, int n, int n2, int n3) {
        if (this.isZoomed()) {
            return this.getZoomedPart().computePreferredSize(bl, n, n2, n3);
        }
        if (this.root != null) {
            return this.root.computePreferredSize(bl, n, n2, n3);
        }
        return n3;
    }

    public int getSizeFlags(boolean bl) {
        if (this.isZoomed()) {
            return this.getZoomedPart().getSizeFlags(bl);
        }
        if (this.root != null) {
            return this.root.getSizeFlags(bl);
        }
        return 0;
    }

    public void setBounds(Rectangle rectangle) {
        this.parent.setBounds(rectangle);
    }

    private void zoomIn(LayoutPart layoutPart) {
        if (this.isZoomed()) {
            return;
        }
        this.root.disposeSashes();
        LayoutPart[] layoutPartArray = this.getChildren();
        int n = 0;
        while (n < layoutPartArray.length) {
            LayoutPart layoutPart2;
            layoutPart2.setVisible((layoutPart2 = layoutPartArray[n]) == layoutPart);
            ++n;
        }
        this.zoomedPart = layoutPart;
        layoutPart.setZoomed(true);
        this.layoutDirty = true;
    }

    public LayoutPart getZoomedPart() {
        return this.zoomedPart;
    }

    /*
     * Exception decompiling
     */
    public void childRequestZoomIn(LayoutPart var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 68->72)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void childRequestZoomOut() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 67->71)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setZoomed(boolean bl) {
        LayoutPart layoutPart;
        if (!bl) {
            this.zoomOut();
        } else if (!this.isZoomed() && (layoutPart = this.pickPartToZoom()) != null) {
            this.zoomIn(layoutPart);
        }
        super.setZoomed(bl);
    }

    public LayoutPart pickPartToZoom() {
        return this.findBottomRight();
    }

    private void zoomOut() {
        if (!this.isZoomed()) {
            return;
        }
        LayoutPart layoutPart = this.zoomedPart;
        this.zoomedPart = null;
        layoutPart.setZoomed(false);
        LayoutPart[] layoutPartArray = this.getChildren();
        int n = 0;
        while (n < layoutPartArray.length) {
            LayoutPart layoutPart2 = layoutPartArray[n];
            layoutPart2.setVisible(true);
            ++n;
        }
        this.root.createControl(this.getParent());
        LayoutTree layoutTree = this.root.find(layoutPart);
        layoutTree.flushCache();
        this.layoutDirty = true;
    }

    public abstract boolean isStackType(LayoutPart var1);

    public abstract boolean isPaneType(LayoutPart var1);

    protected abstract PartStack createStack();

    public void stack(LayoutPart layoutPart, ILayoutContainer iLayoutContainer) {
        this.getControl().setRedraw(false);
        this.derefPart(layoutPart);
        layoutPart.reparent(this.getParent());
        iLayoutContainer.add(layoutPart);
        this.getControl().setRedraw(true);
    }

    protected abstract void setVisiblePart(ILayoutContainer var1, LayoutPart var2);

    protected abstract LayoutPart getVisiblePart(ILayoutContainer var1);

    protected void derefPart(LayoutPart layoutPart) {
        PartStack partStack;
        ILayoutContainer iLayoutContainer = layoutPart.getContainer();
        if (iLayoutContainer != null) {
            iLayoutContainer.remove(layoutPart);
        }
        if (iLayoutContainer instanceof LayoutPart && this.isStackType((LayoutPart)((Object)iLayoutContainer)) && (partStack = (PartStack)iLayoutContainer).getChildren().length == 0) {
            this.remove(partStack);
            partStack.dispose();
        }
    }

    protected int getVisibleChildrenCount(ILayoutContainer iLayoutContainer) {
        if (iLayoutContainer == null) {
            return 0;
        }
        LayoutPart[] layoutPartArray = iLayoutContainer.getChildren();
        int n = 0;
        int n2 = 0;
        while (n2 < layoutPartArray.length) {
            if (!(layoutPartArray[n2] instanceof PartPlaceholder)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    protected float getDockingRatio(LayoutPart layoutPart, LayoutPart layoutPart2) {
        return 0.5f;
    }

    public void describeLayout(StringBuffer stringBuffer) {
        if (this.root == null) {
            return;
        }
        if (this.isZoomed()) {
            stringBuffer.append("zoomed ");
            this.root.describeLayout(stringBuffer);
        } else {
            stringBuffer.append("layout ");
            this.root.describeLayout(stringBuffer);
        }
    }

    void add(LayoutPart layoutPart, int n, int n2, int n3, LayoutPart layoutPart2) {
        if (layoutPart == null) {
            return;
        }
        if (layoutPart2 != null && !this.isChild(layoutPart2)) {
            return;
        }
        if (n < 1 || n > 4) {
            n = 1;
        }
        RelationshipInfo relationshipInfo = new RelationshipInfo();
        relationshipInfo.part = layoutPart;
        relationshipInfo.relationship = n;
        relationshipInfo.left = n2;
        relationshipInfo.right = n3;
        relationshipInfo.relative = layoutPart2;
        this.addChild(relationshipInfo);
    }

    public boolean childIsZoomed(LayoutPart layoutPart) {
        return layoutPart == this.getZoomedPart();
    }

    public boolean allowsAutoFocus() {
        return true;
    }

    protected void startDeferringEvents() {
        super.startDeferringEvents();
        LayoutPart[] layoutPartArray = this.children.toArray(new LayoutPart[this.children.size()]);
        int n = 0;
        while (n < layoutPartArray.length) {
            LayoutPart layoutPart = layoutPartArray[n];
            layoutPart.deferUpdates(true);
            ++n;
        }
    }

    protected void handleDeferredEvents() {
        super.handleDeferredEvents();
        LayoutPart[] layoutPartArray = this.children.toArray(new LayoutPart[this.children.size()]);
        int n = 0;
        while (n < layoutPartArray.length) {
            LayoutPart layoutPart = layoutPartArray[n];
            layoutPart.deferUpdates(false);
            ++n;
        }
    }

    public void testInvariants() {
        super.testInvariants();
        if (this.getContainer() != null) {
            Assert.isTrue((this.getZoomedPart() != null == this.getContainer().childIsZoomed(this) ? 1 : 0) != 0);
        }
        LayoutPart[] layoutPartArray = this.getChildren();
        int n = 0;
        while (n < layoutPartArray.length) {
            layoutPartArray[n].testInvariants();
            ++n;
        }
        if (this.isZoomed()) {
            Assert.isTrue((boolean)this.children.contains(this.zoomedPart));
        }
    }

    protected static class RelationshipInfo {
        protected LayoutPart part;
        protected LayoutPart relative;
        protected int relationship;
        protected int left;
        protected int right;

        protected RelationshipInfo() {
        }

        public float getRatio() {
            int n = this.left + this.right;
            if (n > 0) {
                return (float)this.left / (float)n;
            }
            return 0.5f;
        }
    }
}

