/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.eworkbench;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.ercp.eworkbench.ApplicationDescriptor;
import org.eclipse.ercp.eworkbench.ApplicationRegistryReader;
import org.eclipse.ercp.eworkbench.IApplicationDescriptor;
import org.eclipse.ercp.eworkbench.IApplicationRegistry;
import org.eclipse.ui.PlatformUI;

public class ApplicationRegistry
implements IApplicationRegistry,
IExtensionChangeHandler {
    private List applications = new ArrayList(10);

    public ApplicationRegistry() {
        IExtensionTracker iExtensionTracker = PlatformUI.getWorkbench().getExtensionTracker();
        iExtensionTracker.registerHandler((IExtensionChangeHandler)this, null);
    }

    public void addApplication(ApplicationDescriptor applicationDescriptor) {
        if (applicationDescriptor == null) {
            return;
        }
        this.add(applicationDescriptor);
    }

    private void add(ApplicationDescriptor applicationDescriptor) {
        this.applications.add(applicationDescriptor);
        IConfigurationElement iConfigurationElement = applicationDescriptor.getConfigElement();
        if (iConfigurationElement != null) {
            PlatformUI.getWorkbench().getExtensionTracker().registerObject(iConfigurationElement.getDeclaringExtension(), (Object)applicationDescriptor, 2);
        }
    }

    public ApplicationDescriptor createApplication(String string) {
        if (!this.validateLabel(string)) {
            return null;
        }
        if (this.findApplicationWithLabel(string) != null) {
            return null;
        }
        String string2 = string.replace(' ', '_');
        string2 = string2.trim();
        ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor(string2, string);
        this.add(applicationDescriptor);
        return applicationDescriptor;
    }

    public void deleteApplication(IApplicationDescriptor iApplicationDescriptor) {
        ApplicationDescriptor applicationDescriptor = (ApplicationDescriptor)iApplicationDescriptor;
        this.applications.remove(applicationDescriptor);
    }

    public IApplicationDescriptor findApplicationWithId(String string) {
        Iterator iterator = this.applications.iterator();
        while (iterator.hasNext()) {
            ApplicationDescriptor applicationDescriptor = (ApplicationDescriptor)iterator.next();
            if (!applicationDescriptor.getId().equals(string)) continue;
            return applicationDescriptor;
        }
        return null;
    }

    public IApplicationDescriptor findApplicationWithLabel(String string) {
        Iterator iterator = this.applications.iterator();
        while (iterator.hasNext()) {
            ApplicationDescriptor applicationDescriptor = (ApplicationDescriptor)iterator.next();
            if (!applicationDescriptor.getLabel().equals(string)) continue;
            return applicationDescriptor;
        }
        return null;
    }

    public IApplicationDescriptor[] getApplications() {
        return this.applications.toArray(new IApplicationDescriptor[this.applications.size()]);
    }

    public void load() {
        ApplicationRegistryReader applicationRegistryReader = new ApplicationRegistryReader(this);
        applicationRegistryReader.readApplications(Platform.getExtensionRegistry());
    }

    public boolean validateLabel(String string) {
        return (string = string.trim()).length() > 0;
    }

    public void dispose() {
        PlatformUI.getWorkbench().getExtensionTracker().unregisterHandler((IExtensionChangeHandler)this);
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof ApplicationDescriptor) {
                this.deleteApplication((ApplicationDescriptor)objectArray[n]);
            }
            ++n;
        }
    }

    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            ApplicationRegistryReader applicationRegistryReader = new ApplicationRegistryReader(this);
            applicationRegistryReader.readElement(iConfigurationElementArray[n]);
            ++n;
        }
    }
}

