/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CustomHashtable;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeEditorImpl;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeViewer
extends AbstractTreeViewer {
    private TreeEditorImpl treeViewerImpl;
    private Tree tree;
    private TreeColorAndFontCollector treeColorAndFont = new TreeColorAndFontCollector();

    public TreeViewer(Composite composite) {
        this(composite, 2818);
    }

    public TreeViewer(Composite composite, int n) {
        this(new Tree(composite, n));
    }

    public TreeViewer(Tree tree) {
        this.tree = tree;
        this.hookControl((Control)tree);
        this.initTreeViewerImpl();
    }

    protected void addTreeListener(Control control, TreeListener treeListener) {
        ((Tree)control).addTreeListener(treeListener);
    }

    public void cancelEditing() {
        this.treeViewerImpl.cancelEditing();
    }

    protected void doUpdateItem(Item item, Object object) {
        if (!(item instanceof TreeItem)) {
            return;
        }
        TreeItem treeItem = (TreeItem)item;
        if (treeItem.isDisposed()) {
            this.unmapElement(object);
            return;
        }
        this.getColorAndFontCollector().setFontsAndColors(object);
        IBaseLabelProvider iBaseLabelProvider = this.getLabelProvider();
        ILabelProvider iLabelProvider = null;
        IViewerLabelProvider iViewerLabelProvider = null;
        if (iBaseLabelProvider instanceof ILabelProvider) {
            iLabelProvider = (ILabelProvider)iBaseLabelProvider;
        }
        if (iBaseLabelProvider instanceof IViewerLabelProvider) {
            iViewerLabelProvider = (IViewerLabelProvider)iBaseLabelProvider;
        }
        if (iBaseLabelProvider instanceof ITableLabelProvider) {
            ITableLabelProvider cfr_ignored_0 = (ITableLabelProvider)iBaseLabelProvider;
        }
        ViewerLabel viewerLabel = new ViewerLabel(treeItem.getText(), treeItem.getImage());
        if (iViewerLabelProvider != null) {
            this.buildLabel(viewerLabel, object, iViewerLabelProvider);
        } else if (iLabelProvider != null) {
            this.buildLabel(viewerLabel, object, iLabelProvider);
        }
        if (treeItem.isDisposed()) {
            this.unmapElement(object);
            return;
        }
        if (viewerLabel.hasNewText()) {
            treeItem.setText(viewerLabel.getText());
        }
        if (viewerLabel.hasNewImage()) {
            treeItem.setImage(viewerLabel.getImage());
        }
        this.getColorAndFontCollector().applyFontsAndColors(treeItem);
    }

    public void editElement(Object object, int n) {
        this.treeViewerImpl.editElement(object, n);
    }

    public CellEditor[] getCellEditors() {
        return this.treeViewerImpl.getCellEditors();
    }

    public ICellModifier getCellModifier() {
        return this.treeViewerImpl.getCellModifier();
    }

    protected Item[] getChildren(Widget widget) {
        if (widget instanceof TreeItem) {
            return ((TreeItem)widget).getItems();
        }
        if (widget instanceof Tree) {
            return ((Tree)widget).getItems();
        }
        return null;
    }

    public Object[] getColumnProperties() {
        return this.treeViewerImpl.getColumnProperties();
    }

    public Control getControl() {
        return this.tree;
    }

    protected boolean getExpanded(Item item) {
        return ((TreeItem)item).getExpanded();
    }

    protected Item getItem(int n, int n2) {
        return this.getTree().getItem(this.getTree().toControl(new Point(n, n2)));
    }

    protected int getItemCount(Control control) {
        return ((Tree)control).getItemCount();
    }

    protected int getItemCount(Item item) {
        return ((TreeItem)item).getItemCount();
    }

    protected Item[] getItems(Item item) {
        return ((TreeItem)item).getItems();
    }

    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    protected Item getParentItem(Item item) {
        return ((TreeItem)item).getParentItem();
    }

    protected Item[] getSelection(Control control) {
        return ((Tree)control).getSelection();
    }

    public Tree getTree() {
        return this.tree;
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        Tree tree = (Tree)control;
        tree.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent mouseEvent) {
                TreeViewer.this.treeViewerImpl.handleMouseDown(mouseEvent);
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
    }

    private void initTreeViewerImpl() {
        this.treeViewerImpl = new TreeEditorImpl(this){

            Rectangle getBounds(Item item) {
                return ((TreeItem)item).getBounds();
            }

            Item[] getSelection() {
                return TreeViewer.this.getTree().getSelection();
            }

            void setEditor(Control control, Item item, int n) {
            }

            void setSelection(StructuredSelection structuredSelection, boolean bl) {
                TreeViewer.this.setSelection(structuredSelection, bl);
            }

            void showSelection() {
                TreeViewer.this.getTree().showSelection();
            }

            void setLayoutData(CellEditor.LayoutData layoutData) {
            }

            void handleDoubleClickEvent() {
                StructuredViewer structuredViewer = this.getViewer();
                TreeViewer.this.fireDoubleClick(new DoubleClickEvent(structuredViewer, ((Viewer)structuredViewer).getSelection()));
                TreeViewer.this.fireOpen(new OpenEvent(structuredViewer, ((Viewer)structuredViewer).getSelection()));
            }
        };
    }

    public boolean isCellEditorActive() {
        return this.treeViewerImpl.isCellEditorActive();
    }

    protected Item newItem(Widget widget, int n, int n2) {
        TreeItem treeItem = n2 >= 0 ? (widget instanceof TreeItem ? new TreeItem((TreeItem)widget, n, n2) : new TreeItem((Tree)widget, n, n2)) : (widget instanceof TreeItem ? new TreeItem((TreeItem)widget, n) : new TreeItem((Tree)widget, n));
        return treeItem;
    }

    protected void removeAll(Control control) {
        ((Tree)control).removeAll();
    }

    public void setCellEditors(CellEditor[] cellEditorArray) {
        this.treeViewerImpl.setCellEditors(cellEditorArray);
    }

    public void setCellModifier(ICellModifier iCellModifier) {
        this.treeViewerImpl.setCellModifier(iCellModifier);
    }

    public void setColumnProperties(String[] stringArray) {
        this.treeViewerImpl.setColumnProperties(stringArray);
    }

    protected void setExpanded(Item item, boolean bl) {
        ((TreeItem)item).setExpanded(bl);
    }

    public void setLabelProvider(IBaseLabelProvider iBaseLabelProvider) {
        Assert.isTrue(iBaseLabelProvider instanceof ITableLabelProvider || iBaseLabelProvider instanceof ILabelProvider);
        super.setLabelProvider(iBaseLabelProvider);
        this.treeColorAndFont = new TreeColorAndFontCollector(iBaseLabelProvider);
    }

    protected void setSelection(List list) {
        Item[] itemArray = this.getSelection((Control)this.getTree());
        if (this.isSameSelection(list, itemArray)) {
            return;
        }
        TreeItem[] treeItemArray = new TreeItem[list.size()];
        list.toArray(treeItemArray);
        this.getTree().setSelection(treeItemArray);
    }

    protected boolean isSameSelection(List list, Item[] itemArray) {
        int n = list.size();
        if (n != itemArray.length) {
            return false;
        }
        CustomHashtable customHashtable = this.newHashtable(n * 2 + 1);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Item item = (Item)iterator.next();
            Object object = item.getData();
            customHashtable.put(object, object);
        }
        int n2 = 0;
        while (n2 < itemArray.length) {
            if (!customHashtable.containsKey(itemArray[n2].getData())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void showItem(Item item) {
        this.getTree().showItem((TreeItem)item);
    }

    protected Item getChild(Widget widget, int n) {
        if (widget instanceof TreeItem) {
            TreeItem[] treeItemArray = ((TreeItem)widget).getItems();
            return treeItemArray[n];
        }
        if (widget instanceof Tree) {
            TreeItem[] treeItemArray = ((Tree)widget).getItems();
            return treeItemArray[n];
        }
        return null;
    }

    private class TreeColorAndFontCollector {
        ITableFontProvider fontProvider = null;
        ITableColorProvider colorProvider = null;

        public TreeColorAndFontCollector(IBaseLabelProvider iBaseLabelProvider) {
            if (iBaseLabelProvider instanceof ITableFontProvider) {
                this.fontProvider = (ITableFontProvider)((Object)iBaseLabelProvider);
            }
            if (iBaseLabelProvider instanceof ITableColorProvider) {
                this.colorProvider = (ITableColorProvider)((Object)iBaseLabelProvider);
            }
        }

        public TreeColorAndFontCollector() {
        }

        public void setFontsAndColors(TreeItem treeItem, Object object) {
            if (this.colorProvider != null) {
                treeItem.setBackground(this.colorProvider.getBackground(object, 0));
                treeItem.setForeground(this.colorProvider.getForeground(object, 0));
            }
            if (this.fontProvider != null) {
                treeItem.setFont(this.fontProvider.getFont(object, 0));
            }
        }
    }
}

