/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.BaseSiteFactory;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteContentProvider;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.PluginEntry;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.SiteContentProvider;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.ArchiveReferenceModel;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.core.EmptyDirectoryException;
import org.eclipse.update.internal.core.FeaturePackagedContentProvider;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.SiteFile;
import org.eclipse.update.internal.core.SiteFileContentProvider;
import org.eclipse.update.internal.core.URLEncoder;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.model.BundleManifest;
import org.eclipse.update.internal.model.DefaultPluginParser;
import org.xml.sax.SAXException;

public class SiteFileFactory
extends BaseSiteFactory {
    private SiteFile site;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ISite createSite(URL uRL) throws CoreException, InvalidSiteTypeException {
        Site site = null;
        InputStream inputStream = null;
        SiteFileFactory siteFileFactory = this;
        try {
            try {
                Object object;
                String string = uRL.getFile();
                File file = new File(string);
                if (file.isDirectory()) {
                    uRL = file.toURL();
                    object = new File(file, "site.xml");
                    if (((File)object).exists()) {
                        inputStream = new FileInputStream((File)object);
                        site = (Site)siteFileFactory.parseSite(inputStream, uRL);
                    } else {
                        site = this.parseSite(file);
                    }
                } else {
                    try {
                        object = URLEncoder.encode(uRL);
                        inputStream = this.openStream((URL)object);
                        site = (Site)siteFileFactory.parseSite(inputStream, uRL);
                    }
                    catch (IOException iOException) {
                        object = new File(uRL.getFile());
                        File file2 = ((File)object).getParentFile();
                        if (file2 != null && !file2.exists()) {
                            throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_DirectoryDoesNotExist, (Object[])new String[]{((File)object).getAbsolutePath()}), null);
                        }
                        if (file2 == null || !file2.isDirectory()) {
                            throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_UnableToObtainParentDirectory, (Object[])new String[]{((File)object).getAbsolutePath()}), null);
                        }
                        site = this.parseSite(file2);
                    }
                }
                object = new SiteFileContentProvider(uRL);
                site.setSiteContentProvider((ISiteContentProvider)object);
                ((SiteContentProvider)object).setSite(site);
                site.resolve(uRL, uRL);
            }
            catch (MalformedURLException malformedURLException) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_UnableToCreateURL, (Object[])new String[]{uRL == null ? "" : uRL.toExternalForm()}), malformedURLException);
            }
            catch (IOException iOException) {
                throw Utilities.newCoreException(Messages.SiteFileFactory_UnableToAccessSite, 42, iOException);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            try {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var9_13 = null;
        }
        try {}
        catch (IOException iOException) {
            return site;
        }
        if (inputStream == null) return site;
        inputStream.close();
        return site;
    }

    private Site parseSite(File file) throws CoreException {
        this.site = (SiteFile)this.createSiteMapModel();
        if (!file.exists()) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_FileDoesNotExist, (Object[])new String[]{file.getAbsolutePath()}), null);
        }
        File file2 = new File(file, "plugins/");
        try {
            this.parsePackagedFeature(file);
        }
        catch (EmptyDirectoryException emptyDirectoryException) {
            UpdateCore.log(emptyDirectoryException.getStatus());
        }
        try {
            this.parsePackagedPlugins(file2);
        }
        catch (EmptyDirectoryException emptyDirectoryException) {
            UpdateCore.log(emptyDirectoryException.getStatus());
        }
        try {
            this.parseInstalledFeature(file);
        }
        catch (EmptyDirectoryException emptyDirectoryException) {
            UpdateCore.log(emptyDirectoryException.getStatus());
        }
        try {
            this.parseInstalledPlugins(file2);
        }
        catch (EmptyDirectoryException emptyDirectoryException) {
            UpdateCore.log(emptyDirectoryException.getStatus());
        }
        return this.site;
    }

    private void parseInstalledFeature(File file) throws CoreException {
        File file2 = new File(file, "features/");
        if (file2.exists()) {
            String string = null;
            try {
                String[] stringArray = file2.list();
                if (stringArray == null) {
                    throw new EmptyDirectoryException((IStatus)new Status(2, UpdateCore.getPlugin().getBundle().getSymbolicName(), 0, String.valueOf(file.getName()) + File.separator + file.getName() + "directory is empty", null));
                }
                int n = 0;
                while (n < stringArray.length) {
                    string = String.valueOf(stringArray[n]) + (stringArray[n].endsWith("/") ? "/" : "");
                    File file3 = new File(file2, string);
                    File file4 = new File(file3, "feature.xml");
                    if (!file4.exists()) {
                        UpdateCore.warn("Unable to find feature.xml in directory:" + file3);
                    } else {
                        URL uRL = file3.toURL();
                        SiteFeatureReferenceModel siteFeatureReferenceModel = this.createFeatureReferenceModel();
                        siteFeatureReferenceModel.setSiteModel(this.site);
                        siteFeatureReferenceModel.setURLString(uRL.toExternalForm());
                        siteFeatureReferenceModel.setType("org.eclipse.update.core.installed");
                        this.site.addFeatureReferenceModel(siteFeatureReferenceModel);
                    }
                    ++n;
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_UnableToCreateURLForFile, (Object[])new String[]{string}), malformedURLException);
            }
        }
    }

    private void parsePackagedFeature(File file) throws CoreException {
        File file2 = new File(file, "features/");
        if (file2.exists()) {
            Object var7_3 = null;
            try {
                String[] stringArray = file2.list(FeaturePackagedContentProvider.filter);
                if (stringArray == null) {
                    throw new EmptyDirectoryException((IStatus)new Status(2, UpdateCore.getPlugin().getBundle().getSymbolicName(), 0, String.valueOf(file.getName()) + File.separator + file.getName() + "directory is empty", null));
                }
                int n = 0;
                while (n < stringArray.length) {
                    File file3 = new File(file2, stringArray[n]);
                    JarContentReference jarContentReference = new JarContentReference("", file3);
                    ContentReference contentReference = null;
                    try {
                        contentReference = jarContentReference.peek("feature.xml", null, null);
                    }
                    catch (IOException iOException) {
                        UpdateCore.warn("Exception retrieving feature.xml in file:" + file3, iOException);
                    }
                    if (contentReference == null) {
                        UpdateCore.warn("Unable to find feature.xml in file:" + file3);
                    } else {
                        URL uRL = file3.toURL();
                        SiteFeatureReferenceModel siteFeatureReferenceModel = this.createFeatureReferenceModel();
                        siteFeatureReferenceModel.setSiteModel(this.site);
                        siteFeatureReferenceModel.setURLString(uRL.toExternalForm());
                        siteFeatureReferenceModel.setType("org.eclipse.update.core.packaged");
                        this.site.addFeatureReferenceModel(siteFeatureReferenceModel);
                    }
                    ++n;
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_UnableToCreateURLForFile, (Object[])new String[]{var7_3}), malformedURLException);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseInstalledPlugins(File file) throws CoreException {
        if (!file.exists()) return;
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        DefaultPluginParser defaultPluginParser = new DefaultPluginParser();
        if (fileArray == null) {
            throw new EmptyDirectoryException((IStatus)new Status(2, UpdateCore.getPlugin().getBundle().getSymbolicName(), 0, String.valueOf(file.getName()) + File.separator + file.getName() + "directory is empty", null));
        }
        int n = 0;
        while (true) {
            block17: {
                Object var9_11;
                if (n >= fileArray.length) {
                    return;
                }
                File file2 = new File(fileArray[n], "META-INF/MANIFEST.MF");
                InputStream inputStream = null;
                try {
                    Object object;
                    try {
                        BundleManifest bundleManifest = new BundleManifest(file2);
                        if (bundleManifest.exists()) {
                            object = bundleManifest.getPluginEntry();
                            this.addParsedPlugin((PluginEntry)object, fileArray[n]);
                        } else {
                            file2 = new File(fileArray[n], "plugin.xml");
                            if (!file2.exists()) {
                                file2 = new File(fileArray[n], "fragment.xml");
                            }
                            if (file2 != null && file2.exists() && !file2.isDirectory()) {
                                inputStream = new FileInputStream(file2);
                                object = defaultPluginParser.parse(inputStream);
                                this.addParsedPlugin((PluginEntry)object, fileArray[n]);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        object = file2 == null ? null : file2.getAbsolutePath();
                        throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_ErrorAccessing, (Object[])new String[]{object}), iOException);
                    }
                    catch (SAXException sAXException) {
                        object = file2 == null ? null : file2.getAbsolutePath();
                        throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_ErrorParsingFile, (Object[])new String[]{object}), sAXException);
                    }
                }
                catch (Throwable throwable) {
                    var9_11 = null;
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    var9_11 = null;
                    if (inputStream == null) break block17;
                }
                try {}
                catch (IOException iOException) {}
                inputStream.close();
            }
            ++n;
        }
    }

    private void addParsedPlugin(PluginEntry pluginEntry, File file) throws CoreException {
        String string = null;
        try {
            if (pluginEntry != null) {
                ((Site)this.site).addPluginEntry(pluginEntry);
                ArchiveReferenceModel archiveReferenceModel = this.createArchiveReferenceModel();
                String string2 = pluginEntry.getVersionedIdentifier().toString();
                String string3 = "plugins/" + string2 + ".jar";
                archiveReferenceModel.setPath(string3);
                string = file.toURL().toExternalForm();
                archiveReferenceModel.setURLString(string);
                this.site.addArchiveReferenceModel(archiveReferenceModel);
                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
                    UpdateCore.debug("Added archive to site:" + string3 + " pointing to: " + string);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_UnableToCreateURLForFile, (Object[])new String[]{string}), malformedURLException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parsePackagedPlugins(File var1_1) throws CoreException {
        if (!var1_1.exists()) {
            return;
        }
        var2_2 = var1_1.list(FeaturePackagedContentProvider.filter);
        if (var2_2 == null) {
            throw new EmptyDirectoryException((IStatus)new Status(2, UpdateCore.getPlugin().getBundle().getSymbolicName(), 0, String.valueOf(var1_1.getName()) + File.separator + var1_1.getName() + "directory is empty", null));
        }
        var3_3 = 0;
        while (true) {
            block31: {
                block30: {
                    block27: {
                        block28: {
                            if (var3_3 >= var2_2.length) {
                                return;
                            }
                            var4_4 = null;
                            var5_5 = null;
                            var6_6 = null;
                            var7_7 = null;
                            try {
                                try {
                                    var8_8 = new File(var1_1, var2_2[var3_3]);
                                    var7_7 = new JarContentReference(null, var8_8);
                                    var4_4 = var7_7.peek("META-INF/MANIFEST.MF", null, null);
                                    if (var4_4 != null && (var9_11 = new BundleManifest(var6_6 = var4_4.getInputStream())).exists()) {
                                        this.addParsedPlugin(var9_11.getPluginEntry(), var8_8);
                                        var10_12 = null;
                                        if (var6_6 == null) break block27;
                                        break block28;
                                    }
                                    var4_4 = var7_7.peek("plugin.xml", null, null);
                                    if (var4_4 == null) {
                                        var4_4 = var7_7.peek("fragment.xml", null, null);
                                    }
                                    if (var4_4 == null) ** GOTO lbl-1000
                                    var6_6 = var4_4.getInputStream();
                                    var9_11 = new DefaultPluginParser().parse(var6_6);
                                    this.addParsedPlugin((PluginEntry)var9_11, var8_8);
                                    ** GOTO lbl-1000
                                }
                                catch (IOException var8_9) {
                                    try {
                                        var5_5 = var4_4 == null ? null : var4_4.asURL().toExternalForm();
                                        throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_ErrorAccessing, (Object[])new String[]{var5_5}), var8_9);
                                    }
                                    catch (IOException v0) {}
                                    throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_ErrorAccessing, (Object[])new String[]{var5_5}), var8_9);
                                }
                                catch (SAXException var8_10) {
                                    try {
                                        var5_5 = var4_4 == null ? null : var4_4.asURL().toExternalForm();
                                        throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_ErrorParsingFile, (Object[])new String[]{var5_5}), var8_10);
                                    }
                                    catch (IOException v1) {}
                                    throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_ErrorParsingFile, (Object[])new String[]{var5_5}), var8_10);
                                }
                            }
                            catch (Throwable var11_14) {
                                var10_12 = null;
                                if (var6_6 != null) {
                                    try {
                                        var6_6.close();
                                    }
                                    catch (IOException v2) {}
                                }
                                if (var7_7 == null) throw var11_14;
                                try {
                                    var7_7.closeArchive();
                                    throw var11_14;
                                }
                                catch (IOException var12_13) {
                                    var12_13.printStackTrace();
                                }
                                throw var11_14;
                            }
                        }
                        try {}
                        catch (IOException v3) {}
                        var6_6.close();
                    }
                    if (var7_7 != null) {
                        ** try [egrp 5[TRYBLOCK] [10 : 373->381)] { 
lbl69:
                        // 1 sources

                        var7_7.closeArchive();
lbl71:
                        // 1 sources

                        catch (IOException var12_13) {
                            var12_13.printStackTrace();
                        }
                    }
                    break block31;
lbl-1000:
                    // 2 sources

                    {
                        var10_12 = null;
                        if (var6_6 == null) break block30;
                    }
                    try {}
                    catch (IOException v4) {}
                    var6_6.close();
                }
                if (var7_7 != null) {
                    ** try [egrp 5[TRYBLOCK] [10 : 373->381)] { 
lbl83:
                    // 1 sources

                    var7_7.closeArchive();
                    break block31;
lbl85:
                    // 1 sources

                    catch (IOException var12_13) {
                        var12_13.printStackTrace();
                    }
                }
            }
            ++var3_3;
        }
    }

    public SiteModel createSiteMapModel() {
        return new SiteFile();
    }

    public boolean canParseSiteType(String string) {
        return super.canParseSiteType(string) || "org.eclipse.update.core.file".equalsIgnoreCase(string) || "org.eclipse.ercp.update.file".equalsIgnoreCase(string);
    }
}

