/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.configurator.SiteEntry;
import org.eclipse.update.internal.configurator.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Configuration
implements IConfigurationConstants {
    private HashMap sites = new HashMap();
    private HashMap platformURLs = new HashMap();
    private Date date;
    private long lastModified;
    private URL url;
    private boolean transientConfig;
    private boolean isDirty;
    private Configuration linkedConfig;
    private URL associatedInstallURL = Utils.getInstallURL();

    public Configuration() {
        this(new Date());
        this.isDirty = true;
    }

    public Configuration(Date date) {
        this.date = date;
    }

    public void setURL(URL uRL) {
        this.url = uRL;
    }

    public URL getURL() {
        return this.url;
    }

    public void setLinkedConfig(Configuration configuration) {
        this.linkedConfig = configuration;
        SiteEntry[] siteEntryArray = configuration.getSites();
        int n = 0;
        while (n < siteEntryArray.length) {
            siteEntryArray[n].setUpdateable(false);
            ++n;
        }
    }

    public Configuration getLinkedConfig() {
        return this.linkedConfig;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    public void addSiteEntry(String string, SiteEntry siteEntry) {
        if (this.sites.get(string = Utils.canonicalizeURL(string)) == null && (this.linkedConfig == null || this.linkedConfig.sites.get(string) == null)) {
            siteEntry.setConfig(this);
            this.sites.put(string, siteEntry);
            if (string.startsWith("platform:")) {
                try {
                    URL uRL = new URL(string);
                    URL uRL2 = PlatformConfiguration.resolvePlatformURL(uRL, this.getInstallURL());
                    String string2 = uRL2.toExternalForm();
                    this.platformURLs.put(string2, uRL);
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void removeSiteEntry(String string) {
        string = Utils.canonicalizeURL(string);
        this.sites.remove(string);
        if (string.startsWith("platform:")) {
            try {
                URL uRL = new URL(string);
                URL uRL2 = PlatformConfiguration.resolvePlatformURL(uRL, this.getInstallURL());
                String string2 = uRL2.toExternalForm();
                this.platformURLs.remove(string2);
            }
            catch (IOException iOException) {}
        }
    }

    public SiteEntry getSiteEntry(String string) {
        SiteEntry siteEntry = (SiteEntry)this.sites.get(string = Utils.canonicalizeURL(string));
        if (siteEntry == null && this.linkedConfig != null) {
            siteEntry = this.linkedConfig.getSiteEntry(string);
        }
        return siteEntry;
    }

    public SiteEntry[] getSites() {
        if (this.linkedConfig == null) {
            return this.sites.values().toArray(new SiteEntry[this.sites.size()]);
        }
        ArrayList arrayList = new ArrayList(this.sites.values());
        arrayList.addAll(this.linkedConfig.sites.values());
        return arrayList.toArray(new SiteEntry[arrayList.size()]);
    }

    public Element toXML(Document document) throws CoreException {
        try {
            Element element = document.createElement("config");
            element.setAttribute("version", "3.0");
            element.setAttribute("date", String.valueOf(this.date.getTime()));
            String string = this.isTransient() ? "true" : "false";
            element.setAttribute("transient", string);
            if (this.linkedConfig != null) {
                element.setAttribute("shared_ur", Utils.makeRelative(this.getInstallURL(), this.linkedConfig.getURL()).toExternalForm());
            }
            SiteEntry[] siteEntryArray = this.sites.values().toArray(new SiteEntry[0]);
            int n = 0;
            while (n < siteEntryArray.length) {
                if (this.linkedConfig == null || this.linkedConfig.getSiteEntry(siteEntryArray[n].getURL().toExternalForm()) == null) {
                    Element element2 = siteEntryArray[n].toXML(document);
                    element.appendChild(element2);
                }
                ++n;
            }
            return element;
        }
        catch (Exception exception) {
            throw Utils.newCoreException("", exception);
        }
    }

    public boolean isTransient() {
        return this.transientConfig;
    }

    public void setTransient(boolean bl) {
        this.transientConfig = bl;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public boolean unconfigureFeatureEntry(IPlatformConfiguration.IFeatureEntry iFeatureEntry) {
        SiteEntry[] siteEntryArray = this.getSites();
        int n = 0;
        while (n < siteEntryArray.length) {
            if (siteEntryArray[n].unconfigureFeatureEntry(iFeatureEntry)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setLastModified(long l) {
        this.lastModified = l;
    }

    public long lastModified() {
        return this.lastModified != 0L ? this.lastModified : this.date.getTime();
    }

    public URL asPlatformURL(URL uRL) {
        try {
            if (uRL.getProtocol().equals("file")) {
                String string = uRL.toExternalForm();
                URL uRL2 = (URL)this.platformURLs.get(string);
                if (uRL2 == null) {
                    return uRL;
                }
                return uRL2;
            }
            return uRL;
        }
        catch (Exception exception) {
            return uRL;
        }
    }

    public URL getInstallURL() {
        return this.associatedInstallURL;
    }

    public void setInstallLocation(URL uRL) {
        this.associatedInstallURL = uRL;
    }
}

