/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.misc;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class ShowMessage {
    public static final int NONE = 0;
    public static final int ERROR = 1;
    public static final int INFORMATION = 2;
    public static final int QUESTION = 3;
    public static final int WARNING = 4;
    public String OK_LABEL = JFaceResources.getString((String)"ok");
    public String CANCEL_LABEL = JFaceResources.getString((String)"cancel");
    private static final String NESTING_INDENT = "  ";
    static String originalMessage;

    public static int openInformation(Shell shell, String string, String string2) {
        return ShowMessage.openBox(shell, string, string2, 34);
    }

    public static int openError(Shell shell, String string, String string2) {
        return ShowMessage.openBox(shell, string, string2, 33);
    }

    public static boolean openQuestion(Shell shell, String string, String string2) {
        return ShowMessage.openBox(shell, string, string2, 193) == 64;
    }

    public static int openWarning(Shell shell, String string, String string2) {
        return ShowMessage.openBox(shell, string, string2, 40);
    }

    public static int openBox(Shell shell, String string, String string2, int n) {
        Display display;
        Shell shell2 = null;
        if (shell != null) {
            shell2 = shell;
        } else {
            display = new Display();
            shell2 = new Shell(display);
        }
        display = new MessageBox(shell2, n);
        display.setText(string);
        display.setMessage(string2);
        return display.open();
    }

    public static void printError(String string, IStatus iStatus) {
        originalMessage = string == null ? iStatus.getMessage() : JFaceResources.format((String)"Reason", (Object[])new Object[]{string, iStatus.getMessage()});
        ShowMessage.printError(iStatus, 0, false);
    }

    public static void printError(IStatus iStatus, int n, boolean bl) {
        Object object;
        IStatus[] iStatusArray;
        Throwable throwable = iStatus.getException();
        boolean bl2 = throwable instanceof CoreException;
        boolean bl3 = false;
        if (bl) {
            iStatusArray = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                iStatusArray.append(NESTING_INDENT);
                ++n2;
            }
            object = iStatus.getMessage();
            iStatusArray.append((String)object);
            System.out.println(iStatusArray.toString());
            bl3 = true;
        }
        if (!bl2 && throwable != null) {
            iStatusArray = new StringBuffer();
            int n3 = 0;
            while (n3 < n) {
                iStatusArray.append(NESTING_INDENT);
                ++n3;
            }
            object = throwable.getLocalizedMessage();
            if (object == null) {
                object = ((Object)throwable).toString();
            }
            iStatusArray.append((String)object);
            System.out.println(iStatusArray.toString());
            bl3 = true;
        }
        if (bl3) {
            ++n;
        }
        if (bl2) {
            iStatusArray = (CoreException)throwable;
            object = iStatusArray.getStatus();
            if (originalMessage == null || originalMessage.indexOf(object.getMessage()) == -1) {
                ShowMessage.printError(object, n, true);
            }
        }
        iStatusArray = iStatus.getChildren();
        int n4 = 0;
        while (n4 < iStatusArray.length) {
            ShowMessage.printError(iStatusArray[n4], n, true);
            ++n4;
        }
    }
}

