/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public final class Util {
    public static final SortedMap EMPTY_SORTED_MAP = Collections.unmodifiableSortedMap(new TreeMap());
    public static final SortedSet EMPTY_SORTED_SET = Collections.unmodifiableSortedSet(new TreeSet());
    public static final String ZERO_LENGTH_STRING = "";

    public static String safeString(String string) {
        if (string != null) {
            return string;
        }
        return ZERO_LENGTH_STRING;
    }

    public static void assertInstance(Object object, Class clazz) {
        Util.assertInstance(object, clazz, false);
    }

    public static void assertInstance(Object object, Class clazz, boolean bl) {
        if (object == null && bl) {
            return;
        }
        if (object == null || clazz == null) {
            throw new NullPointerException();
        }
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException();
        }
    }

    public static int compare(boolean bl, boolean bl2) {
        return !bl ? (bl2 ? -1 : 0) : 1;
    }

    public static int compare(Comparable comparable, Comparable comparable2) {
        if (comparable == null && comparable2 == null) {
            return 0;
        }
        if (comparable == null) {
            return -1;
        }
        if (comparable2 == null) {
            return 1;
        }
        return comparable.compareTo(comparable2);
    }

    public static int compare(Comparable[] comparableArray, Comparable[] comparableArray2) {
        if (comparableArray == null && comparableArray2 == null) {
            return 0;
        }
        if (comparableArray == null) {
            return -1;
        }
        if (comparableArray2 == null) {
            return 1;
        }
        int n = comparableArray.length;
        int n2 = comparableArray2.length;
        if (n != n2) {
            return n - n2;
        }
        int n3 = 0;
        while (n3 < n) {
            int n4 = Util.compare(comparableArray[n3], comparableArray2[n3]);
            if (n4 != 0) {
                return n4;
            }
            ++n3;
        }
        return 0;
    }

    public static int compare(int n, int n2) {
        return n - n2;
    }

    public static int compare(List list, List list2) {
        int n;
        if (list == null && list2 == null) {
            return 0;
        }
        if (list == null) {
            return -1;
        }
        if (list2 == null) {
            return 1;
        }
        int n2 = list.size();
        if (n2 != (n = list2.size())) {
            return n2 - n;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = Util.compare((Comparable)list.get(n3), (Comparable)list2.get(n3));
            if (n4 != 0) {
                return n4;
            }
            ++n3;
        }
        return 0;
    }

    public static int compare(Object object, Object object2) {
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        return object.toString().compareTo(object2.toString());
    }

    public static final int compareIdentity(Object object, Object object2) {
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        return System.identityHashCode(object) - System.identityHashCode(object2);
    }

    public static void diff(Map map, Map map2, Set set, Set set2, Set set3) {
        Object k;
        if (map == null || map2 == null || set == null || set2 == null || set3 == null) {
            throw new NullPointerException();
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            k = iterator.next();
            if (!map2.containsKey(k)) {
                set.add(k);
                continue;
            }
            if (Util.equals(map.get(k), map2.get(k))) continue;
            set2.add(k);
        }
        iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            k = iterator.next();
            if (map.containsKey(k)) continue;
            set3.add(k);
        }
    }

    public static void diff(Set set, Set set2, Set set3, Set set4) {
        Object e;
        if (set == null || set2 == null || set3 == null || set4 == null) {
            throw new NullPointerException();
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (set2.contains(e)) continue;
            set3.add(e);
        }
        iterator = set2.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (set.contains(e)) continue;
            set4.add(e);
        }
    }

    public static boolean endsWith(List list, List list2, boolean bl) {
        if (list == null || list2 == null) {
            return false;
        }
        int n = list.size();
        int n2 = list2.size();
        if (n2 > n || !bl && n2 == n) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (!Util.equals(list.get(n - n3 - 1), list2.get(n2 - n3 - 1))) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean endsWith(Object[] objectArray, Object[] objectArray2, boolean bl) {
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n = objectArray2.length;
        int n2 = objectArray.length;
        if (n > n2 || !bl && n == n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            if (!Util.equals(objectArray[n2 - n3 - 1], objectArray2[n - n3 - 1])) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean equals(boolean bl, boolean bl2) {
        return bl == bl2;
    }

    public static boolean equals(int n, int n2) {
        return n == n2;
    }

    public static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object2 != null && object.equals(object2);
    }

    public static int hashCode(boolean bl) {
        return bl ? ((Object)Boolean.TRUE).hashCode() : ((Object)Boolean.FALSE).hashCode();
    }

    public static int hashCode(int n) {
        return n;
    }

    public static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    public static Collection safeCopy(Collection collection, Class clazz) {
        return Util.safeCopy(collection, clazz, false);
    }

    public static Collection safeCopy(Collection collection, Class clazz, boolean bl) {
        if (collection == null || clazz == null) {
            throw new NullPointerException();
        }
        collection = Collections.unmodifiableCollection(new ArrayList(collection));
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Util.assertInstance(iterator.next(), clazz, bl);
        }
        return collection;
    }

    public static List safeCopy(List list, Class clazz) {
        return Util.safeCopy(list, clazz, false);
    }

    public static List safeCopy(List list, Class clazz, boolean bl) {
        if (list == null || clazz == null) {
            throw new NullPointerException();
        }
        list = Collections.unmodifiableList(new ArrayList(list));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Util.assertInstance(iterator.next(), clazz, bl);
        }
        return list;
    }

    public static Map safeCopy(Map map, Class clazz, Class clazz2) {
        return Util.safeCopy(map, clazz, clazz2, false, false);
    }

    public static Map safeCopy(Map map, Class clazz, Class clazz2, boolean bl, boolean bl2) {
        if (map == null || clazz == null || clazz2 == null) {
            throw new NullPointerException();
        }
        map = Collections.unmodifiableMap(new HashMap(map));
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Util.assertInstance(entry.getKey(), clazz, bl);
            Util.assertInstance(entry.getValue(), clazz2, bl2);
        }
        return map;
    }

    public static Set safeCopy(Set set, Class clazz) {
        return Util.safeCopy(set, clazz, false);
    }

    public static Set safeCopy(Set set, Class clazz, boolean bl) {
        if (set == null || clazz == null) {
            throw new NullPointerException();
        }
        set = Collections.unmodifiableSet(new HashSet(set));
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Util.assertInstance(iterator.next(), clazz, bl);
        }
        return set;
    }

    public static SortedMap safeCopy(SortedMap sortedMap, Class clazz, Class clazz2) {
        return Util.safeCopy(sortedMap, clazz, clazz2, false, false);
    }

    public static SortedMap safeCopy(SortedMap sortedMap, Class clazz, Class clazz2, boolean bl, boolean bl2) {
        if (sortedMap == null || clazz == null || clazz2 == null) {
            throw new NullPointerException();
        }
        sortedMap = Collections.unmodifiableSortedMap(new TreeMap(sortedMap));
        Iterator iterator = sortedMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Util.assertInstance(entry.getKey(), clazz, bl);
            Util.assertInstance(entry.getValue(), clazz2, bl2);
        }
        return sortedMap;
    }

    public static SortedSet safeCopy(SortedSet sortedSet, Class clazz) {
        return Util.safeCopy(sortedSet, clazz, false);
    }

    public static SortedSet safeCopy(SortedSet sortedSet, Class clazz, boolean bl) {
        if (sortedSet == null || clazz == null) {
            throw new NullPointerException();
        }
        sortedSet = Collections.unmodifiableSortedSet(new TreeSet(sortedSet));
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            Util.assertInstance(iterator.next(), clazz, bl);
        }
        return sortedSet;
    }

    public static boolean startsWith(List list, List list2, boolean bl) {
        if (list == null || list2 == null) {
            return false;
        }
        int n = list.size();
        int n2 = list2.size();
        if (n2 > n || !bl && n2 == n) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (!Util.equals(list.get(n3), list2.get(n3))) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean startsWith(Object[] objectArray, Object[] objectArray2, boolean bl) {
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n = objectArray2.length;
        int n2 = objectArray.length;
        if (n > n2 || !bl && n == n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            if (!Util.equals(objectArray[n3], objectArray2[n3])) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static String translateString(ResourceBundle resourceBundle, String string) {
        return Util.translateString(resourceBundle, string, string, true, true);
    }

    public static String translateString(ResourceBundle resourceBundle, String string, String string2, boolean bl, boolean bl2) {
        block4: {
            if (resourceBundle != null && string != null) {
                try {
                    String string3 = resourceBundle.getString(string);
                    if (string3 != null) {
                        return bl2 ? string3.trim() : string3;
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    if (!bl) break block4;
                    System.err.println(missingResourceException);
                }
            }
        }
        return bl2 ? string2.trim() : string2;
    }

    public static void arrayCopyWithRemoval(Object[] objectArray, Object[] objectArray2, int n) {
        if (objectArray == null || objectArray2 == null || objectArray.length - 1 != objectArray2.length || n < 0 || n >= objectArray.length) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            System.arraycopy(objectArray, 1, objectArray2, 0, objectArray.length - 1);
        } else if (n == objectArray.length - 1) {
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length - 1);
        } else {
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
            System.arraycopy(objectArray, n + 1, objectArray2, n, objectArray.length - n - 1);
        }
    }

    public static Object[] appendArray(Object[] objectArray, Object[] objectArray2) {
        Object[] objectArray3 = new Object[objectArray.length + objectArray2.length];
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
        return objectArray3;
    }

    private Util() {
    }

    public static String intern(String string) {
        return string == null ? null : string.intern();
    }
}

