/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.BaseFeatureFactory;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.FeatureModel;
import org.eclipse.update.internal.core.FeatureExecutableContentConsumer;
import org.eclipse.update.internal.core.FeatureExecutableContentProvider;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.TargetFeature;
import org.eclipse.update.internal.core.URLEncoder;
import org.eclipse.update.internal.core.connection.ConnectionFactory;

public class FeatureExecutableFactory
extends BaseFeatureFactory {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IFeature createFeature(URL uRL, ISite iSite, IProgressMonitor iProgressMonitor) throws CoreException {
        TargetFeature targetFeature = null;
        InputStream inputStream = null;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        if (uRL == null) {
            return this.createFeature(iSite);
        }
        uRL = this.validate(uRL);
        try {
            try {
                FeatureExecutableContentProvider featureExecutableContentProvider = new FeatureExecutableContentProvider(uRL);
                FeatureExecutableContentConsumer featureExecutableContentConsumer = new FeatureExecutableContentConsumer();
                URL uRL2 = featureExecutableContentProvider.getFeatureManifestReference(null).asURL();
                URL uRL3 = URLEncoder.encode(uRL2);
                inputStream = ConnectionFactory.get(uRL3).getInputStream();
                targetFeature = (TargetFeature)this.parseFeature(inputStream, uRL3.toExternalForm());
                iProgressMonitor.worked(1);
                targetFeature.setSite(iSite);
                targetFeature.setFeatureContentProvider(featureExecutableContentProvider);
                targetFeature.setContentConsumer(featureExecutableContentConsumer);
                targetFeature.resolve(uRL, uRL);
                targetFeature.markReadOnly();
            }
            catch (CoreException coreException) {
                throw coreException;
            }
            catch (Exception exception) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.FeatureFactory_CreatingError, (Object[])new String[]{uRL.toExternalForm()}), exception);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            try {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var10_14 = null;
        }
        try {}
        catch (IOException iOException) {
            return targetFeature;
        }
        if (inputStream == null) return targetFeature;
        inputStream.close();
        return targetFeature;
    }

    public FeatureModel createFeatureModel() {
        return new TargetFeature();
    }

    private IFeature createFeature(ISite iSite) throws CoreException {
        TargetFeature targetFeature = null;
        FeatureExecutableContentProvider featureExecutableContentProvider = new FeatureExecutableContentProvider(null);
        FeatureExecutableContentConsumer featureExecutableContentConsumer = new FeatureExecutableContentConsumer();
        targetFeature = (TargetFeature)this.createFeatureModel();
        targetFeature.setSite(iSite);
        targetFeature.setFeatureContentProvider(featureExecutableContentProvider);
        targetFeature.setContentConsumer(featureExecutableContentConsumer);
        return targetFeature;
    }

    private URL validate(URL uRL) throws CoreException {
        if (uRL == null) {
            throw Utilities.newCoreException(Messages.FeatureExecutableFactory_NullURL, null);
        }
        if (!(uRL.getFile().endsWith("/") || uRL.getFile().endsWith(File.separator) || uRL.getFile().endsWith("feature.xml"))) {
            try {
                String string = String.valueOf(uRL.getFile()) + "/";
                uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string);
            }
            catch (MalformedURLException malformedURLException) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.FeatureExecutableFactory_CannotCreateURL, (Object[])new String[]{uRL.toExternalForm()}), malformedURLException);
            }
        }
        return uRL;
    }
}

