/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.internal.core.FeaturePlugin;
import org.eclipse.update.internal.core.UpdateCore;

public class PatchedFeature {
    private IFeatureReference feature;
    private Collection patches = new HashSet();

    public PatchedFeature(IFeatureReference iFeatureReference) {
        this.feature = iFeatureReference;
    }

    public void addPatch(IFeatureReference iFeatureReference) {
        this.patches.add(iFeatureReference);
    }

    public IFeatureReference getFeature() {
        return this.feature;
    }

    public IFeatureReference[] getPatches() {
        return this.patches.toArray(new IFeatureReference[this.patches.size()]);
    }

    public IFeatureReference[] getFeatureAndPatches() {
        IFeatureReference[] iFeatureReferenceArray = new IFeatureReference[this.patches.size() + 1];
        iFeatureReferenceArray[0] = this.feature;
        System.arraycopy(this.getPatches(), 0, iFeatureReferenceArray, 1, this.patches.size());
        return iFeatureReferenceArray;
    }

    public FeaturePlugin[] getPlugins() {
        HashMap<String, FeaturePlugin> hashMap = new HashMap<String, FeaturePlugin>();
        IFeatureReference[] iFeatureReferenceArray = this.getFeatureAndPatches();
        int n = 0;
        while (n < iFeatureReferenceArray.length) {
            try {
                IFeature iFeature = iFeatureReferenceArray[n].getFeature(null);
                if (iFeature == null) {
                    UpdateCore.warn("Null Feature", new Exception());
                } else {
                    IPluginEntry[] iPluginEntryArray = iFeature.getPluginEntries();
                    int n2 = 0;
                    while (n2 < iPluginEntryArray.length) {
                        String string = iPluginEntryArray[n2].getVersionedIdentifier().getIdentifier();
                        PluginVersionIdentifier pluginVersionIdentifier = iPluginEntryArray[n2].getVersionedIdentifier().getVersion();
                        FeaturePlugin featurePlugin = (FeaturePlugin)hashMap.get(string);
                        if (featurePlugin == null || !featurePlugin.getEntry().getVersionedIdentifier().getVersion().isGreaterOrEqualTo(pluginVersionIdentifier)) {
                            hashMap.put(string, new FeaturePlugin(iPluginEntryArray[n2], iFeature));
                        }
                        ++n2;
                    }
                }
            }
            catch (CoreException coreException) {
                UpdateCore.warn(null, coreException);
            }
            ++n;
        }
        return hashMap.values().toArray(new FeaturePlugin[hashMap.size()]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.feature.toString());
        IFeatureReference[] iFeatureReferenceArray = this.getFeatureAndPatches();
        int n = 0;
        while (n < iFeatureReferenceArray.length) {
            stringBuffer.append(" +patch=" + iFeatureReferenceArray[n].toString() + " ");
            ++n;
        }
        return ((Object)stringBuffer).toString();
    }
}

