/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.model;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.core.Assert;
import org.eclipse.update.internal.core.BaseSiteLocalFactory;
import org.eclipse.update.internal.core.InstallConfiguration;
import org.eclipse.update.internal.core.LocalSite;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.InstallConfigurationModel;
import org.eclipse.update.internal.model.SiteLocalModel;

public class SiteLocalParser {
    private PlatformConfiguration platformConfig;
    private SiteLocalModel site;
    public static final String CONFIG = "config";
    private ResourceBundle bundle;
    private BaseSiteLocalFactory factory = new BaseSiteLocalFactory();

    private ResourceBundle getResourceBundle() throws CoreException {
        ResourceBundle resourceBundle = null;
        URL uRL = null;
        try {
            uRL = UpdateManagerUtils.asDirectoryURL(this.site.getLocationURL());
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL}, null);
            resourceBundle = ResourceBundle.getBundle("platform", Locale.getDefault(), uRLClassLoader);
        }
        catch (MissingResourceException missingResourceException) {
            UpdateCore.warn(String.valueOf(missingResourceException.getLocalizedMessage()) + ":" + uRL.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            UpdateCore.warn(malformedURLException.getLocalizedMessage());
        }
        return resourceBundle;
    }

    public SiteLocalParser(IPlatformConfiguration iPlatformConfiguration, ILocalSite iLocalSite) throws IOException, CoreException {
        Assert.isTrue(iPlatformConfiguration instanceof PlatformConfiguration);
        this.platformConfig = (PlatformConfiguration)iPlatformConfiguration;
        Assert.isTrue(iLocalSite instanceof SiteLocalModel);
        this.site = (SiteLocalModel)((Object)iLocalSite);
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            UpdateCore.debug("Start parsing localsite:" + ((SiteLocalModel)((Object)iLocalSite)).getLocationURLString());
        }
        this.bundle = this.getResourceBundle();
        this.processConfig();
    }

    private void processConfig() throws MalformedURLException, CoreException {
        String string = ((Object)this.platformConfig.getConfiguration().getDate()).toString();
        string = UpdateManagerUtils.getResourceString(string, this.bundle);
        this.site.setLabel(string);
        URL uRL = this.site.getLocationURL();
        InstallConfigurationModel installConfigurationModel = this.factory.createInstallConfigurationModel();
        installConfigurationModel.setLocationURLString(uRL.toExternalForm());
        installConfigurationModel.setLabel(string);
        installConfigurationModel.resolve(uRL, this.site.getResourceBundleURL());
        ((LocalSite)this.site).addConfiguration((InstallConfiguration)installConfigurationModel);
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            UpdateCore.debug("End Processing Config Tag: url:" + uRL.toExternalForm());
        }
    }
}

