/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.operations.FeatureOperation;
import org.eclipse.update.internal.operations.IUnconfigureAndUninstallFeatureOperation;
import org.eclipse.update.operations.IOperationListener;
import org.eclipse.update.operations.IUnconfigFeatureOperation;
import org.eclipse.update.operations.OperationsManager;

public class UnconfigureAndUninstallFeatureOperation
extends FeatureOperation
implements IUnconfigureAndUninstallFeatureOperation {
    public UnconfigureAndUninstallFeatureOperation(IConfiguredSite iConfiguredSite, IFeature iFeature) {
        super(iConfiguredSite, iFeature);
    }

    public boolean execute(IProgressMonitor iProgressMonitor, IOperationListener iOperationListener) throws CoreException, InvocationTargetException {
        IUnconfigFeatureOperation iUnconfigFeatureOperation = OperationsManager.getOperationFactory().createUnconfigOperation(this.targetSite, this.feature);
        iUnconfigFeatureOperation.execute(iProgressMonitor, iOperationListener);
        URL uRL = ConfiguratorUtils.getCurrentPlatformConfiguration().getConfigurationLocation();
        File file = new File(uRL.getFile());
        file = new File(file.getParentFile(), "toBeUninstalled");
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            properties.put(((Object)new Integer(properties.size() + 1)).toString(), this.targetSite.getSite().getURL() + ";" + this.feature.getVersionedIdentifier().toString());
            fileInputStream.close();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, "to be uninstalled on start-up");
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
        return true;
    }
}

