/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class CaptionedControl
extends Composite {
    private Label imageLabel;
    private Label titleLabel;
    private Label trailLabel;
    private Control child;
    private final int margin = 5;
    private final int spacing = 1;
    private CaptionedControlLayout layout;

    public CaptionedControl(Composite composite, int n) {
        super(composite, CaptionedControl.checkBits(n, 256, 512, 0, 0, 0, 0));
        if (composite instanceof CaptionedControl) {
            SWT.error(32);
        }
        this.scrollAreaHandle = 0;
        this.imageLabel = new Label(this, 0x1000000);
        this.titleLabel = new Label(this, 0x1000000);
        this.trailLabel = new Label(this, 0x1000000);
        this.layout = new CaptionedControlLayout();
        super.setLayout(this.layout);
        this.layout();
    }

    protected void addControl(Control control) {
        this.child = control;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (bl) {
            OS.QWidget_updateGeometry(this.internal_topHandle());
        }
        if (this.layout != null) {
            return this.layout.computeSize(this, n, n2, bl);
        }
        return new Point(64, 64);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        if (this.layout != null) {
            CaptionedControlLayoutData captionedControlLayoutData = this.layout.getData();
            if ((this.getStyle() & 0x100) != 0) {
                rectangle.width = captionedControlLayoutData.img.x + captionedControlLayoutData.title.x + captionedControlLayoutData.trail.x + n3;
                rectangle.height = n4;
            } else {
                rectangle.width = captionedControlLayoutData.trail.x + Math.max(captionedControlLayoutData.row1.x, n3);
                rectangle.height = captionedControlLayoutData.row1.y + n4;
            }
        } else {
            rectangle.width = n3;
            rectangle.height = n4;
        }
        rectangle.x = n;
        rectangle.y = n2;
        rectangle.width += 10;
        rectangle.height += 10;
        return rectangle;
    }

    protected void createHandle(int n) {
        this.handle = OS.QCaptionedWidget_new();
        int n2 = OS.QWidget_focusPolicy(this.handle) & 0xFFFFFFFD;
        OS.QWidget_setFocusPolicy(this.handle, n2 |= 1);
        this.state |= 8;
        this.state &= 0xFFFFFFFD;
    }

    protected void doRedraw() {
        OS.QWidget_update(this.internal_topHandle());
    }

    protected void doRedraw(int n, int n2, int n3, int n4) {
        OS.QWidget_update(this.internal_topHandle(), n, n2, n3, n4);
    }

    public Control[] getChildren() {
        this.checkWidget();
        Control[] controlArray = super.getChildren();
        Control[] controlArray2 = new Control[controlArray.length - 3];
        int n = 0;
        for (int i = 0; i < controlArray.length; ++i) {
            if (controlArray[i] == this.imageLabel || controlArray[i] == this.titleLabel || controlArray[i] == this.trailLabel) continue;
            controlArray2[n] = controlArray[i];
            ++n;
        }
        return controlArray2;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        Point point = this.getSize();
        point.x -= 10;
        point.y -= 10;
        if (this.layout != null) {
            CaptionedControlLayoutData captionedControlLayoutData = this.layout.getData();
            if ((this.getStyle() & 0x100) != 0) {
                rectangle.width = point.x - captionedControlLayoutData.img.x - captionedControlLayoutData.title.x - captionedControlLayoutData.trail.x;
                rectangle.height = point.y;
            } else {
                rectangle.width = point.x - captionedControlLayoutData.trail.x;
                rectangle.height = point.y - captionedControlLayoutData.row1.y;
            }
        } else {
            rectangle.width = point.x;
            rectangle.height = point.y;
        }
        rectangle.x = 0;
        rectangle.y = 0;
        return rectangle;
    }

    public Image getImage() {
        this.checkWidget();
        return this.imageLabel.getImage();
    }

    public String getText() {
        this.checkWidget();
        return this.titleLabel.getText();
    }

    public String getTrailingText() {
        this.checkWidget();
        return this.trailLabel.getText();
    }

    protected int internal_frameHandle() {
        return this.handle;
    }

    public int internal_topHandle() {
        return this.handle;
    }

    protected void removeControl(Control control) {
        if (control != null && control == this.child) {
            this.child = null;
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image == null) {
            SWT.error(4);
        }
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        this.imageLabel.setImage(image);
        this.layout();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        this.titleLabel.setText(string);
        this.layout();
    }

    public void setTrailingText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        this.trailLabel.setText(string);
        this.layout();
    }

    class CaptionedControlLayoutData {
        Point img = new Point(0, 0);
        Point title = new Point(0, 0);
        Point trail = new Point(0, 0);
        Point child = new Point(0, 0);
        Point row1 = new Point(0, 0);
        Point row2 = new Point(0, 0);

        CaptionedControlLayoutData() {
        }
    }

    class CaptionedControlLayout
    extends Layout {
        CaptionedControlLayout() {
        }

        protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
            Point point = new Point(0, 0);
            CaptionedControlLayoutData captionedControlLayoutData = this.getData();
            if ((CaptionedControl.this.getStyle() & 0x100) != 0) {
                point.x = n == -1 ? captionedControlLayoutData.row1.x : captionedControlLayoutData.row1.x - captionedControlLayoutData.child.x + n;
                point.y = n2 == -1 ? captionedControlLayoutData.row1.y : n2;
            } else {
                point.x = n == -1 ? Math.max(captionedControlLayoutData.row1.x, captionedControlLayoutData.row2.x) : Math.max(captionedControlLayoutData.row1.x, captionedControlLayoutData.trail.x + n);
                point.y = n2 == -1 ? captionedControlLayoutData.row1.y + captionedControlLayoutData.row2.y : captionedControlLayoutData.row1.y + Math.max(n2, captionedControlLayoutData.trail.y);
            }
            point.x += 10;
            point.y += 10;
            return point;
        }

        protected void layout(Composite composite, boolean bl) {
            CaptionedControlLayoutData captionedControlLayoutData = this.getData();
            Point point = composite.getSize();
            if (point.x <= 0 || point.y <= 0) {
                return;
            }
            int n = 5;
            int n2 = 5;
            int n3 = point.x - 10;
            int n4 = 0;
            n4 = (CaptionedControl.this.getStyle() & 0x100) != 0 ? point.y - 10 : captionedControlLayoutData.row1.y;
            if (n4 < 0) {
                n4 = 0;
            }
            CaptionedControl.this.imageLabel.setBounds(n, n2, captionedControlLayoutData.img.x, n4);
            CaptionedControl.this.titleLabel.setBounds(n += captionedControlLayoutData.img.x, n2, captionedControlLayoutData.title.x, n4);
            n += captionedControlLayoutData.title.x;
            if ((CaptionedControl.this.getStyle() & 0x200) != 0) {
                n2 += n4;
                if ((n4 = point.y - 10 - n4) < 0) {
                    n4 = 0;
                }
                n = 5;
            }
            int n5 = 0;
            if (CaptionedControl.this.child != null) {
                n5 = (CaptionedControl.this.getStyle() & 0x100) != 0 ? n3 - captionedControlLayoutData.img.x - captionedControlLayoutData.title.x - captionedControlLayoutData.trail.x : n3 - captionedControlLayoutData.trail.x;
                if (n5 < 0) {
                    n5 = 0;
                }
                CaptionedControl.this.child.setBounds(n, n2, n5, n4);
                n += n5;
            }
            CaptionedControl.this.trailLabel.setBounds(n, n2, captionedControlLayoutData.trail.x, n4);
        }

        protected CaptionedControlLayoutData getData() {
            String string;
            String string2;
            CaptionedControlLayoutData captionedControlLayoutData = new CaptionedControlLayoutData();
            int n = 2;
            if (CaptionedControl.this.imageLabel.getImage() != null) {
                captionedControlLayoutData.img = CaptionedControl.this.imageLabel.computeSize(-1, -1);
            }
            if ((string2 = CaptionedControl.this.titleLabel.getText()) != null && string2.length() > 0) {
                captionedControlLayoutData.title = CaptionedControl.this.titleLabel.computeSize(-1, -1);
            }
            if ((string = CaptionedControl.this.trailLabel.getText()) != null && string.length() > 0) {
                captionedControlLayoutData.trail = CaptionedControl.this.trailLabel.computeSize(-1, -1);
            }
            if (CaptionedControl.this.child != null) {
                captionedControlLayoutData.child = CaptionedControl.this.child.computeSize(-1, -1);
            }
            if (captionedControlLayoutData.img.x > 0 && captionedControlLayoutData.img.y > 0) {
                captionedControlLayoutData.img.x += n;
                captionedControlLayoutData.img.y += n;
            }
            if (captionedControlLayoutData.title.x > 0 && captionedControlLayoutData.title.y > 0) {
                captionedControlLayoutData.title.x += n;
                captionedControlLayoutData.title.y += n;
            }
            if (captionedControlLayoutData.trail.x > 0 && captionedControlLayoutData.trail.y > 0) {
                captionedControlLayoutData.trail.x += n;
                captionedControlLayoutData.trail.y += n;
            }
            if ((CaptionedControl.this.getStyle() & 0x100) != 0) {
                captionedControlLayoutData.row1.x = captionedControlLayoutData.img.x + captionedControlLayoutData.title.x + captionedControlLayoutData.child.x + captionedControlLayoutData.trail.x;
                captionedControlLayoutData.row1.y = Math.max(captionedControlLayoutData.row1.y, captionedControlLayoutData.img.y);
                captionedControlLayoutData.row1.y = Math.max(captionedControlLayoutData.row1.y, captionedControlLayoutData.title.y);
                captionedControlLayoutData.row1.y = Math.max(captionedControlLayoutData.row1.y, captionedControlLayoutData.trail.y);
                captionedControlLayoutData.row1.y = Math.max(captionedControlLayoutData.row1.y, captionedControlLayoutData.child.y);
            } else {
                captionedControlLayoutData.row1.x = captionedControlLayoutData.img.x + captionedControlLayoutData.title.x;
                captionedControlLayoutData.row1.y = Math.max(captionedControlLayoutData.row1.y, captionedControlLayoutData.img.y);
                captionedControlLayoutData.row1.y = Math.max(captionedControlLayoutData.row1.y, captionedControlLayoutData.title.y);
                captionedControlLayoutData.row2.x = captionedControlLayoutData.child.x + captionedControlLayoutData.trail.x;
                captionedControlLayoutData.row2.y = Math.max(captionedControlLayoutData.row2.y, captionedControlLayoutData.trail.y);
                captionedControlLayoutData.row2.y = Math.max(captionedControlLayoutData.row2.y, captionedControlLayoutData.child.y);
            }
            return captionedControlLayoutData;
        }
    }
}

