/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.qt.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class DateEditor
extends Control {
    public static final int DATE = 1;
    public static final int TIME = 2;
    public static final int DATE_TIME = 3;
    public static final int DURATION = 4;
    public static final int OFFSET = 5;
    public static final int COMPACT = 16;
    public static final int FULL = 32;
    TimeZone timeZone;
    boolean ignoreModify;
    int editorHandle;
    boolean textVisible;
    int calendarHandle;
    private static final int MAXIMUM_OFFSET = 86399;
    private static final int MINIMUM_OFFSET = -86399;
    private static final String DURATION_FORMAT = "hh:mm:ss";

    public DateEditor(Composite composite, int n) {
        this(composite, n, 17);
    }

    public DateEditor(Composite composite, int n, int n2) {
        super(composite, DateEditor.checkBits(n, 0, 0, 0, 0, 0, 0), DateEditor.checkStyle(n2));
    }

    void setDateTime(Calendar calendar) {
        int[] nArray = new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13)};
        this.ignoreModify = true;
        OS.QDateTimeEdit_swt_setDateTime(this.internal_topHandle(), nArray);
        this.ignoreModify = false;
    }

    static int checkStyle(int n) {
        int n2 = n & 0xF;
        int n3 = n & 0xF0;
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        n3 = DateEditor.checkBits(n3, 16, 32, 0, 0, 0, 0);
        return n3 | n2;
    }

    protected void createHandle(int n) {
        int n2 = this.extraStyle & 0xF;
        switch (n2) {
            case 5: {
                this.handle = OS.QOffsetTimeEdit_new();
                OS.QOffsetTimeEdit_setMinimum(this.handle, -86399);
                OS.QOffsetTimeEdit_setMaximum(this.handle, 86399);
                this._setTime(0);
                break;
            }
            case 4: {
                this.handle = OS.QSwtTimeEdit_swt_new(n2);
                OS.QDateTimeEdit_setDisplayFormat(this.handle, DURATION_FORMAT);
                this._setTime(0);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.handle = OS.QSwtTimeEdit_swt_new(n2);
                this._setDate(new Date());
            }
        }
        this.state |= 8;
        this.editorHandle = OS.QSwtTimeEdit_editor(this.handle);
        if ((this.extraStyle & 0xF0) == 32) {
            OS.QDateTimeEdit_setCalendarPopup(this.handle, true);
            this.calendarHandle = OS.QDateTimeEdit_calendarWidget(this.handle);
        } else {
            this.calendarHandle = 0;
        }
        OS.QWidget_sizeHint(this.handle);
        OS.QSwtTimeEdit_swt_setTextVisible(this.handle, false);
        this.textVisible = false;
    }

    protected void register() {
        super.register();
        this.addWidget(this.editorHandle);
        this.addWidget(this.calendarHandle);
    }

    protected void deregister() {
        this.removeWidget(this.calendarHandle);
        this.removeWidget(this.editorHandle);
        super.deregister();
    }

    protected void releaseHandle() {
        this.editorHandle = 0;
        this.calendarHandle = 0;
        super.releaseHandle();
    }

    protected void hookEvents() {
        int n = OS.SignalHandler_new(this.handle, this.display, 1022);
        OS.QObject_connectOrThrow(this.handle, "dateTimeChanged(const QDateTime&)", n, "widgetSignal(const QDateTime&)", 0);
    }

    protected void qt_signal_dateedit_dateTimeChanged() {
        if (!this.textVisible) {
            this.textVisible = true;
            OS.QSwtTimeEdit_swt_setTextVisible(this.internal_topHandle(), true);
        }
        if (!this.ignoreModify) {
            this.sendEvent(24);
        }
    }

    protected boolean qt_event_mouseButtonPress(int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = super.qt_event_mouseButtonPress(n, n2, n3, n4, n5, n6);
        this.sendEvent(13);
        return bl;
    }

    protected boolean qt_event_mouseButtonDblClick(int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = super.qt_event_mouseButtonDblClick(n, n2, n3, n4, n5, n6);
        if (n2 == 1) {
            this.sendEvent(14);
        }
        return bl;
    }

    protected boolean qt_event_keypress(int n, int n2, int n3, int n4) {
        if (super.qt_event_keypress(n, n2, n3, n4)) {
            return true;
        }
        if (n2 == 0x1000004) {
            this.sendEvent(14);
        } else if (this.isSelectionKey(0, n4)) {
            this.sendEvent(13);
        }
        return false;
    }

    Calendar getCalendar(boolean bl) {
        if (!bl && this.timeZone != null) {
            return Calendar.getInstance(this.timeZone);
        }
        return Calendar.getInstance();
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public Date getDate() {
        this.checkWidget();
        int n = this.extraStyle & 0xF;
        if (n == 5 || n == 4) {
            return null;
        }
        Calendar calendar = this.getCalendar(true);
        int[] nArray = OS.QDateTimeEdit_swt_dateTime(this.internal_topHandle());
        calendar.set(1, nArray[0]);
        calendar.set(2, nArray[1] - 1);
        calendar.set(5, nArray[2]);
        calendar.set(11, nArray[3]);
        calendar.set(12, nArray[4]);
        calendar.set(13, nArray[5]);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public int getTime() {
        this.checkWidget();
        int n = 0;
        int n2 = this.extraStyle & 0xF;
        if (n2 == 2 || n2 == 4) {
            int[] nArray = OS.QDateTimeEdit_swt_dateTime(this.internal_topHandle());
            n = nArray[3] * 3600 + nArray[4] * 60 + nArray[5];
        } else if (n2 == 5) {
            n = OS.QOffsetTimeEdit_offset(this.internal_topHandle());
        }
        return n;
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        this.removeListener(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.removeListener(13, selectionListener);
        this.removeListener(14, selectionListener);
    }

    public void setDate(Date date) {
        this.checkWidget();
        if (date == null) {
            SWT.error(4);
        }
        if (!this.textVisible) {
            OS.QSwtTimeEdit_swt_setTextVisible(this.internal_topHandle(), true);
        }
        this._setDate(date);
        if (!this.textVisible) {
            OS.QLineEdit_setSelection(this.editorHandle, 2, -2);
            this.textVisible = true;
        }
    }

    void _setDate(Date date) {
        Calendar calendar = null;
        if (date != null) {
            calendar = this.getCalendar(false);
            calendar.setTime(date);
        }
        this.setDateTime(calendar);
    }

    public void setTime(int n) {
        this.checkWidget();
        int n2 = this.extraStyle & 0xF;
        if (n2 == 5 && (n > 86399 || n < -86399)) {
            SWT.error(5);
        }
        if (!(n2 != 2 && n2 != 4 || n <= 86399 && n >= 0)) {
            SWT.error(5);
        }
        if (!this.textVisible) {
            OS.QSwtTimeEdit_swt_setTextVisible(this.internal_topHandle(), true);
        }
        this._setTime(n);
        if (!this.textVisible) {
            if (n2 == 1 || n2 == 3) {
                this._setDate(this.getDate());
            }
            OS.QLineEdit_setSelection(this.editorHandle, 2, -2);
            this.textVisible = true;
        }
    }

    void _setTime(int n) {
        int n2 = this.extraStyle & 0xF;
        if (n2 == 2 || n2 == 4) {
            Calendar calendar = this.getCalendar(true);
            if (calendar != null) {
                calendar.setTime(new Date());
                int n3 = n / 3600;
                int n4 = n % 3600 / 60;
                int n5 = n % 3600 % 60;
                calendar.set(11, n3);
                calendar.set(12, n4);
                calendar.set(13, n5);
                this.setDateTime(calendar);
            }
        } else if (n2 == 5) {
            OS.QOffsetTimeEdit_setOffset(this.internal_topHandle(), n);
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        this.checkWidget();
        this.timeZone = timeZone;
        int n = this.extraStyle & 0xF;
        if (n == 1 || n == 3 || n == 2) {
            this.setDate(this.getDate());
        }
    }

    protected void setTraversalFlags(int n, int n2, int n3, int n4) {
        this.traverseDoit = true;
        this.traverseCancel = true;
        switch (n2) {
            case 0x1000012: {
                if (OS.QSwtTimeEdit_cursorPosition(this.internal_topHandle()) <= 0) break;
                this.traverseDoit = false;
                this.traverseCancel = false;
                break;
            }
            case 0x1000014: {
                if (OS.QSwtTimeEdit_cursorPosition(this.internal_topHandle()) >= OS.QSwtTimeEdit_textLength(this.internal_topHandle())) break;
                this.traverseDoit = false;
                this.traverseCancel = false;
                break;
            }
            case 0x1000013: 
            case 0x1000015: {
                this.traverseDoit = false;
                this.traverseCancel = false;
                break;
            }
            case 0x1000004: 
            case 0x1000005: 
            case 0x1000010: 
            case 0x1000011: 
            case 0x1000016: 
            case 0x1000017: {
                this.traverseDoit = false;
                this.traverseCancel = false;
                break;
            }
        }
    }
}

